/* -*- Mode: javascript; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */

var EXPORTED_SYMBOLS = [ "cairo" ];

const CAIRO_LIBNAME = "cairo";
const CAIRO_ABIS    = [ 2 ];

const Cu = Components.utils;
const Cc = Components.classes;
const Ci = Components.interfaces;

Cu.import("resource://gre/modules/ctypes.jsm");
Cu.import("resource://firetray/ctypes/ctypes-utils.jsm");

function cairo_defines(lib) {
  this.cairo_t = ctypes.StructType("cairo_t");

  lib.lazy_bind("cairo_rectangle", ctypes.void_t, this.cairo_t.ptr, ctypes.double, ctypes.double, ctypes.double, ctypes.double);
  lib.lazy_bind("cairo_set_source_rgb", ctypes.void_t, this.cairo_t.ptr, ctypes.double, ctypes.double, ctypes.double);
  lib.lazy_bind("cairo_fill", ctypes.void_t, this.cairo_t.ptr);
  lib.lazy_bind("cairo_move_to", ctypes.void_t, this.cairo_t.ptr, ctypes.double, ctypes.double);
  lib.lazy_bind("cairo_destroy", ctypes.void_t, this.cairo_t.ptr);

}

new ctypes_library(CAIRO_LIBNAME, CAIRO_ABIS, cairo_defines, this);
