
#
# Completions for the darcs command
# This file was autogenerated by the file make_vcs_completions.fish
# which is shipped with the fish source code.
#

#
# Completions from commandline
#

complete -c darcs -n "not __fish_use_subcommand" -a "(test -f _darcs/prefs/repos; and cat _darcs/prefs/repos)" --description "Darcs repo"
complete -c darcs -a "test predist boringfile binariesfile" -n "contains setpref (commandline -poc)" --description "Set the specified option" -x

#
# subcommands
#

complete -c darcs -n '__fish_use_subcommand' -x -a help --description 'Display help for darcs or a single commands'
complete -c darcs -n '__fish_use_subcommand' -x -a add --description 'Add one or more new files or directories'
complete -c darcs -n '__fish_use_subcommand' -x -a remove --description 'Remove one or more files or directories from the repository'
complete -c darcs -n '__fish_use_subcommand' -x -a mv --description 'Move/rename one or more files or directories'
complete -c darcs -n '__fish_use_subcommand' -x -a replace --description 'Replace a token with a new value for that token'
complete -c darcs -n '__fish_use_subcommand' -x -a revert --description 'Revert to the recorded version (safe the first time only)'
complete -c darcs -n '__fish_use_subcommand' -x -a unrevert --description 'Undo the last revert (may fail if changes after the revert)'
complete -c darcs -n '__fish_use_subcommand' -x -a whatsnew --description 'Display unrecorded changes in the working copy'
complete -c darcs -n '__fish_use_subcommand' -x -a record --description 'Save changes in the working copy to the repository as a patch'
complete -c darcs -n '__fish_use_subcommand' -x -a unrecord --description 'Remove recorded patches without changing the working copy'
complete -c darcs -n '__fish_use_subcommand' -x -a amend-record --description 'Replace a patch with a better version before it leaves your repository'
complete -c darcs -n '__fish_use_subcommand' -x -a resolve --description 'Mark any conflicts to the working copy for manual resolution'
complete -c darcs -n '__fish_use_subcommand' -x -a tag --description 'Tag the contents of the repository with a version name'
complete -c darcs -n '__fish_use_subcommand' -x -a setpref --description 'Set a value for a preference (test, predist, ...)'
complete -c darcs -n '__fish_use_subcommand' -x -a rollback --description 'Record an inverse patch without changing the working directory'
complete -c darcs -n '__fish_use_subcommand' -x -a diff --description 'Create a diff between two versions of the repository'
complete -c darcs -n '__fish_use_subcommand' -x -a changes --description 'Gives a changelog-style summary of the repository history'
complete -c darcs -n '__fish_use_subcommand' -x -a annotate --description 'Display which patch last modified something'
complete -c darcs -n '__fish_use_subcommand' -x -a dist --description 'Create a distribution tarball'
complete -c darcs -n '__fish_use_subcommand' -x -a trackdown --description 'Locate the most recent version lacking an error'
complete -c darcs -n '__fish_use_subcommand' -x -a query --description 'Query information which is stored by darcs'
complete -c darcs -n '__fish_use_subcommand' -x -a pull --description 'Copy and apply patches from another repository to this one'
complete -c darcs -n '__fish_use_subcommand' -x -a unpull --description 'Opposite of pull; unsafe if patch is not in remote repository'
complete -c darcs -n '__fish_use_subcommand' -x -a obliterate --description 'Delete selected patches from the repository. (UNSAFE!)'
complete -c darcs -n '__fish_use_subcommand' -x -a push --description 'Copy and apply patches from this repository to another one'
complete -c darcs -n '__fish_use_subcommand' -x -a send --description 'Send by email a bundle of one or more patches'
complete -c darcs -n '__fish_use_subcommand' -x -a apply --description 'Apply patches (from an email bundle) to the repository'
complete -c darcs -n '__fish_use_subcommand' -x -a get --description 'Create a local copy of another repository'
complete -c darcs -n '__fish_use_subcommand' -x -a put --description 'Makes a copy of the repository'
complete -c darcs -n '__fish_use_subcommand' -x -a initialize --description 'Initialize a new source tree as a darcs repository'
complete -c darcs -n '__fish_use_subcommand' -x -a optimize --description 'Optimize the repository'
complete -c darcs -n '__fish_use_subcommand' -x -a check --description 'Check the repository for consistency'
complete -c darcs -n '__fish_use_subcommand' -x -a repair --description 'Repair the corrupted repository'


#
# Completions for the 'help' subcommand
#

complete -c darcs -n 'contains \'help\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'help\' (commandline -poc)' -l standard-verbosity --description 'Don\'t give verbose output'
complete -c darcs -n 'contains \'help\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'help\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'help\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'help\' (commandline -poc)' -l no-posthook --description 'Do not run posthook command'
complete -c darcs -n 'contains \'help\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook. [DEFAULT]'
complete -c darcs -n 'contains \'help\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'


#
# Completions for the 'add' subcommand
#

complete -c darcs -n 'contains \'add\' (commandline -poc)' -l boring --description 'Don\'t skip boring files'
complete -c darcs -n 'contains \'add\' (commandline -poc)' -l case-ok --description 'Don\'t refuse to add files differing only in case'
complete -c darcs -n 'contains \'add\' (commandline -poc)' -s r -l recursive --description 'Add contents of subdirectories'
complete -c darcs -n 'contains \'add\' (commandline -poc)' -l not-recursive --description 'Don\'t add contents of subdirectories'
complete -c darcs -n 'contains \'add\' (commandline -poc)' -l date-trick --description 'Add files with date appended to avoid conflict. [EXPERIMENTAL]'
complete -c darcs -n 'contains \'add\' (commandline -poc)' -l no-date-trick --description 'Don\'t use experimental date appending trick. [DEFAULT]'
complete -c darcs -n 'contains \'add\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'add\' (commandline -poc)' -s q -l quiet --description 'Suppress informational output'
complete -c darcs -n 'contains \'add\' (commandline -poc)' -l standard-verbosity --description 'Neither verbose nor quiet output'
complete -c darcs -n 'contains \'add\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'add\' (commandline -poc)' -l dry-run --description 'Don\'t actually take the action'
complete -c darcs -n 'contains \'add\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'add\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'add\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'add\' (commandline -poc)' -l no-posthook --description 'Do not run posthook command'
complete -c darcs -n 'contains \'add\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook. [DEFAULT]'
complete -c darcs -n 'contains \'add\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'


#
# Completions for the 'remove' subcommand
#

complete -c darcs -n 'contains \'remove\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'remove\' (commandline -poc)' -l standard-verbosity --description 'Don\'t give verbose output'
complete -c darcs -n 'contains \'remove\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'remove\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'remove\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'remove\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'remove\' (commandline -poc)' -l no-posthook --description 'Do not run posthook command'
complete -c darcs -n 'contains \'remove\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook. [DEFAULT]'
complete -c darcs -n 'contains \'remove\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'


#
# Completions for the 'mv' subcommand
#

complete -c darcs -n 'contains \'mv\' (commandline -poc)' -l case-ok --description 'Don\'t refuse to add files differing only in case'
complete -c darcs -n 'contains \'mv\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'mv\' (commandline -poc)' -l standard-verbosity --description 'Don\'t give verbose output'
complete -c darcs -n 'contains \'mv\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'mv\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'mv\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'mv\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'mv\' (commandline -poc)' -l no-posthook --description 'Do not run posthook command'
complete -c darcs -n 'contains \'mv\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook. [DEFAULT]'
complete -c darcs -n 'contains \'mv\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'


#
# Completions for the 'replace' subcommand
#

complete -c darcs -n 'contains \'replace\' (commandline -poc)' -l token-chars -x --description 'Define token to contain these characters'
complete -c darcs -n 'contains \'replace\' (commandline -poc)' -s f -l force --description 'Proceed with replace even if \'new\' token already exists'
complete -c darcs -n 'contains \'replace\' (commandline -poc)' -l no-force --description 'Don\'t force the replace if it looks scary'
complete -c darcs -n 'contains \'replace\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'replace\' (commandline -poc)' -l standard-verbosity --description 'Don\'t give verbose output'
complete -c darcs -n 'contains \'replace\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'replace\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'replace\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'replace\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'replace\' (commandline -poc)' -l no-posthook --description 'Do not run posthook command'
complete -c darcs -n 'contains \'replace\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook. [DEFAULT]'
complete -c darcs -n 'contains \'replace\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'


#
# Completions for the 'revert' subcommand
#

complete -c darcs -n 'contains \'revert\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'revert\' (commandline -poc)' -l standard-verbosity --description 'Don\'t give verbose output'
complete -c darcs -n 'contains \'revert\' (commandline -poc)' -l ignore-times --description 'Don\'t trust the file modification times'
complete -c darcs -n 'contains \'revert\' (commandline -poc)' -s a -l all --description 'Answer yes to all patches'
complete -c darcs -n 'contains \'revert\' (commandline -poc)' -s i -l interactive --description 'Prompt user interactively'
complete -c darcs -n 'contains \'revert\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'revert\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'revert\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'revert\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'revert\' (commandline -poc)' -l no-posthook --description 'Do not run posthook command'
complete -c darcs -n 'contains \'revert\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook. [DEFAULT]'
complete -c darcs -n 'contains \'revert\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'


#
# Completions for the 'unrevert' subcommand
#

complete -c darcs -n 'contains \'unrevert\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'unrevert\' (commandline -poc)' -l standard-verbosity --description 'Don\'t give verbose output'
complete -c darcs -n 'contains \'unrevert\' (commandline -poc)' -l ignore-times --description 'Don\'t trust the file modification times'
complete -c darcs -n 'contains \'unrevert\' (commandline -poc)' -s a -l all --description 'Answer yes to all patches'
complete -c darcs -n 'contains \'unrevert\' (commandline -poc)' -s i -l interactive --description 'Prompt user interactively'
complete -c darcs -n 'contains \'unrevert\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'unrevert\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'unrevert\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'unrevert\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'unrevert\' (commandline -poc)' -l no-posthook --description 'Do not run posthook command'
complete -c darcs -n 'contains \'unrevert\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook. [DEFAULT]'
complete -c darcs -n 'contains \'unrevert\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'


#
# Completions for the 'whatsnew' subcommand
#

complete -c darcs -n 'contains \'whatsnew\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'whatsnew\' (commandline -poc)' -l standard-verbosity --description 'Don\'t give verbose output'
complete -c darcs -n 'contains \'whatsnew\' (commandline -poc)' -s s -l summary --description 'Summarize changes'
complete -c darcs -n 'contains \'whatsnew\' (commandline -poc)' -l no-summary --description 'Don\'t summarize changes'
complete -c darcs -n 'contains \'whatsnew\' (commandline -poc)' -s u -l unified --description 'Output patch in a darcs-specific format similar to diff -u'
complete -c darcs -n 'contains \'whatsnew\' (commandline -poc)' -l ignore-times --description 'Don\'t trust the file modification times'
complete -c darcs -n 'contains \'whatsnew\' (commandline -poc)' -s l -l look-for-adds --description 'In addition to modifications, look for files that are not boring, and thus are potentially pending addition'
complete -c darcs -n 'contains \'whatsnew\' (commandline -poc)' -l dont-look-for-adds --description 'Don\'t look for any files or directories that could be added, and don\'t add them automatically'
complete -c darcs -n 'contains \'whatsnew\' (commandline -poc)' -l boring --description 'Don\'t skip boring files'
complete -c darcs -n 'contains \'whatsnew\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'whatsnew\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'whatsnew\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'whatsnew\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'whatsnew\' (commandline -poc)' -l no-posthook --description 'Do not run posthook command'
complete -c darcs -n 'contains \'whatsnew\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook. [DEFAULT]'
complete -c darcs -n 'contains \'whatsnew\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'


#
# Completions for the 'record' subcommand
#

complete -c darcs -n 'contains \'record\' (commandline -poc)' -s m -l patch-name -x --description 'Name of patch'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -s A -l author -x --description 'Specify author id'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l logfile -r --description 'Give patch name and comment in file'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l delete-logfile --description 'Delete the logfile when done'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l standard-verbosity --description 'Don\'t give verbose output'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l no-test --description 'Don\'t run the test script'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l test --description 'Run the test script'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l leave-test-directory --description 'Don\'t remove the test directory'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l remove-test-directory --description 'Remove the test directory'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l compress --description 'Create compressed patches'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l dont-compress --description 'Don\'t create compressed patches'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -s a -l all --description 'Answer yes to all patches'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l pipe --description 'Expect to receive input from a pipe'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -s i -l interactive --description 'Prompt user interactively'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l ask-deps --description 'Ask for extra dependencies'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l no-ask-deps --description 'Don\'t ask for extra dependencies'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l edit-long-comment --description 'Edit the long comment by default'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l skip-long-comment --description 'Don\'t give a long comment'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l prompt-long-comment --description 'Prompt for whether to edit the long comment'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l ignore-times --description 'Don\'t trust the file modification times'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -s l -l look-for-adds --description 'In addition to modifications, look for files that are not boring, and thus are potentially pending addition'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l dont-look-for-adds --description 'Don\'t look for any files or directories that could be added, and don\'t add them automatically'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l no-posthook --description 'Do not run posthook command'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook. [DEFAULT]'
complete -c darcs -n 'contains \'record\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'


#
# Completions for the 'unrecord' subcommand
#

complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -l from-match -x --description 'Select changes starting with a patch matching PATTERN'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -l from-patch -x --description 'Select changes starting with a patch matching REGEXP'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -l from-tag -x --description 'Select changes starting with a tag matching REGEXP'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -l last -x --description 'Select the last NUMBER patches'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -l matches -x --description 'Select patches matching PATTERN'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -s p -l patches -x --description 'Select patches matching REGEXP'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -s t -l tags -x --description 'Select tags matching REGEXP'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -l standard-verbosity --description 'Don\'t give verbose output'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -l compress --description 'Create compressed patches'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -l dont-compress --description 'Don\'t create compressed patches'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -l no-posthook --description 'Do not run posthook command'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook. [DEFAULT]'
complete -c darcs -n 'contains \'unrecord\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'


#
# Completions for the 'amend-record' subcommand
#

complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -l match -x --description 'Select patch matching PATTERN'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -s p -l patch -x --description 'Select patch matching REGEXP'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -l standard-verbosity --description 'Don\'t give verbose output'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -l no-test --description 'Don\'t run the test script'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -l test --description 'Run the test script'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -l leave-test-directory --description 'Don\'t remove the test directory'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -l remove-test-directory --description 'Remove the test directory'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -l compress --description 'Create compressed patches'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -l dont-compress --description 'Don\'t create compressed patches'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -s a -l all --description 'Answer yes to all patches'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -s i -l interactive --description 'Prompt user interactively'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -l ignore-times --description 'Don\'t trust the file modification times'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -s l -l look-for-adds --description 'In addition to modifications, look for files that are not boring, and thus are potentially pending addition'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -l dont-look-for-adds --description 'Don\'t look for any files or directories that could be added, and don\'t add them automatically'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -l no-posthook --description 'Do not run posthook command'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook. [DEFAULT]'
complete -c darcs -n 'contains \'amend-record\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'


#
# Completions for the 'resolve' subcommand
#

complete -c darcs -n 'contains \'resolve\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'resolve\' (commandline -poc)' -l standard-verbosity --description 'Don\'t give verbose output'
complete -c darcs -n 'contains \'resolve\' (commandline -poc)' -l ignore-times --description 'Don\'t trust the file modification times'
complete -c darcs -n 'contains \'resolve\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'resolve\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'resolve\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'resolve\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'resolve\' (commandline -poc)' -l no-posthook --description 'Do not run posthook command'
complete -c darcs -n 'contains \'resolve\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook. [DEFAULT]'
complete -c darcs -n 'contains \'resolve\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'


#
# Completions for the 'tag' subcommand
#

complete -c darcs -n 'contains \'tag\' (commandline -poc)' -s m -l patch-name -x --description 'Name of patch'
complete -c darcs -n 'contains \'tag\' (commandline -poc)' -s A -l author -x --description 'Specify author id'
complete -c darcs -n 'contains \'tag\' (commandline -poc)' -l checkpoint --description 'Create a checkpoint file'
complete -c darcs -n 'contains \'tag\' (commandline -poc)' -l compress --description 'Create compressed patches'
complete -c darcs -n 'contains \'tag\' (commandline -poc)' -l dont-compress --description 'Don\'t create compressed patches'
complete -c darcs -n 'contains \'tag\' (commandline -poc)' -l pipe --description 'Expect to receive input from a pipe'
complete -c darcs -n 'contains \'tag\' (commandline -poc)' -s i -l interactive --description 'Prompt user interactively'
complete -c darcs -n 'contains \'tag\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'tag\' (commandline -poc)' -l standard-verbosity --description 'Don\'t give verbose output'
complete -c darcs -n 'contains \'tag\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'tag\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'tag\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'tag\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'tag\' (commandline -poc)' -l no-posthook --description 'Do not run posthook command'
complete -c darcs -n 'contains \'tag\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook. [DEFAULT]'
complete -c darcs -n 'contains \'tag\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'


#
# Completions for the 'setpref' subcommand
#

complete -c darcs -n 'contains \'setpref\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'setpref\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'setpref\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'setpref\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'setpref\' (commandline -poc)' -l no-posthook --description 'Do not run posthook command'
complete -c darcs -n 'contains \'setpref\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook. [DEFAULT]'
complete -c darcs -n 'contains \'setpref\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'


#
# Completions for the 'rollback' subcommand
#

complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -l match -x --description 'Select patch matching PATTERN'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -s p -l patch -x --description 'Select patch matching REGEXP'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -l compress --description 'Create compressed patches'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -l dont-compress --description 'Don\'t create compressed patches'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -l standard-verbosity --description 'Don\'t give verbose output'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -l no-posthook --description 'Do not run posthook command'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook. [DEFAULT]'
complete -c darcs -n 'contains \'rollback\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'


#
# Completions for the 'diff' subcommand
#

complete -c darcs -n 'contains \'diff\' (commandline -poc)' -l to-match -x --description 'Select changes up to a patch matching PATTERN'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -l to-patch -x --description 'Select changes up to a patch matching REGEXP'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -l to-tag -x --description 'Select changes up to a tag matching REGEXP'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -l from-match -x --description 'Select changes starting with a patch matching PATTERN'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -l from-patch -x --description 'Select changes starting with a patch matching REGEXP'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -l from-tag -x --description 'Select changes starting with a tag matching REGEXP'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -l match -x --description 'Select a single patch matching PATTERN'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -s p -l patch -x --description 'Select a single patch matching REGEXP'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -l last -x --description 'Select the last NUMBER patches'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -l diff-command -x -a '(__fish_complete_command)' --description 'Specify diff command (ignores --diff-opts)'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -l diff-opts -x --description 'Options to pass to diff'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -s u -l unified --description 'Pass -u option to diff'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -l no-posthook --description 'Do not run posthook command'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook. [DEFAULT]'
complete -c darcs -n 'contains \'diff\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'


#
# Completions for the 'changes' subcommand
#

complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l to-match -x --description 'Select changes up to a patch matching PATTERN'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l to-patch -x --description 'Select changes up to a patch matching REGEXP'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l to-tag -x --description 'Select changes up to a tag matching REGEXP'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l from-match -x --description 'Select changes starting with a patch matching PATTERN'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l from-patch -x --description 'Select changes starting with a patch matching REGEXP'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l from-tag -x --description 'Select changes starting with a tag matching REGEXP'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l last -x --description 'Select the last NUMBER patches'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l matches -x --description 'Select patches matching PATTERN'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -s p -l patches -x --description 'Select patches matching REGEXP'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -s t -l tags -x --description 'Select tags matching REGEXP'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l context --description 'Give output suitable for get --context'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l xml-output --description 'Generate XML formatted output'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l human-readable --description 'Give human-readable output'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -s s -l summary --description 'Summarize changes'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l no-summary --description 'Don\'t summarize changes'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -s q -l quiet --description 'Suppress informational output'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l standard-verbosity --description 'Neither verbose nor quiet output'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l reverse --description 'Show changes in reverse order'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l repo -x --description 'Specify the repository URL'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -s a -l all --description 'Answer yes to all patches'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -s i -l interactive --description 'Prompt user interactively'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l no-posthook --description 'Do not run posthook command'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook. [DEFAULT]'
complete -c darcs -n 'contains \'changes\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'


#
# Completions for the 'annotate' subcommand
#

complete -c darcs -n 'contains \'annotate\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'annotate\' (commandline -poc)' -l standard-verbosity --description 'Don\'t give verbose output'
complete -c darcs -n 'contains \'annotate\' (commandline -poc)' -s s -l summary --description 'Summarize changes'
complete -c darcs -n 'contains \'annotate\' (commandline -poc)' -l no-summary --description 'Don\'t summarize changes'
complete -c darcs -n 'contains \'annotate\' (commandline -poc)' -s u -l unified --description 'Output patch in a darcs-specific format similar to diff -u'
complete -c darcs -n 'contains \'annotate\' (commandline -poc)' -l human-readable --description 'Give human-readable output'
complete -c darcs -n 'contains \'annotate\' (commandline -poc)' -l xml-output --description 'Generate XML formatted output'
complete -c darcs -n 'contains \'annotate\' (commandline -poc)' -l match -x --description 'Select patch matching PATTERN'
complete -c darcs -n 'contains \'annotate\' (commandline -poc)' -s p -l patch -x --description 'Select patch matching REGEXP'
complete -c darcs -n 'contains \'annotate\' (commandline -poc)' -s t -l tag -x --description 'Select tag matching REGEXP'
complete -c darcs -n 'contains \'annotate\' (commandline -poc)' -l creator-hash -x --description 'Specify hash of creator patch (see docs)'
complete -c darcs -n 'contains \'annotate\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'annotate\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'annotate\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'annotate\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'annotate\' (commandline -poc)' -l no-posthook --description 'Do not run posthook command'
complete -c darcs -n 'contains \'annotate\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook. [DEFAULT]'
complete -c darcs -n 'contains \'annotate\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'


#
# Completions for the 'dist' subcommand
#

complete -c darcs -n 'contains \'dist\' (commandline -poc)' -s d -l dist-name -x --description 'Name of version'
complete -c darcs -n 'contains \'dist\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'dist\' (commandline -poc)' -l standard-verbosity --description 'Don\'t give verbose output'
complete -c darcs -n 'contains \'dist\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'dist\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'dist\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'dist\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'dist\' (commandline -poc)' -l no-posthook --description 'Do not run posthook command'
complete -c darcs -n 'contains \'dist\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook. [DEFAULT]'
complete -c darcs -n 'contains \'dist\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'


#
# Completions for the 'trackdown' subcommand
#

complete -c darcs -n 'contains \'trackdown\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'trackdown\' (commandline -poc)' -l standard-verbosity --description 'Don\'t give verbose output'
complete -c darcs -n 'contains \'trackdown\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'trackdown\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'trackdown\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'trackdown\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'trackdown\' (commandline -poc)' -l no-posthook --description 'Do not run posthook command'
complete -c darcs -n 'contains \'trackdown\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook. [DEFAULT]'
complete -c darcs -n 'contains \'trackdown\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'


#
# Completions for the 'query' subcommand
#

complete -c darcs -n 'contains \'query\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'


#
# Completions for the 'pull' subcommand
#

complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l matches -x --description 'Select patches matching PATTERN'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -s p -l patches -x --description 'Select patches matching REGEXP'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -s t -l tags -x --description 'Select tags matching REGEXP'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -s a -l all --description 'Answer yes to all patches'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -s i -l interactive --description 'Prompt user interactively'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l intersection --description 'Take intersection of all repositories'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l union --description 'Take union of all repositories [default]'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l external-merge -x -a '(__fish_complete_command)' --description 'Use external tool to merge conflicts'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l compress --description 'Create compressed patches'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l dont-compress --description 'Don\'t create compressed patches'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l test --description 'Run the test script'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l no-test --description 'Don\'t run the test script'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l dry-run --description 'Don\'t actually take the action'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -s s -l summary --description 'Summarize changes'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l no-summary --description 'Don\'t summarize changes'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -s q -l quiet --description 'Suppress informational output'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l standard-verbosity --description 'Neither verbose nor quiet output'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l ignore-times --description 'Don\'t trust the file modification times'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l no-deps --description 'Don\'t automatically fulfill dependencies'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l set-default --description 'Set default repository [DEFAULT]'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l no-set-default --description 'Don\'t set default repository'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l set-scripts-executable --description 'Make scripts executable'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l dont-set-scripts-executable --description 'Don\'t make scripts executable'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l disable-ssh-cm --description 'Disable use of SSH ControlMaster feature'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l no-posthook --description 'Do not run posthook command'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook. [DEFAULT]'
complete -c darcs -n 'contains \'pull\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'


#
# Completions for the 'unpull' subcommand
#

complete -c darcs -n 'contains \'unpull\' (commandline -poc)' -l from-match -x --description 'Select changes starting with a patch matching PATTERN'
complete -c darcs -n 'contains \'unpull\' (commandline -poc)' -l from-patch -x --description 'Select changes starting with a patch matching REGEXP'
complete -c darcs -n 'contains \'unpull\' (commandline -poc)' -l from-tag -x --description 'Select changes starting with a tag matching REGEXP'
complete -c darcs -n 'contains \'unpull\' (commandline -poc)' -l last -x --description 'Select the last NUMBER patches'
complete -c darcs -n 'contains \'unpull\' (commandline -poc)' -l matches -x --description 'Select patches matching PATTERN'
complete -c darcs -n 'contains \'unpull\' (commandline -poc)' -s p -l patches -x --description 'Select patches matching REGEXP'
complete -c darcs -n 'contains \'unpull\' (commandline -poc)' -s t -l tags -x --description 'Select tags matching REGEXP'
complete -c darcs -n 'contains \'unpull\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'unpull\' (commandline -poc)' -l standard-verbosity --description 'Don\'t give verbose output'
complete -c darcs -n 'contains \'unpull\' (commandline -poc)' -l compress --description 'Create compressed patches'
complete -c darcs -n 'contains \'unpull\' (commandline -poc)' -l dont-compress --description 'Don\'t create compressed patches'
complete -c darcs -n 'contains \'unpull\' (commandline -poc)' -l ignore-times --description 'Don\'t trust the file modification times'
complete -c darcs -n 'contains \'unpull\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'unpull\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'unpull\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'unpull\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'unpull\' (commandline -poc)' -l no-posthook --description 'Do not run posthook command'
complete -c darcs -n 'contains \'unpull\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook. [DEFAULT]'
complete -c darcs -n 'contains \'unpull\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'


#
# Completions for the 'obliterate' subcommand
#

complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -l from-match -x --description 'Select changes starting with a patch matching PATTERN'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -l from-patch -x --description 'Select changes starting with a patch matching REGEXP'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -l from-tag -x --description 'Select changes starting with a tag matching REGEXP'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -l last -x --description 'Select the last NUMBER patches'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -l matches -x --description 'Select patches matching PATTERN'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -s p -l patches -x --description 'Select patches matching REGEXP'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -s t -l tags -x --description 'Select tags matching REGEXP'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -l standard-verbosity --description 'Don\'t give verbose output'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -l compress --description 'Create compressed patches'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -l dont-compress --description 'Don\'t create compressed patches'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -l ignore-times --description 'Don\'t trust the file modification times'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -l no-posthook --description 'Do not run posthook command'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook. [DEFAULT]'
complete -c darcs -n 'contains \'obliterate\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'


#
# Completions for the 'push' subcommand
#

complete -c darcs -n 'contains \'push\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -s q -l quiet --description 'Suppress informational output'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l standard-verbosity --description 'Neither verbose nor quiet output'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l matches -x --description 'Select patches matching PATTERN'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -s p -l patches -x --description 'Select patches matching REGEXP'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -s t -l tags -x --description 'Select tags matching REGEXP'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -s a -l all --description 'Answer yes to all patches'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -s i -l interactive --description 'Prompt user interactively'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l apply-as -x -a '(__fish_complete_users)' --description 'Apply patch as another user using sudo'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l apply-as-myself --description 'Don\'t use sudo to apply as another user [DEFAULT]'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l sign --description 'Sign the patch with your gpg key'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l sign-as -x --description 'Sign the patch with a given keyid'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l sign-ssl -x --description 'Sign the patch using openssl with a given private key'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l dont-sign --description 'Do not sign the patch'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l dry-run --description 'Don\'t actually take the action'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -s s -l summary --description 'Summarize changes'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l no-summary --description 'Don\'t summarize changes'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l disable-ssh-cm --description 'Disable use of SSH ControlMaster feature'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l set-default --description 'Set default repository [DEFAULT]'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l no-set-default --description 'Don\'t set default repository'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l no-posthook --description 'Do not run posthook command'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook. [DEFAULT]'
complete -c darcs -n 'contains \'push\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'


#
# Completions for the 'send' subcommand
#

complete -c darcs -n 'contains \'send\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -s q -l quiet --description 'Suppress informational output'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l standard-verbosity --description 'Neither verbose nor quiet output'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l matches -x --description 'Select patches matching PATTERN'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -s p -l patches -x --description 'Select patches matching REGEXP'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -s t -l tags -x --description 'Select tags matching REGEXP'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -s a -l all --description 'Answer yes to all patches'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -s i -l interactive --description 'Prompt user interactively'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l from -x --description 'Specify email address'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -s A -l author -x --description 'Specify author id'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l to -x --description 'Specify destination email'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l cc -x --description 'Mail results to additional EMAIL(s). Requires --reply'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l subject -x --description 'Specify mail subject'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -s o -l output -r --description 'Specify output filename'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l sign --description 'Sign the patch with your gpg key'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l sign-as -x --description 'Sign the patch with a given keyid'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l sign-ssl -x --description 'Sign the patch using openssl with a given private key'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l dont-sign --description 'Do not sign the patch'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -s u -l unified --description 'Output patch in a darcs-specific format similar to diff -u'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l dry-run --description 'Don\'t actually take the action'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -s s -l summary --description 'Summarize changes'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l no-summary --description 'Don\'t summarize changes'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l context -r --description 'Send to context stored in FILENAME'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l edit-description --description 'Edit the patch bundle description'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l dont-edit-description --description 'Don\'t edit the patch bundle description'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l logfile -r --description 'Give patch name and comment in file'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l delete-logfile --description 'Delete the logfile when done'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l set-default --description 'Set default repository [DEFAULT]'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l no-set-default --description 'Don\'t set default repository'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l sendmail-command -x -a '(__fish_complete_command)' --description 'Specify sendmail command'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l no-posthook --description 'Do not run posthook command'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook. [DEFAULT]'
complete -c darcs -n 'contains \'send\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'


#
# Completions for the 'apply' subcommand
#

complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l verify -x --description 'Verify that the patch was signed by a key in PUBRING'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l verify-ssl -x --description 'Verify using openSSL with authorized keys from file KEYS'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l no-verify --description 'Don\'t verify patch signature'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l reply -x --description 'Reply to email-based patch using FROM address'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l cc -x --description 'Mail results to additional EMAIL(s). Requires --reply'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l standard-verbosity --description 'Don\'t give verbose output'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l ignore-times --description 'Don\'t trust the file modification times'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l compress --description 'Create compressed patches'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l dont-compress --description 'Don\'t create compressed patches'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -s a -l all --description 'Answer yes to all patches'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -s i -l interactive --description 'Prompt user interactively'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l mark-conflicts --description 'Mark conflicts'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l allow-conflicts --description 'Allow conflicts, but don\'t mark them'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l external-merge -x -a '(__fish_complete_command)' --description 'Use external tool to merge conflicts'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l no-resolve-conflicts --description 'Equivalent to --dont-allow-conflicts, for backwards compatibility'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l dont-allow-conflicts --description 'Fail on patches that create conflicts [DEFAULT]'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l no-test --description 'Don\'t run the test script'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l test --description 'Run the test script'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l happy-forwarding --description 'Forward unsigned messages without extra header'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l leave-test-directory --description 'Don\'t remove the test directory'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l remove-test-directory --description 'Remove the test directory'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l sendmail-command -x -a '(__fish_complete_command)' --description 'Specify sendmail command'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l set-scripts-executable --description 'Make scripts executable'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l dont-set-scripts-executable --description 'Don\'t make scripts executable'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l no-posthook --description 'Do not run posthook command'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook. [DEFAULT]'
complete -c darcs -n 'contains \'apply\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'


#
# Completions for the 'get' subcommand
#

complete -c darcs -n 'contains \'get\' (commandline -poc)' -l repo-name -x -a '(__fish_complete_directories (commandline -ct))' --description 'Path of output directory'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l partial --description 'Get partial repository using checkpoint'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l complete --description 'Get a complete copy of the repository'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l to-match -x --description 'Select changes up to a patch matching PATTERN'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l to-patch -x --description 'Select changes up to a patch matching REGEXP'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l tag -x --description 'Select tag matching REGEXP'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l context -r --description 'Version specified by the context in FILENAME'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -s q -l quiet --description 'Suppress informational output'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l standard-verbosity --description 'Neither verbose nor quiet output'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l set-default --description 'Set default repository [DEFAULT]'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l no-set-default --description 'Don\'t set default repository'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l set-scripts-executable --description 'Make scripts executable'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l dont-set-scripts-executable --description 'Don\'t make scripts executable'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l plain-pristine-tree --description 'Use a plain pristine tree [DEFAULT]'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l no-pristine-tree --description 'Use no pristine tree'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l disable-ssh-cm --description 'Disable use of SSH ControlMaster feature'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l no-posthook --description 'Do not run posthook command'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook. [DEFAULT]'
complete -c darcs -n 'contains \'get\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'


#
# Completions for the 'put' subcommand
#

complete -c darcs -n 'contains \'put\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -s q -l quiet --description 'Suppress informational output'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -l standard-verbosity --description 'Neither verbose nor quiet output'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -l to-match -x --description 'Select changes up to a patch matching PATTERN'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -l to-patch -x --description 'Select changes up to a patch matching REGEXP'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -l tag -x --description 'Select tag matching REGEXP'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -l context -r --description 'Version specified by the context in FILENAME'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -l apply-as -x -a '(__fish_complete_users)' --description 'Apply patch as another user using sudo'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -l apply-as-myself --description 'Don\'t use sudo to apply as another user [DEFAULT]'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -l plain-pristine-tree --description 'Use a plain pristine tree [DEFAULT]'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -l no-pristine-tree --description 'Use no pristine tree'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -l disable-ssh-cm --description 'Disable use of SSH ControlMaster feature'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -l no-posthook --description 'Do not run posthook command'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook. [DEFAULT]'
complete -c darcs -n 'contains \'put\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'


#
# Completions for the 'initialize' subcommand
#

complete -c darcs -n 'contains \'initialize\' (commandline -poc)' -l plain-pristine-tree --description 'Use a plain pristine tree [DEFAULT]'
complete -c darcs -n 'contains \'initialize\' (commandline -poc)' -l no-pristine-tree --description 'Use no pristine tree'
complete -c darcs -n 'contains \'initialize\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'initialize\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'initialize\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'initialize\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'initialize\' (commandline -poc)' -l no-posthook --description 'Do not run posthook command'
complete -c darcs -n 'contains \'initialize\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook. [DEFAULT]'
complete -c darcs -n 'contains \'initialize\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'


#
# Completions for the 'optimize' subcommand
#

complete -c darcs -n 'contains \'optimize\' (commandline -poc)' -l checkpoint --description 'Create a checkpoint file'
complete -c darcs -n 'contains \'optimize\' (commandline -poc)' -l compress --description 'Create compressed patches'
complete -c darcs -n 'contains \'optimize\' (commandline -poc)' -l dont-compress --description 'Don\'t create compressed patches'
complete -c darcs -n 'contains \'optimize\' (commandline -poc)' -l uncompress --description 'Uncompress patches'
complete -c darcs -n 'contains \'optimize\' (commandline -poc)' -s t -l tag -x --description 'Name of version to checkpoint'
complete -c darcs -n 'contains \'optimize\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'optimize\' (commandline -poc)' -l standard-verbosity --description 'Don\'t give verbose output'
complete -c darcs -n 'contains \'optimize\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'optimize\' (commandline -poc)' -l modernize-patches --description 'Rewrite all patches in current darcs format'
complete -c darcs -n 'contains \'optimize\' (commandline -poc)' -l reorder-patches --description 'Reorder the patches in the repository'
complete -c darcs -n 'contains \'optimize\' (commandline -poc)' -l sibling -x --description 'Specify a sibling directory'
complete -c darcs -n 'contains \'optimize\' (commandline -poc)' -l relink --description 'Relink random internal data to a sibling'
complete -c darcs -n 'contains \'optimize\' (commandline -poc)' -l relink-pristine --description 'Relink pristine tree (not recommended)'
complete -c darcs -n 'contains \'optimize\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'optimize\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'optimize\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'optimize\' (commandline -poc)' -l no-posthook --description 'Do not run posthook command'
complete -c darcs -n 'contains \'optimize\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook. [DEFAULT]'
complete -c darcs -n 'contains \'optimize\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'


#
# Completions for the 'check' subcommand
#

complete -c darcs -n 'contains \'check\' (commandline -poc)' -l complete --description 'Check the entire repository'
complete -c darcs -n 'contains \'check\' (commandline -poc)' -l partial --description 'Check patches since latest checkpoint'
complete -c darcs -n 'contains \'check\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'check\' (commandline -poc)' -s q -l quiet --description 'Suppress informational output'
complete -c darcs -n 'contains \'check\' (commandline -poc)' -l standard-verbosity --description 'Neither verbose nor quiet output'
complete -c darcs -n 'contains \'check\' (commandline -poc)' -l no-test --description 'Don\'t run the test script'
complete -c darcs -n 'contains \'check\' (commandline -poc)' -l test --description 'Run the test script'
complete -c darcs -n 'contains \'check\' (commandline -poc)' -l leave-test-directory --description 'Don\'t remove the test directory'
complete -c darcs -n 'contains \'check\' (commandline -poc)' -l remove-test-directory --description 'Remove the test directory'
complete -c darcs -n 'contains \'check\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'check\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'check\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'check\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'check\' (commandline -poc)' -l no-posthook --description 'Do not run posthook command'
complete -c darcs -n 'contains \'check\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook. [DEFAULT]'
complete -c darcs -n 'contains \'check\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'


#
# Completions for the 'repair' subcommand
#

complete -c darcs -n 'contains \'repair\' (commandline -poc)' -s v -l verbose --description 'Give verbose output'
complete -c darcs -n 'contains \'repair\' (commandline -poc)' -s q -l quiet --description 'Suppress informational output'
complete -c darcs -n 'contains \'repair\' (commandline -poc)' -l standard-verbosity --description 'Neither verbose nor quiet output'
complete -c darcs -n 'contains \'repair\' (commandline -poc)' -l repodir -x -a '(__fish_complete_directories (commandline -ct))' --description 'Specify the repository directory in which to run'
complete -c darcs -n 'contains \'repair\' (commandline -poc)' -l disable --description 'Disable this command'
complete -c darcs -n 'contains \'repair\' (commandline -poc)' -s h -l help --description 'Shows brief description of command and its arguments'
complete -c darcs -n 'contains \'repair\' (commandline -poc)' -l posthook -x -a '(__fish_complete_command)' --description 'Specify command to run after this darcs command'
complete -c darcs -n 'contains \'repair\' (commandline -poc)' -l no-posthook --description 'Do not run posthook command'
complete -c darcs -n 'contains \'repair\' (commandline -poc)' -l prompt-posthook --description 'Prompt before running posthook. [DEFAULT]'
complete -c darcs -n 'contains \'repair\' (commandline -poc)' -l run-posthook --description 'Run posthook command without prompting'



