/***************************************************************************
 *
 *		File		: poplib.c
 *
 *		Title		: Pop3 connect library
 *
 *		Description	: Connects to port 110 (POP) and uses STAT to check for new
 *						mail.  Prints out debugging code to stderr, and the
 *						result to stdout.  Needs alot of work.  GUI element is
 *						a straight lift from gtk+/examples/buttons/buttons.c.
 *						The networking code is very simple.  This should really
 *						be a corba object called by a corba based gnome-biff.
 *						
 *		Author		: Marcus Leyman (6 May 2001)
 *						(originally) Andrae Muys <andrae@humbug.org.au>
 *
 *		License		: LGPL (latest @ 26 May 1999).
 *
 *		Date		: 26th May 1999
 *
 ***************************************************************************/

#include <sys/socket.h>
#include <sys/types.h>
#include <string.h>
#include <unistd.h>
#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <stdio.h>
#include <stdlib.h>

#include "poplib.h"

popLink *popConnect (char *host)
{
	popLink *link = NULL;
	struct sockaddr_in server;
	struct hostent *hent;
	char response[513]; /* Max length of response */
	int len;

	if (!host)
		return NULL;

	hent = gethostbyname (host);
	if (!hent) {
		return NULL;
	}
	memset (&server, 0, sizeof(server));
	server.sin_family = AF_INET;
	memcpy (&(server.sin_addr.s_addr), hent->h_addr,
				sizeof(server.sin_addr.s_addr));

	server.sin_port = htons (POP_PORT);	

	link = (popLink *)malloc (sizeof(popLink));
	link->state = POP_NONE;
	link->host = NULL;
	link->sd = socket (PF_INET, SOCK_STREAM, 0);
	if (link->sd < 0) {
		return NULL;
	}
	if (connect (link->sd, &server, sizeof(server)) < 0) {
		popDisconnect (link);
		return NULL;
	}

	len = read (link->sd, response, 512);
	response[len] = '\0';
	/* If response != +OK */
	if (strncmp (response, "+OK", 3)) {
		close (link->sd);
		popDisconnect (link);
		return NULL;
	} 

	link->state = POP_AUTH;
	link->host = strdup(host);

	return link;
}

void popDisconnect (popLink *link)
{
	if (link->state != POP_NONE) {
		write (link->sd, "QUIT\r\n", strlen ("QUIT\r\n"));
		close (link->sd);
	}
	free (link->host);
	free (link);
}

char *popStdLogin (popLink *link, char *user, char *pass)
{
	char cmdline[100];  /* Max arg length 40 */
	char response[513]; /* Max length of response */
	int len;

	if (!user || !pass)
		return strdup ("Username/Password unspecified.\n");

	if (link->state != POP_AUTH) {
		return strdup ("Login attempt in invalid state.\n");
	}
	sprintf (cmdline, "USER %s\r\n", user);
	write (link->sd, cmdline, strlen(cmdline));
	len = read (link->sd, response, 512);
	response[len] = '\0';
	/* If response != +OK */
	if (strncmp (response, "+OK", 3)) {
		return strdup(response);
	} 

	sprintf (cmdline, "PASS %s\r\n", pass);
	write (link->sd, cmdline, strlen(cmdline));
	len = read (link->sd, response, 512);
	response[len] = '\0';
	/* If response != +OK */
	if (strncmp (response, "+OK", 3)) {
		return strdup(response);
	} 

	link->state = POP_TRANS;
	return NULL;
}

popStatInfo *popStatistics (popLink *link)
{
	popStatInfo *info;
	char response[513]; /* Max length of response */
	int len;

	info = (popStatInfo *)malloc (sizeof(popStatInfo));
	if (link->state != POP_TRANS) {
		info->err = strdup ("PASS attempt in invalid state.\n");
		return info;
	}
	write (link->sd, "STAT\r\n", strlen("STAT\r\n"));
	len = read (link->sd, response, 512);
	response[len] = '\0';
	/* If response != +OK */
	if (strncmp (response, "+OK", 3)) {
		info->err = strdup(response);
	} else {
		info->err = NULL;
		sscanf (&response[3], "%d %ld", &(info->msgs), &(info->bytes));
	}

	return info;
}
