
#ifndef _FLOWPDU_H_ /* { */
#define _FLOWPDU_H_

/*
 * from "CflowdRawFlow.hh":
 */
#define k_routerMask        0x00000001
#define k_srcIpAddrMask     0x00000002
#define k_dstIpAddrMask     0x00000004
#define k_inputIfIndexMask  0x00000008
#define k_outputIfIndexMask 0x00000010
#define k_srcPortMask       0x00000020
#define k_dstPortMask       0x00000040
#define k_pktsMask          0x00000080
#define k_bytesMask         0x00000100
#define k_ipNextHopMask     0x00000200
#define k_startTimeMask     0x00000400
#define k_endTimeMask       0x00000800
#define k_protocolMask      0x00001000
#define k_tosMask           0x00002000
#define k_srcAsMask         0x00004000
#define k_dstAsMask         0x00008000
#define k_srcMaskLenMask    0x00010000
#define k_dstMaskLenMask    0x00020000
#define k_tcpFlagsMask      0x00040000
#define k_inputEncapMask    0x00080000
#define k_outputEncapMask   0x00100000
#define k_peerNextHopMask   0x00200000
#define k_engineTypeMask    0x00400000
#define k_engineIdMask      0x00800000

#define uint8_t unsigned char
#define uint16_t unsigned short int
#define uint32_t unsigned int
#define ipv4addr_t unsigned int


typedef struct {
  uint32_t        index;          /* bitmask indicating presence of other
				   * fields                                 */
  ipv4addr_t	    rtraddr;
  ipv4addr_t        srcaddr;      /* Source IP Address                      */
  ipv4addr_t        dstaddr;      /* Destination IP Address                 */
  uint16_t          input_if;     /* Input interface index                  */
  uint16_t          output_if;    /* Output interface index                 */
  uint16_t          srcport;      /* TCP/UDP src port number or equivalent  */
  uint16_t          dstport;      /* TCP/UDP dst port number or equivalent  */
  uint32_t          pkts;         /* Packets sent in Duration               */
  uint32_t          bytes;        /* Octets sent in Duration.               */
  ipv4addr_t        nexthop;      /* Next hop router's IP Address           */
  uint32_t          starttime;    /* SysUptime at start of flow             */
  uint32_t          endtime;      /* and of last packet of flow             */
  uint8_t           protocol;     /* IP protocol, e.g., 6=TCP, 17=UDP, ...  */
  uint8_t           tos;          /* IP Type-of-Service                     */
  uint16_t          src_as;       /* originating AS of source address       */
  uint16_t          dst_as;       /* originating AS of destination address  */
  uint8_t           src_mask;     /* source address prefix mask bits        */
  uint8_t           dst_mask;     /* destination address prefix mask bits   */
  uint8_t           tcp_flags;    /* logical OR of all TCP flags in flow; 
				     0x10 for non-TCP flows                 */
  uint8_t           engine_type;
  uint8_t	    engine_id;				 
} cflowrec;

#endif /* } */
