#!/usr/bin/env python

# foff (C)2006 Jeffrey Bakker

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# this setup file is for building as a standalone exe on windows
# build with python setup.py py2exe -c -b 2

# setup.py
from distutils.core import setup
import py2exe
import glob


opts = { 
        "py2exe": { 
                "includes": ["cairo", "pango", "pangocairo", "atk", "gobject", "gtk","gtk.glade"], 
                "dll_excludes": ["iconv.dll", "intl.dll", 
                        "libatk-1.0-0.dll", "libgdk_pixbuf-2.0-0.dll", 
                        "libgdk-win32-2.0-0.dll", "libglib-2.0-0.dll", 
                        "libgmodule-2.0-0.dll", "libgobject-2.0-0.dll", 
                        "libgthread-2.0-0.dll", "libgtk-win32-2.0-0.dll", 
                        "libpango-1.0-0.dll", "libpangowin32-1.0-0.dll", 
                        "libxml2", "libglade-2.0-0", "zlib1"] 
        }
} 


"""
windows = [
	{
		"script": "foff.py",
		"icon_resources": [(1, "icon.ico")]
	}
],
"""

setup(console=["foff.py"],
	name='foff',
	version='0.99.0',
	description='GTK+ FTP Client',
	author='Jeffrey Bakker',
	author_email='seeplusplus@users.sf.net',
	options=opts,
	data_files=[("", ["foff.glade"]), ("", glob.glob("*.txt"))]
	)
