(* Small script to test that the code generated by aorai can be parsed again
 * by frama-c.
 *)

open Kernel

include Plugin.Register
(struct 
  let name = "aorai testing module"
  let shortname = "aorai-test"
  let help = "utility script for aorai regtests"
 end)

let tmpfile = Filename.temp_file "aorai_test" ".i"

let () = 
  at_exit (fun () -> 
    if Debug.get () >= 1  then
      result "Keeping temp file %s" tmpfile
    else
      try Sys.remove tmpfile with Sys_error _ -> ())

let extend () =
  let myrun =
    let run = !Db.Toplevel.run in
    fun f ->
      let my_project = Project.create "Reparsing" in
      run f;
      let chan = open_out tmpfile in
      let fmt = Format.formatter_of_out_channel chan in
      File.pretty_ast ~prj:(Project.from_unique_name "aorai") ~fmt ();
      close_out chan;
      Project.set_current my_project;
      Files.add tmpfile;
      Constfold.off ();
      File.pretty_ast ();
        
  in
  Db.Toplevel.run := myrun

let () = Cmdline.run_during_extending_stage extend


