#import "Globals.h"

#define kSDLDownloadURL	@"http://www.libsdl.org/release/SDL-1.2.5.pkg.tar.gz"
#define kSDLPackageName	@"SDL-1.2.5.pkg.tar.gz"
#define kSDLPackageSize	99444

@interface InstallerSDL : NSObject
{
	
	// The label and set of radio buttons associated with this segment of the installer
    IBOutlet id label;
    IBOutlet id radios;
	
	// The controller
	IBOutlet id controller;
	
	// Has the file necessary for installation already been downloaded?
	BOOL alreadyDownloaded;
	
}

// Called upon a change of selection by the user
- (IBAction)choiceChanged:(id)sender;

// Returns the path of where the file should be downloaded to
- (NSString *)destinationPath;

// Returns the URL for downloading the package or NULL if no download is necessary
- (NSURL *)downloadURL;

// Returns the expected size of the download or 0 if no download is necessary
- (int)downloadSize;

// Should we remind the user to install SDL?
- (BOOL)exitReminder;

// Expands the SDL package
- (BOOL)expand;

// Launches the SDL Installation
- (void)launch;

// Called to prepare for installation
- (BOOL)prepare;

// Sets things up for the user
- (void)setup;

@end
