//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: UnknownListExpression.hpp,v 1.3 2003/05/04 18:09:01 delpinux Exp $

#ifndef _UNKNOWNLIST_EXPRESSION_HPP_
#define _UNKNOWNLIST_EXPRESSION_HPP_

#include <list>

#include <Expression.hpp>
#include <UnknownExpression.hpp>
#include <Variable.hpp>

#include <FunctionExpression.hpp>

/*!
  \class UnknownlistExpression

  This class defines the base class of Unknownlist expressions.

  \author Stephane Del Pino
 */
class UnknownListExpression
  : public Expression
{
public:
  typedef std::list<ReferenceCounting<FunctionExpressionVariable> > listType;

  typedef listType::iterator iterator;
  typedef listType::const_iterator const_iterator;

  virtual UnknownListExpression::iterator begin() = 0;
  virtual UnknownListExpression::const_iterator begin() const = 0;
  virtual UnknownListExpression::const_iterator end() const = 0;

  virtual const size_t size() const = 0;

  virtual const size_t 
  number(ReferenceCounting<FunctionVariable>) const = 0;

  UnknownListExpression()
    : Expression(Expression::unknownList)
  {
    ;
  }

  UnknownListExpression(const UnknownListExpression& u)
    : Expression(u)
  {
    ;
  }

  virtual ~UnknownListExpression()
  {
    ;
  }
};

/*
class UnknownListExpressionVariable
  : public UnknownListExpression
{
private:
  ReferenceCounting<UnknownListVariable> __unknownlistVariable;

  std::ostream& put(std::ostream& os) const
  {
    os << (*__unknownlistVariable).name() << ": " << (*(*__unknownlistVariable).expression());
    return os;
  }

public:
  void execute()
  {
    ;
  }

  UnknownListExpressionVariable(ReferenceCounting<UnknownListVariable> r);

  UnknownListExpressionVariable(const UnknownListExpressionVariable& e);

  ~UnknownListExpressionVariable();
};
*/

class UnknownListExpressionSet
  : public UnknownListExpression
{
protected:
  listType __list;

private:
  std::ostream& put(std::ostream& os) const;

public:
  UnknownListExpressionSet::listType::iterator begin()
  {
    return __list.begin();
  }

  UnknownListExpressionSet::listType::const_iterator begin() const
  {
    return __list.begin();
  }

  UnknownListExpressionSet::listType::const_iterator end() const
  {
    return __list.end();
  }

  inline const size_t size() const
  {
    return __list.size();
  }

  inline const size_t number(ReferenceCounting<FunctionVariable> f) const
  {
    size_t n = 0;
    for(listType::const_iterator i = __list.begin(); i != __list.end(); ++i) {
      if ((*(*i)).variable() == f) {
	return n;
      }
      ++n;
    }
    fferr(2) << (*f).name() << " is not a variable of the unkown list.\n";
    std::exit(1);
    return 0;
  }

  listType& giveList()
  {
    return __list;
  }

  void add(ReferenceCounting<FunctionExpressionVariable> u)
  {
    for (listType::const_iterator i =  __list.begin();
	 i != __list.end(); ++i) {
      if (*i == u) {
	fferr(2) << '\n' << *u << " has been declared twice in unknown list\n";
	std::exit(1);
      }
    }
    __list.push_back(u);
  }

  void execute()
  {
    ;
  }

  //! Checks that variables are declared and does it if not.
  void unknownsDeclare();

  //! Make unknowns become standard functions.
  void unknownsUndeclare();

  UnknownListExpressionSet()
    : UnknownListExpression()
  {
    ;
  }

  UnknownListExpressionSet(const UnknownListExpressionSet& l)
    : UnknownListExpression(l),
      __list(l.__list)
  {
    ;
  }

  ~UnknownListExpressionSet()
  {
    ;
  }
};

#endif // _UNKNOWNLIST_EXPRESSION_HPP_

