/*  FreeJ
 *  (c) Copyright 2009 Denis Roio aka jaromil <jaromil@dyne.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 3 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <config.h>

#include <stdlib.h>

#include <jutils.h>
#include <yuv_screen.h>

YuvScreen::YuvScreen()
  : ViewPort() {

  yuv_buffer = NULL;
  rgb_buffer = NULL;

}

YuvScreen::~YuvScreen() {
  func("%s",__PRETTY_FUNCTION__);
  if(yuv_buffer) delete yuv_buffer;
  if(rgb_buffer) delete rgb_buffer;
}

bool YuvScreen::init(int w, int h) {

  this->w = w;
  this->h = h;
  bpp = 32;
  size = w*h*(bpp>>3);
  pitch = w*(bpp>>3);

  yuv_buffer = malloc(size);
  rgb_buffer = malloc(size);


}
