/*
 *$Id: RawMessage.java,v 1.1.1.1 2002/01/13 05:24:01 sanity Exp $

  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU General Public Licence (GPL) 
  version 2.  See http://www.gnu.org/ for further details of the GPL.
 */

/**
 * RawMessages are a generalized form of message that can be created
 * and written to the protocol. They are are created by calling the 
 * a protocol's readMessage or newMessage methods.
 *
 * RawMessages contains the name of the message, it's source, any
 * connection settings, a set of the fields in the message, and 
 * the stream of trailing data.
 *
 * @author <A HREF="mailto:I.Clarke@strs.co.uk">Ian Clarke</A>
 * @author <A HREF="mailto:blanu@uts.cc.utexas.edu">Brandon Wiley</A>
 **/
package freenet;

import freenet.support.*;
import freenet.support.io.DiscontinueInputStream;
import java.io.*;
import java.io.EOFException;
import java.util.*;

public abstract class RawMessage {

    // Public Fields
    /** The type of the message **/
    public String messageType;
    /** The set of fields **/
    public FieldSet fs;
    /** The length of the trailing data **/
    public long trailingFieldLength;
    /** The name of the trailing data **/
    public String trailingFieldName;
    /** The trailing data stream **/
    public DiscontinueInputStream trailingFieldStream;
    /** Whether to close after this message **/
    public boolean close;
    /** Whether to keep the connection alive as long as possible **/
    public boolean sustain;

    // Constructors
    /**
     *
     * @param messageType   The name of the message type.
     * @param close         Whether to close the connection after 
     *                      receiving or sending this message.
     * @param sustain       Whether to sustain the connection.
     * @param fs            A set of message specific fields.
     * @param trailingLength The length of the trailing data, or 0 if there 
     *                       is no trailing data
     * @param trailingName   The name of the trailing field, or null if there
     *                       is no trailing data
     * @param trailing       An inputstream containing the trailing data,
     *                       in a format that can be copied to destination
     *                       of this message.
     **/

    protected RawMessage(String messageType, boolean close, boolean sustain, 
                         FieldSet fs, long trailingLength, 
                         String trailingName, DiscontinueInputStream trailing) {
        this.messageType = messageType;
        this.close = close;
        this.sustain = sustain;
        this.fs = fs;
        this.trailingFieldLength = trailingLength;
        this.trailingFieldName = trailingName;
        this.trailingFieldStream = trailing;
    }

    protected RawMessage() {
    }

    // Public Methods


    public abstract void writeMessage(OutputStream out) throws IOException;
}

/*
 *$Log: RawMessage.java,v $
 *Revision 1.1.1.1  2002/01/13 05:24:01  sanity
 *Imported source
 *
 *Revision 1.27  2001/08/23 01:22:07  oierw
 *merge 0.4 to HEAD (hopefully)
 *
 *Revision 1.25.8.5  2001/08/08 02:26:51  scipient
 *now doing discontinue() on ReceiveInputStream after CB_RESTARTED/ABORTED
 *otherwise, now closing the conn. if read < toRead  (sorry)
 *
 *Revision 1.25.8.4  2001/07/26 22:03:35  hobbex
 *Redid the states of the connectionhandler, it works but there could still be some bugs. Also made NodeMessage abstract on Message
 *
 *Revision 1.25.8.3  2001/04/22 18:37:19  scipient
 *various stuff for FCP and node contact probability management
 *
 *Revision 1.25.8.2  2001/04/12 22:20:49  hobbex
 *Touched fucking everything
 *
 *Revision 1.25.8.1  2001/01/18 02:36:24  hobbex
 *New Transport handeling structure for 0.4
 *
 *Revision 1.25  2000/08/21 18:32:41  hobbex
 *Added the ability for clients to encrypt data written out locally, and the Persist option to the protocol
 *
 *Revision 1.24  2000/08/12 06:40:34  hobbex
 *Renamed incorrectly named 'Transport' layer to Presentation
 *
 *Revision 1.23  2000/05/09 00:02:09  hobbex
 *Added pluggable presentation protocols.
 *Added plugs for implementing crypto.
 *The new presentation handles dotted fields, and reads and writes all numbers as hex rather then decimal or hex as before. We can back out of the latter if people really don't like it.
 *Bumped protocol to 1.21 and build to 129.
 *
 *Revision 1.22  2000/05/06 21:53:05  blanu
 *setField() now supports dotted fields, as well as writeMessage
 *
 *Revision 1.21  2000/05/03 02:40:06  scgmille
 *
 *Crypto so far... WARNING: Breaks server
 *
 *Revision 1.20  2000/04/16 23:26:54  thong
 *Changed assorted Longs to longs
 *
 *Revision 1.19  2000/04/07 20:34:09  hobbex
 *Fixed building and running with Kaffe (scripts/kbuild.sh). Added canceling of timer callback and sending of requestfailed on loosing MessageMemory (not too well tested). And fixed a bug in the datastore + some exception catching in requestfailed.
 *
 *Revision 1.18  2000/04/05 22:14:08  hobbex
 *Unknown message fields are passed, and source is now optional for clients
 *
 *Revision 1.17  2000/03/31 14:36:13  hobbex
 *Abstracted returning a message, and made replies set KeepAlive=false if the original message did
 *
 *Revision 1.16  2000/03/31 12:51:38  thong
 *Make "stream died" error more intelligible
 *
 *Revision 1.15  2000/03/30 11:32:27  hobbex
 *Close connections after sending KeepAlive=false message
 *
 *Revision 1.14  2000/03/29 00:30:45  hal
 *Check for CR at end of EndMessage line.
 *
 *Revision 1.13  2000/03/27 21:02:32  hobbex
 *Sustained streams
 *
 *Revision 1.12  2000/02/29 06:46:56  blanu
 *Stray debugging println removed.
 *
 *Revision 1.11  2000/02/29 06:35:36  blanu
 *Handshaking is now in a message-like format. It actually uses RawMessage to construct the handshake.
 *RawMessage now supports the EndMessage field to end a message instead of EOF.
 *This is useful for handshaking and also for future Keepalive connections.
 *
 *Revision 1.10  2000/02/17 14:12:54  hobbex
 *catch unknown message types
 *
 *Revision 1.9  2000/02/17 12:52:23  hobbex
 *removed runtime exception on bad connection (annoying)
 *
 *Revision 1.8  2000/02/12 13:59:57  hobbex
 *fixed tunneling on inserts for large files. Britney never sounded so good!
 *
 *Revision 1.7  2000/02/11 20:12:01  hobbex
 *Fixed tunneling to use only one thread. Changed Rawmessage to write to output streams rather than return inputstreams. Fixed releasing of DataStream when a message is dropped.
 *
 *Revision 1.6  2000/02/09 23:56:39  hobbex
 *Preliminary tunneling of DataReplies and DataInserts (for now)
 *
 *Revision 1.5  2000/01/27 15:45:39  sanity
 *Some bug fixes, added localAddress field to Node.java which is used by
 *DataRequest and DataReply messages to set dataSource field.  Also removed
 *untidy debugging stuff from RawMessage.
 *
 *Revision 1.4  2000/01/11 06:32:05  blanu
 *fixed problem with hex uniqueid and name=value field format
 *
 *Revision 1.3  2000/01/11 02:02:51  blanu
 *changed from -: to = field format
 *
 *Revision 1.2  2000/01/03 16:32:07  hobbex
 *Changed various println to Logger - think I got them all
 *
 *Revision 1.1.1.1  1999/12/31 11:53:02  sanity
 *Initial import from OpenProjects
 *
 *Revision 1.4  1999/12/29 07:14:06  michael
 *Additional LF after CR of trailing field - bug fixed
 *
 *
 */
