package freenet.client;

import freenet.support.Bucket;

/** Represents a ComputeCHKRequest (GenerateCHK in FCP)
  * @author tavin
  */
public class ComputeCHKRequest extends Request {

    ClientCHK clientKey;
    Bucket meta, data;
    String cipherName;
    
    /**
      */
    public ComputeCHKRequest(String cipherName, Bucket meta, Bucket data) {
        super();
        this.cipherName = (cipherName == null ? "Twofish" : cipherName);
        this.meta       = meta;
        this.data       = data;
    }

    /** @return the generated URI or null if request incomplete
      */
    public FreenetURI getURI() {
        return clientKey == null ? null : clientKey.getURI();
    }

}







