package freenet.fs.acct;

import freenet.support.Comparable;

/**
 * Used in a variety of data structures where we need an object
 * that represents a block by its number, and that can be
 * naturally ordered via the Comparable interface.
 * @author tavin
 */
public class BlockElement implements Comparable {

    private final int bnum;

    public BlockElement(int bnum) {
        //if (bnum < 0) throw new AccountingException("catchall YOU FUCKED UP");
        this.bnum = bnum;
    }

    public String toString() {
        return "Block: "+bnum;
    }

    public final int getBlockNumber() {
        return bnum;
    }
    
    public final int compareTo(Object o) {
        return compareTo((BlockElement) o);
    }

    public final int compareTo(BlockElement be) {
        return bnum == be.bnum ? 0 : (bnum > be.bnum ? 1 : -1);
    }
}


