package freenet.fs.acct.fsck;

import java.io.IOException;

/**
 * Implementations perform some suite of tests on structures at
 * some level of the accounting system and accumulate the results
 * for returning as Fault objects.  The tests would generally be
 * conducted in the constructor.
 *
 * If there are known to be FATAL faults, these should be supplied
 * first so that the repair process can be cancelled promptly.
 * Otherwise, the implementation should supply faults in the order
 * that gives the best chance of repairing all faults.  The caller
 * should dequeue and repair one Fault object at a time, since
 * each repair influences subsequent faults.
 *
 * @author tavin
 */
public interface FaultAnalysis {

    /**
     * @return  a message explaining what this particular analysis does
     */
    String getDescription();

    /**
     * @return  true, if there are unrepaired faults
     */
    boolean hasFaults();

    /**
     * @return  the next Fault to deal with,
     *          or null if there aren't any more
     * @see freenet.fs.acct.fsck.Fault
     */
    Fault getNextFault();

    /**
     * Flushes all changes to disk that were made in the course of
     * repairing faults.
     */
    void commitFixes() throws IOException;
}


