package freenet.fs.dir;

import freenet.support.*;
import java.io.*;
import java.util.Hashtable;
import java.util.Enumeration;

/**
 * Implementation of DataObjectStore with a Directory for the backing storage.
 * This is kind of sloppily done atm.
 * @author tavin
 */
public class FSDataObjectStore implements DataObjectStore {

    protected final LossyDirectory dir;

    protected final Hashtable dataObjects = new Hashtable();
    protected final Hashtable outputQueue = new Hashtable();
    

    public FSDataObjectStore(LossyDirectory dir) {
        this.dir = dir;
    }


    public void flush() throws IOException {
        synchronized (dir.semaphore()) {
            Enumeration keys = outputQueue.keys();
            while (keys.hasMoreElements()) {
                FileNumber key = (FileNumber) keys.nextElement();
                DataObject o = (DataObject) outputQueue.get(key);
                Buffer buffer = dir.forceStore(o.getDataLength(), key);
                try {
                    DataOutputStream out =
                        new DataOutputStream(buffer.getOutputStream());
                    o.writeTo(out);
                    out.close();
                    dir.delete(key);
                    buffer.commit();
                }
                finally {
                    buffer.release();
                }
            }
            outputQueue.clear();
            dir.forceFlush();
        }
    }
    

    public DataObject get(FileNumber key) throws DataObjectUnloadedException {
        DataObject o = (DataObject) dataObjects.get(key);
        if (o == null) {
            Buffer buffer = dir.fetch(key);
            if (buffer == null)
                return null;  //buffer = new NullBuffer();
            throw new DataObjectUnloadedExceptionImpl(key, buffer);
        }
        return o;
    }

    protected class DataObjectUnloadedExceptionImpl extends DataObjectUnloadedException {
        
        final FileNumber key;
        final Buffer buffer;
        
        DataObjectUnloadedExceptionImpl(FileNumber key, Buffer buffer) {
            this.key = key;
            this.buffer = buffer;
        }

        public final int getDataLength() {
            return (int) buffer.length();
        }

        public final DataInputStream getDataInputStream() throws IOException {
            return new DataInputStream(buffer.getInputStream());
        }

        public final void resolve(DataObject o) {
            dataObjects.put(key, o);
            buffer.release();
        }
    }
    

    public void set(FileNumber key, DataObject o) {
        dataObjects.put(key, o);
        outputQueue.put(key, o);
    }

    public final boolean contains(FileNumber key) {
        return dataObjects.containsKey(key) || dir.contains(key);
    }

    public final boolean remove(FileNumber key) {
        boolean ret = false;
        if (null != dataObjects.remove(key)) ret = true;
        if (null != outputQueue.remove(key)) ret = true;
        if (dir.delete(key)) ret = true;
        return ret;
    }

    public final Enumeration keys(boolean ascending) {
        try {
            flush();
        }
        catch (IOException e) {
            // bah
        }
        return dir.keys(ascending);
   }

    public final Enumeration keys(FilePattern pat) {
        try {
            flush();
        }
        catch (IOException e) {
            // bah
        }
        return dir.keys(pat);
    }
}


