package freenet.node.http.infolets;
import freenet.node.http.Infolet;
import freenet.node.Node;
import freenet.Version;
import java.io.PrintWriter;

/**
 * This is the Infolet which is displayed by default
 **/
public class DefaultInfolet extends Infolet  {
    public String longName()  {
        return "Main Page";
    }

    public String shortName() {
        return "main";
    }

    public void init(Node n) { }

    public void toHtml(PrintWriter pw)  {
        pw.println("<h3>Node Information</h3>");
        pw.println("From here you can view information about what is going ");
        pw.println("on inside your node.  Select from the options in the ");
        pw.println("menu to the left<p>");
        pw.println("<h3>Version Information</h3>");
        pw.println("<table>");
        pw.println("<tr><td><b>Node Version</b></td><td>"+Version.nodeVersion+
                   "</td></tr>");
        pw.println("<tr><td><b>Protocol Version</b></td><td>"+
                   Version.protocolVersion+"</td></tr>");
        pw.println("<tr><td><b>Build Number</b></td><td>"+Version.buildNumber+
                   "</td></tr>");
        pw.println("<tr><td><b>CVS Revision</b></td><td>"+Version.cvsRevision+
                   "</td></tr>");
        pw.println("</table>");
        
        StringBuffer uptime = new StringBuffer();

        long deltat = (System.currentTimeMillis() - Node.startupTimeMs) / 1000;

        if (deltat < 60) 
            uptime.append("&nbsp;< 1 minute ");
        else {
            long days = deltat / 86400l;
            deltat -= days * 86400l;
            long hours = deltat / 3600l;
            deltat -= hours * 3600l;
            long minutes = deltat/ 60l;
            
            if (days > 0)
                uptime.append(days).append(days == 1 ? " day" : 
                                           " days").append(" ");
            if (hours > 0)
                uptime.append(hours).append(hours == 1 ? " hour" : 
                                            " hours").append(" ");
            uptime.append(" ").append(minutes).append(minutes == 1 ? 
                                                      " minute" : 
                                                      " minutes"); 
        }

        pw.println("<h3>Uptime</h3>");
        pw.println("<p>&nbsp;" + uptime + "</p>");
        
    }

}
