package freenet.node.states.FNP;

import freenet.*;
import freenet.node.*;
import freenet.node.states.request.*;
import freenet.message.*;

/**
 * This is the state pertaining to DataRequests in their
 * initial state.
 */

public class NewDataRequest extends NewRequest {

    public NewDataRequest(long id) {
        super(id);
    }
    
    /**
     * Returns the name.
     * @return "New DataRequest"
     */
    public String getName() {
        return "New DataRequest";
    }

    public State received(Node n, MessageObject mo) throws StateException {
        if (!(mo instanceof DataRequest)) {
            throw new BadStateException("expecting DataRequest");
        }
        DataRequest drmo = (DataRequest) mo;
        try {
            genReceived(n, drmo);
            FeedbackToken ft    = new FNPFeedbackToken(id, origRec);
            RequestInitiator ri = new RequestInitiator(id);
            Pending p = new DataPending(id, (int) drmo.hopsToLive,
                                        drmo.searchKey, origRec, ft, ri);
	    n.diagnostics.occurrenceCounting("incomingRequests", 1);
            return p.received(n, ri);
        } catch (RequestAbortException e) {
            return e.state;
        }
    }
}



