package freenet.node.states.announcement;

import freenet.*;
import freenet.node.*;
import freenet.message.*;
import freenet.support.Fields;
import freenet.support.Logger;
import java.util.Enumeration;

/**
 * Waiting for a Reply to the message
 */

public class ReplyPending extends AnnouncementState {

    private NoReply nr;

    private boolean accepted;

    public ReplyPending(NewAnnouncement na, NoReply nr) {
        super(na);
        this.nr = nr;
    }

    public String getName() {
        return "Announcement Reply Pending";
    }

    public State received(Node n, MessageObject mo) throws StateException {
        if (mo instanceof NodeAnnouncement) {
            NodeAnnouncement na = (NodeAnnouncement) mo;
            QueryRejected rf = new QueryRejected(id, na.hopsToLive(), 
                                                 na.otherFields);
            try {
                n.sendMessage(rf, na.getSource(), 0);
            } catch (CommunicationException e) {
                n.logger.log(this, "Failed to send back "+rf+": "+e,
                             Logger.MINOR);
            }
            return this;
        }
        // we are only expecting replies...
        if (mo instanceof Message && 
            !lastAddr.equalsIdent(((Message) mo).peerIdentity())) {

            throw new BadStateException("Reply of type: " +
                                        mo.getClass().getName() +
                                        " received from wrong peer");
        }
        return super.received(n, mo);
        
    }

    public State receivedMessage(Node n, Accepted a) throws BadStateException {

        if (accepted) 
            throw new BadStateException("Received a second Accepted");
        
        routes.routeSucceeded();  // FIXME: this is probably too early..
        
        nr.cancel();
        nr = new NoReply(id);

        n.schedule(getTime(hopsToLive),nr);
        accepted = true;
        
        return this;
    }

    public State receivedMessage(Node n, NoReply nr) throws BadStateException {
        if (nr != this.nr) {
            throw new BadStateException("Received the wrong NoReply - probably"
                                        + " accepted NoReply lingering");
        } else {
            n.logger.log(this,
                "Restarting Announcement chain "+Fields.longToHex(id),
                Logger.MINOR);

            routes.timedOut();
            try {
                n.sendMessage(new QueryRestarted(id), origRec);
            } catch (CommunicationException e) {
                n.logger.log(this, "Failed to restart query",
                             e, n.logger.MINOR);
                return null;
            }
            
            NodeAnnouncement na = new NodeAnnouncement(id, hopsToLive, depth, 
                                                       n.myRef, announcee, 
                                                       commitVal); 
       
            return (new NewAnnouncement(this)).sendOn(n, na);         
        }
    }

    public State receivedMessage(Node n, QueryRejected qr) 
        throws BadStateException {

        n.logger.log(this, "Received QueryRejected", n.logger.DEBUG);
        
        nr.cancel();
        
        try {
            n.sendMessage(new QueryRestarted(id), origRec);
        } catch (CommunicationException e) {
            n.logger.log(this, "Failed to restart query",
                         e, n.logger.MINOR);
            return null;
        }
            
        NodeAnnouncement na = new NodeAnnouncement(id, hopsToLive, depth, 
                                                   n.myRef, announcee, 
                                                   commitVal, qr.otherFields);
        return (new NewAnnouncement(this)).sendOn(n, na);         
    }

    public State receivedMessage(Node n, QueryRestarted qr) 
        throws BadStateException {

        nr.cancel();
        
        nr = new NoReply(id);
        n.schedule(getTime(hopsToLive), nr);
        try {
            n.sendMessage(qr, origRec);
            return this;
        } catch (CommunicationException e) {
            n.logger.log(this, "Failed to send back QueryRestarted",
                         e, n.logger.MINOR);
            return null;
        }
    }

    public State receivedMessage(Node n, AnnouncementFailed af) 
        throws BadStateException {

        nr.cancel();
        n.logger.log(this, "Announcement failed for reason " + af.reason()
                     + "at later node", n.logger.DEBUG);
        try {
            n.sendMessage(af, origRec);
        } catch (CommunicationException e) {
            n.logger.log(this, "Failed to send AnnouncementFailed",
                         e, n.logger.MINOR);
        }
        return null;
    }

    public State receivedMessage(Node n, AnnouncementReply ar) {

        nr.cancel();
        
        byte[] returnVal = ar.getReturnVal();
        
        for (int i = 0 ; i < myVal.length && i < returnVal.length; i++) {
            returnVal[i] ^= myVal[i];
        }

        // note side effect on message

        try {
            n.sendMessage(ar, origRec);
        } catch (CommunicationException e) {
            n.logger.log(this, "Failed to send AnnouncementReply", e,
                         n.logger.MINOR);
        }

        NoExecute ne = new NoExecute(id);
        n.schedule(getTime(depth), ne);
        return new ExecutePending(this, returnVal, ne);
        //        return null;
    }
}
