#                                                         -*- Perl -*-
# Copyright (c) 1999, 2000  Motoyuki Kasahara
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

#
# ǥå᤿ե륯饹
#
package FreePWING::Index;

require 5.005;
require Exporter;
use English;
use FileHandle;
use FreePWING::Reference;
use strict;
use integer;

use vars qw(@ISA
	    @EXPORT
	    @EXPORT_OK
	    $suffix
	    $block_length
	    $max_depth
	    $header_length);

@ISA = qw(Exporter);

#
# ֥åĹ (Хȿ)
#
$block_length = 2048;

#
# ֥åĹ (Хȿ)
#
$block_length = 2048;

#
# ǥåեκο
#
$max_depth = 10;

#
# :
#	new()
# ᥽åɤζʬ:
# 	public 饹᥽åɡ
# :
# 	֥Ȥ롣
# :
# 	֥ȤؤΥե󥹤֤
#
sub new {
    my $type = shift;
    my $new = {
	# ǥåե̾ (δ̾)
	'file_name' => '',

	# ȥե̾ (δ̾)
	'reference_file_name' => '',

	# ե̾ˡ
	'godparent' => sub {return $ARG[0] . $ARG[1]},

	# ǥåγ
	'layers' => [],

	# ǥåؤο
	'depth' => 0,

	# ޤǤ˽񤭹ȥ
	'entry_count' => 0,

	# 顼å
	'error_message' => '',
    };
    return bless($new, $type);
}

#
# :
#	open(file_name, reference_file_name, [godparent])
#           file_name
#		ǥåե̾ (δ̾)
#           reference_file_name
#		Ⱦե̾ (δ̾)
#           godparent
#		ե̾δ̾̾롼ؤ
#		ե󥹡
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	ꤵ줿ǥåե뷲򳫤
# :
#	 1 ֤Ԥ 0 ֤
#
sub open {
    my $self = shift;
    my ($file_name, $reference_file_name, $godparent) = @ARG;

    $self->{'file_name'} = $file_name;
    $self->{'reference_file_name'} = $reference_file_name;
    if (defined($godparent)) {
	$self->{'godparent'} = $godparent;
    }

    #
    # ǽγؤΥǥå򳫤
    #
    if (!$self->open_upper_layer()) {
	return 0;
    }

    return 1;
}

#
# :
#	open_upper_layer()
# ᥽åɤζʬ:
# 	private 󥹥󥹥᥽åɡ
# :
# 	γؤΥǥåե򳫤
# :
#	 1 ֤Ԥ 0 ֤
#
sub open_upper_layer {
    my $self = shift;
    
    #
    # $self->{'layers'} ˳ؤɲá
    #
    my $layer = {
	# ؤο
	'level' => $self->{'depth'},

	# ǥåեΥϥɥ
	'handle' => FileHandle->new(),

	# ǥåե̾
	'file_name' => &{$self->{'godparent'}}($self->{'file_name'},
					       $self->{'depth'}),

	# Ⱦ
	'reference' => FreePWING::Reference->new(),

	# ޤǤ˽񤭹֥å
	'block_count' => 1,

	# 񤭹ߤαƤ륨ȥΥ塼
	'entry_queue' => [],

	# Υ֥åθñĹ (= ñκĹ)
	# (̥ǥåǤΤ߻)
	'block_word_length' => 0,

	# ߤΥ֥å˽񤭹Хȿ
	# (̥ǥåǤΤ߻)
	'block_length' => 4,
    };

    # 
    # ܳѤλȾե򳫤
    # 
    my $reference_file_name
	= &{$self->{'godparent'}}($self->{'reference_file_name'},
				  $self->{'depth'});
    if (!$layer->{'reference'}->open($reference_file_name)) {
	$self->close_internal();
	return 0;
    }

    # 
    # ܳѤΥǥåե򳫤
    # 
    if (!$layer->{'handle'}->open($layer->{'file_name'}, 'w')) {
	$self->{'error_message'} = 
	    "$PROGRAM_NAME: failed to open the file, $ERRNO: "
		. $layer->{'file_name'};
	$self->{'reference'}->close();
	$self->close_internal();
	return 0;
    }
    binmode($layer->{'handle'});

    push(@{$self->{'layers'}}, $layer);
    $self->{'depth'}++;

    return 1;
}

#
# :
#	close()
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	֥ȤƤ륤ǥåե뷲Ĥ롣
#	ǥåե򳫤Ƥʤϡ⤷ʤ
# :
#	 1 ֤
#
sub close {
    my $self = shift;

    #
    # ǥåե򳫤ƤʤС᥽åɤȴ롣
    #
    if (!$self->{'layers'}->[0]->{'handle'}->fileno()) {
	return 1;
    }

    #
    # ̥ǥåեĤ롣
    #
    if (!$self->write_leaf_layer_block(1)) {
	return 0;
    }

    #
    # ̥ǥåեĤ롣
    #
    my $i;
    for ($i = 1; $i < $self->{'depth'}; $i++) {
	if (!$self->write_medium_layer_block($i, 1)) {
	    return 0;
	}
    }

    $self->close_internal();
    return 1;
}

#
# :
#	close_internal()
# ᥽åɤζʬ:
# 	private 󥹥󥹥᥽åɡ
# :
# 	¾Υ᥽åɽ˰۾郎νԤ
#
sub close_internal {
    my $self = shift;

    my $i;
    for ($i = 0; $i < $self->{'depth'}; $i++) {
	if ($self->{'layers'}->[$i]->{'handle'}->fileno()) {
	    $self->{'layers'}->[$i]->{'handle'}->close();
	}
	$self->{'layers'}->[$i]->{'reference'}->close_internal();
    }

    return 1;
}

#
# :
#	error_message()
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	Ǹȯ顼Υå֤
#
sub error_message {
    my $self = shift;
    return $self->{'error_message'};
}

#
# :
#	add_entries_in_file(file_name)
#           file_name
#		ǥåΥȥ꤬줿ե롣
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	file_name ˵Ƥȥ򡢥ǥåե
#	Фɲä롣
# :
#	 1 ֤Ԥ 0 ֤
#
sub add_entries_in_file {
    my $self = shift;
    my ($file_name) = @ARG;

    #
    # $file_name 򳫤
    #
    my $handle = FileHandle->new();
    if (!$handle->open($file_name, 'r')) {
	$self->{'error_message'} =
	    "failed to open the file, $ERRNO: $file_name";
	$self->close_internal();
	return 0;
    }

    #
    # $file_name ɤߡƹԤ˵Ƥ륨ȥ $self ɲ
    # 롣
    #
    my $line;
    my @line_fields;
    for (;;) {
	$line = $handle->getline();
	if (!defined($line)) {
	    last;
	}
	chomp $line;
	@line_fields = split(/\t/, $line);
	my $word = $line_fields[0];
	my $heading_position = hex($line_fields[1]);
	my $heading_file_name = $line_fields[2];
	my $text_position = hex($line_fields[3]);
	my $text_file_name = $line_fields[4];
	if (!$self->add_entry($word, $heading_position, $heading_file_name,
			      $text_position, $text_file_name)) {
	    $self->close_internal();
	    return 0;
	}
    }

    #
    # $file_name ΥϥɥĤ롣
    #
    $handle->close();

    return 1;
}

#
# :
#	add_entry(word, heading_position, heading_file, text_position,
#                 text_file)
#           word
# 		ǥåϿñ졣Ƥ뤳ȡ
#           heading_position
#           heading_file_name
# 		ȥθФܤƤե̾ȥեΰ֡
#           text_position
#           text_file_name
# 		ȥʸܤƤեȥեΰ֡
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	ǥåե뷲˥ȥɲä롣
# :
#	 1 ֤Ԥ 0 ֤
#
sub add_entry {
    my $self = shift;
    return $self->add_leaf_layer_entry(@ARG);
}

#
# add_entry() μ
#
sub add_leaf_layer_entry {
    my $self = shift;
    my ($word, $heading_position, $heading_file_name, $text_position,
	$text_file_name) = @ARG;

    my $leaf_layer = $self->{'layers'}->[0];

    #
    # ڡɬ顢֥å񤭽ФΥ֥å
    # ؿʤࡣ
    #
    if ($block_length < $leaf_layer->{'block_length'} + length($word) + 13) {
	if (!$self->write_leaf_layer_block()) {
	    return 0;
	}

	#
	# ǸΥȥ̥ȥɲä롣
	#
  	if ($self->{'depth'} == 1 && !$self->open_upper_layer()) {
  	    return 0;
  	}
	my $medium_word = $leaf_layer->{'entry_queue'}->[-1]->[0];
	my $medium_position = ($leaf_layer->{'block_count'} - 1)
	    * $block_length;
  	if (!$self->add_medium_layer_entry(1, $medium_word,
					   $medium_position)) {
  	    return 0;
  	}

  	#
  	# ȥꥭ塼ꥻåȡ
  	#
  	@{$self->{'layers'}->[0]->{'entry_queue'}} = ();
  	$self->{'layers'}->[0]->{'block_length'} = 4;
	$leaf_layer->{'block_count'}++;
    }

    #
    # ȥꥭ塼ˡΥȥ­
    #
    push(@{$self->{'layers'}->[0]->{'entry_queue'}},
	 [$word, $heading_position, $heading_file_name, $text_position,
	  $text_file_name]);
    $self->{'layers'}->[0]->{'block_length'} += length($word) + 13;

    return 1;
}

#
# :
#	write_leaf_layer_block(close_flag)
#	    close_flag
#		ǥåĤ뤿˸Ƥ֤Ȥϡtrue 
#		ȤʤФʤʤ
# ᥽åɤζʬ:
# 	private 󥹥󥹥᥽åɡ
# :
# 	̥ǥåθߤΥȥꥭ塼ޤȤ 1 ֥å
#	ƽ񤭽Ф
# :
#	 1 ֤Ԥ 0 ֤
#
sub write_leaf_layer_block {
    my $self = shift;
    my ($close_flag) = @ARG;

    my $leaf_layer = $self->{'layers'}->[0];

    #
    # ȥꥭ塼ʤ顢᥽åɤȴ롣
    #
    if (@{$leaf_layer->{'entry_queue'}} == 0) {
	return 1;
    }

    #
    # ֥åΥإå񤭹ࡣ
    #
    my $block_id = 0x80;
    if ($leaf_layer->{'block_count'} == 1) {
	$block_id |= 0x40;
    }
    if ($close_flag) {
	$block_id |= 0x20;
    }
    if (!$leaf_layer->{'handle'}->
	print(pack("CCn", $block_id, 0,
		   scalar(@{$leaf_layer->{'entry_queue'}})))) {
	$self->close_internal();
	return 0;
    }

    #
    # ȥꥭ塼γƥȥ񤭹ࡣ
    #
    my $source_position = ($leaf_layer->{'block_count'} - 1) * $block_length
	+ 4;
    my $i;
    for ($i = 0; $i < scalar(@{$leaf_layer->{'entry_queue'}}); $i++) {
	my $entry = $leaf_layer->{'entry_queue'}->[$i];
	my $word = $entry->[0];
	my $word_length = length($word);
	my $heading_position = $entry->[1];
	my $heading_file_name = $entry->[2];
	my $text_position = $entry->[3];
	my $text_file_name = $entry->[4];

	#
	# ȥ񤭹ࡣ
	#
	if (!$leaf_layer->{'handle'}
	    ->print(pack("Ca*NnNn", $word_length, $word, 0, 0, 0, 0))) {
	    $self->{'error_message'} = "failed to write the file, $ERRNO: "
		. $leaf_layer->{'file_name'};
	    $self->close_internal();
	    return 0;
	}

	#
	# ƥȤȸФλȾ񤭹ࡣ
	#
	if (!$leaf_layer->{'reference'}
	    ->add_position_entry($source_position + $word_length + 7,
			      $heading_position, $heading_file_name)) {
	    $self->{'error_message'} = $self->{'reference'}->error_message();
	    $self->position_internal();
	    return 0;
	}
	if (!$leaf_layer->{'reference'}
	    ->add_position_entry($source_position + $word_length + 1,
			      $text_position, $text_file_name)) {
	    $self->{'error_message'} = $self->{'reference'}->error_message();
	    $self->close_internal();
	    return 0;
	}
	$source_position += $word_length + 13;
    }

    #
    # Ⱦüʥ֥åθ "\0" 롣
    #
    my $pad_length = $block_length - $leaf_layer->{'block_length'};
    if (0 < $pad_length
	&& !$leaf_layer->{'handle'}->print("\0" x $pad_length)) {
	$self->{'error_message'} = "failed to write the file, $ERRNO: "
	    . $leaf_layer->{'file_name'};
	$self->close_internal();
	return 0;
    }

    return 1;
}

#
# :
#	add_medium_entry(level, word, position)
#	    level
#           word
# 		ǥåϿñ졣Ƥ뤳ȡ
#           position
#		ĲؤΥǥåΰ֡
# ᥽åɤζʬ:
# 	private 󥹥󥹥᥽åɡ
# :
# 	ǥåե뷲˥ȥɲä롣
# :
#	 1 ֤Ԥ 0 ֤
#
sub add_medium_layer_entry {
    my $self = shift;
    my ($level, $word, $position) = @ARG;
    
    my $current_layer = $self->{'layers'}->[$level];

    #
    # ڡɬ顢֥å񤭽ФΥ֥å
    # ؿʤࡣ
    #
    my $word_length = length($word);
    my $overflow = 0;
    if ($current_layer->{'block_word_length'} < $word_length) {
	if ($block_length < (scalar(@{$current_layer->{'entry_queue'}}) + 2)
	    * ($word_length + 4) + 4) {
	    $overflow = 1;
	}
    } else {
	if ($block_length < (scalar(@{$current_layer->{'entry_queue'}}) + 2)
	    * ($current_layer->{'block_word_length'} + 4) + 4) {
	    $overflow = 1;
	}
    }

    if ($overflow) {
	if (!$self->write_medium_layer_block($level)) {
	    return 0;
	}

	#
	# ǸΥȥ̥ȥɲä롣
	#
  	if ($self->{'depth'} == $level + 1 && !$self->open_upper_layer()) {
  	    return 0;
  	}
  	my $upper_word = $current_layer->{'entry_queue'}->[-1]->[0];
	my $upper_position = ($current_layer->{'block_count'} - 1)
	    * $block_length;
  	if (!$self->add_medium_layer_entry($level + 1, $upper_word,
					   $upper_position)) {
  	    return 0;
  	}

  	#
  	# ȥꥭ塼ꥻåȡ
  	#
  	@{$current_layer->{'entry_queue'}} = ();
  	$current_layer->{'block_word_length'} = 0;
	$current_layer->{'block_count'}++;
    }

    #
    # ȥꥭ塼ˡΥȥ­
    #
    push(@{$current_layer->{'entry_queue'}}, [$word, $position]);
    if ($current_layer->{'block_word_length'} < $word_length) {
	$current_layer->{'block_word_length'} = $word_length;
    }

    return 1;
}

#
# :
#	write_medium_layer_block(level, close_flag)
#	    level
#		ǥåγإ٥롣
#	    close_flag
#		ǥåĤ뤿˸Ƥ֤Ȥϡtrue 
#		ȤʤФʤʤ
# ᥽åɤζʬ:
# 	private 󥹥󥹥᥽åɡ
# :
# 	level ǻꤵ줿̥ǥåθߤΥȥꥭ塼
#	ޤȤ 1 ֥åˤƽ񤭽Ф
# :
#	 1 ֤Ԥ 0 ֤
#
sub write_medium_layer_block {
    my $self = shift;
    my ($level, $close_flag) = @ARG;

    my $current_layer = $self->{'layers'}->[$level];

    #
    # ȥꥭ塼ʤ顢᥽åɤȴ롣
    #
    if (@{$current_layer->{'entry_queue'}} == 0) {
	return 1;
    }

    #
    # ߡΥȥ "\xff\xff...." 򥭥塼ɲä롣
    #
    push(@{$current_layer->{'entry_queue'}},
	 ["\xff" x $current_layer->{'block_word_length'},
	  $current_layer->{'entry_queue'}->[-1]->[1]]);

    #
    # ֥åΥإå񤭹ࡣ
    #
    my $block_id = 0x00;
    if ($current_layer->{'block_count'} == 1) {
	$block_id |= 0x40;
    }
    if ($close_flag) {
	$block_id |= 0x20;
    }
    if (!$current_layer->{'handle'}->
	print(pack("CCn", $block_id, $current_layer->{'block_word_length'},
		   scalar(@{$current_layer->{'entry_queue'}})))) {
	$self->close_internal();
	return 0;
    }

    #
    # ȥꥭ塼γƥȥ񤭹ࡣ
    #
    my $lower_layer_filename = $self->{'layers'}->[$level - 1]->{'file_name'};
    my $source_position = ($current_layer->{'block_count'} - 1) * $block_length
	+ 4;
    my $i;
    for ($i = 0; $i < scalar(@{$current_layer->{'entry_queue'}}); $i++) {
	my $word = $current_layer->{'entry_queue'}->[$i]->[0];
	my $lower_layer_position = $current_layer->{'entry_queue'}->[$i]->[1];

	#
	# ȥ񤭹ࡣ
	#
	$word .= "\0" x ($current_layer->{'block_word_length'}
			 - length($word));
	if (!$current_layer->{'handle'}->print(pack("a*N", $word, 0))) {
	    $self->{'error_message'} = "failed to write the file, $ERRNO: "
		. $current_layer->{'file_name'};
	    $self->close_internal();
	    return 0;
	}

	#
	# ǥåλȾ񤭹ࡣ
	#
	if (!$current_layer->{'reference'}
	    ->add_block_entry($source_position
			      + $current_layer->{'block_word_length'},
			      $lower_layer_position, $lower_layer_filename)) {
	    $self->{'error_message'} = $self->{'reference'}->error_message();
	    $self->position_internal();
	    return 0;
	}
	$source_position += $current_layer->{'block_word_length'} + 4;
    }

    #
    # Ⱦüʥ֥åθ "\0" 롣
    #
    my $pad_length = $block_length
	- scalar(@{$current_layer->{'entry_queue'}})
	    * ($current_layer->{'block_word_length'} + 4) - 4;
    if (0 < $pad_length
	&& !$current_layer->{'handle'}->print("\0" x $pad_length)) {
	$self->close_internal();
	return 0;
    }

    #
    # ɲäߡΥȥ "\xff\xff...." 򥭥塼롣
    #
    pop(@{$current_layer->{'entry_queue'}});

    return 1;
}

######################################################################
# <󥹥ѿ֤ͤ᥽åɷ>
#
# :
#	󥹥ѿ̾()
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
#	󥹥ѿ֤ͤ
#
sub file_name {
    my $self = shift;
    return $self->{'file_name'};
}

sub reference_file_name {
    my $self = shift;
    return $self->{'reference_file_name'};
}

sub depth {
    my $self = shift;
    return $self->{'depth'};
}

sub entry_count {
    my $self = shift;
    return $self->{'entry_count'};
}

sub error_message {
    my $self = shift;
    return $self->{'error_message'};
}

1;

