/*
 * $Id: rk_spclval.h,v 1.2 2001/06/14 18:16:10 ura Exp $
 */

/*
 * FreeWnn is a network-extensible Kana-to-Kanji conversion system.
 * This file is part of FreeWnn.
 * 
 * Copyright Kyoto University Research Institute for Mathematical Sciences
 *                 1987, 1988, 1989, 1990, 1991, 1992
 * Copyright OMRON Corporation. 1987, 1988, 1989, 1990, 1991, 1992, 1999
 * Copyright ASTEC, Inc. 1987, 1988, 1989, 1990, 1991, 1992
 *
 * Author: OMRON SOFTWARE Co., Ltd. <freewnn@rd.kyoto.omronsoft.co.jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Emacs; see the file COPYING.  If not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Commentary:
 *
 * Change log:
 *
 * Last modified date: 8,Feb.1999
 *
 * Code:
 *
 */
/*      Version 3.0
 */
#ifndef EOLTTR

typedef unsigned int letter;    /* ʸϰ̤ˤηɽ */
typedef unsigned char uns_chr;

typedef unsigned char modetyp;
#define LTRHUG  (~(0xff000000))
        /* ɽ ڤӵʸletterμ */


        /* ʲͤϡǾ̥ХȤ255ǤʤФʤʤ
           Τ˽ФΤ EOLTTRCHMSIGNISEBPLTREOF
           REDRAWʵǥ꡼ȤȤNISEDLȤNISEDLˡ */

#define EOLTTR  (0xffffffff)    /* ʸνüɽ */
                        /* Ϥäɬɤ֤֤ˤ
                           ȡä֤٤ΤʤϤ֤ */
#define ERRCOD  (EOLTTR-1)      /* (error)ɽ */
#define CHMSIG  (EOLTTR-2)      /* ⡼ɥ󥸤ɽ */
#define NISEBP  (EOLTTR-3)      /* 顼ٹѤεBEL */
#define VARRNG  (EOLTTR-4)      /* Ѱ褬Ĥʸδ֤ǤΤ򼨤 */
#define UNUSDC  (EOLTTR-5)      /* ޥåԤ뤿 */
#define REASIG  (EOLTTR-6)      /* ɽκ׵᤹뤿 */
#define URBFCL  (EOLTTR-7)      /* ΢ХåեŪꥢ׵᤹ */
#define LTREOF  (EOLTTR-8)      /* romkan_next()Ʊgetc()EOF֤
                                   ʤǤEOFƱˤġ */
#define REDRAW  (EOLTTR-9)      /* WnnѴԤredraw׵᤹ü쥳 */
#define NISEDL  (EOLTTR-10)     /* ǥ꡼ȤȤȤͤΤ˽
                                   줿âȤʤлȤʤƤ
                                   ˡѿnisedl˥åȤƻȤ */
#define SENDCH  (EOLTTR-11)     /* ѴХåեʤ顢ʸ̵
                                   褦Wnn׵᤹륨ץɡ */


        /* romkan_init3()ΰΥե饰˻Ȥ */

#define RK_CHMOUT 01            /* ⡼ɥ󥸤Τ餻륳ɤ֤ */
#define RK_KEYACK 02            /* Фɬ֤ */
#define RK_DSPNIL 04            /* ⡼ɽʸ̵λ˶ʸ֤ʥǥ
                                   ȤNULLˡߴݻΤ */
#define RK_NONISE 010           /* ɤФʤ褦ˤ뤫 */
#define RK_REDRAW 020           /* Wnnüե饰redrawѤΥե饰Фɤ */
#define RK_SIMPLD 040           /* deleteưñˤ뤫 */
#define RK_VERBOS 0100          /* ѤɽΰݡȤ뤫 */


        /* ɤζ̤˻Ȥޥ */

#define HG1BIT  (0x80000000)    /* Ǿ̥ӥåȤ */
#define SHUBET(X) ((letter)(X) >> 24)
                              /* ɽǡ壱ХȤɽ˻ȤäƤ */
#define LWRMSK(X) ((X) & ~(0xff000000)) /* 壱ХȤ */
#define LWRCUT(X) ((X) &= ~(0xff000000))        /* 壱ХȤ */

#define is_HON(X) (SHUBET(X) == 0)      /* ʪʸ */
#define NAIBEX(X) ((int)0 < SHUBET(X) && (int)SHUBET(X) < 0x80) /* ɽ򼨤ͤ */
#define isNISE(X) (SHUBET(X) == 0x80)   /* ʪʸʺǾ̥ӥåȤΩġ */
#define isSPCL(X) (SHUBET(X) == 0xff)   /* rk_spcl_val.hͤɤ */
 /* NISEDLʤɤޤ᤿ʸǤ뤫ɤȽꤹˤϡ~is_HON(X) 
    isNISE(X) || isSPCL(X) ȤȽꤷʤȤʤ */

#define toNISE(X) ((X) | HG1BIT)
#define to_HON(X) ((X) & ~HG1BIT)

 /* ߴΤѰդƤ̾ */
#define REALCD(X) is_HON(X)
#define NISECD(X) isNISE(X)
#define SPCLCD(X) isSPCL(X)

#ifndef SS2
#define SS2     0x8E
#endif
#ifndef SS3
#define SS3     0x8F
#endif

        /** rk_bltinfn.c 䴰ΤΥޥ
            ʰʣɾΤ¿Τա*/

#define HKKBGN  (SS2 * 0x100 + 0xA1)    /* Ⱦѥʤζ */
#define HKKEND  (SS2 * 0x100 + 0xDF)    /*         Ⱦ */
#define HIRBGN  (0xA4A1)        /*  */
#define HIREND  (0xA4F3) /*  */       /* Ҥ餬ʡ"""" */
#define KATBGN  (0xA5A1)        /*  */
#define KATEND  (0xA5F6) /*  */       /* ʡ"""""" */

#define _to_kata(l) ((l) + (KATBGN - HIRBGN)) /** ʤء¡*/
#define _to_hira(l) ((l) - (KATBGN - HIRBGN)) /** Ҥ餬ʤء¡*/
#define is_hira(l) ((int)HIRBGN <= (int)(l) && (int)(l) <= (int)HIREND) /** Ҥ餬ʤ */
#define is_kata(l) ((int)KATBGN <= (int)(l) && (int)(l) <= (int)KATEND) /** ʤ */
#define is_kata2(l) ((int)_to_kata(HIRBGN) <= (int)(l) && (int)(l) <= (int)_to_kata(HIREND))
                                /** бҤ餬ʤΤ륫ʤ */
#define to_kata(l) (is_hira(l) ? _to_kata(l) : (l)) /** ʤ */
#define to_hira(l) (is_kata2(l) ? _to_hira(l) : (l))
                        /** Ҥ餬ʤء֥פϥʤΤޤ޻Ĥ롣*/
#define is_hankata(l) ((int)HKKBGN <= (int)(l) && (int)(l) <= (int)HKKEND)
                                /** Ⱦѥʡʶʤɤޤˤ */



        /* ¾ΥޥؿʰʣɾΤ¿Τա */

#define numberof(array) (sizeof(array) / sizeof(*array))

 /* ݥ󥿤letterؤäƤletter *lp */
#define totail(lp) {while(*(lp) != EOLTTR) (lp)++;}

 /* ʸؤΥݥ󥿤򤽤ʸκǸءtotailcharǡchar *sp */
#define strtail(sp) {while(*(sp)) (sp)++;}

        /* romkan_init3 */
#define romkan_init4(delchr, nisedl, flg) \
        romkan_init3(delchr, nisedl, EOLTTR, flg)

#define romkan_init5(delchr, flg) \
        romkan_init4(delchr, toNISE(delchr), flg)


#endif /* of ifndef EOLTTR */
