/* alsa.c generated by valac 0.14.2, the Vala compiler
 * generated from alsa.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Michael 'Mickey' Lauer <mlauer@vanille-media.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <fsobasics.h>
#include <alsa/asoundlib.h>
#include <alsa/control.h>
#include <math.h>
#include <float.h>
#include <gobject/gvaluecollector.h>


#define FSO_DEVICE_TYPE_BUNCH_OF_MIXER_CONTROLS (fso_device_bunch_of_mixer_controls_get_type ())
#define FSO_DEVICE_BUNCH_OF_MIXER_CONTROLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_DEVICE_TYPE_BUNCH_OF_MIXER_CONTROLS, FsoDeviceBunchOfMixerControls))
#define FSO_DEVICE_BUNCH_OF_MIXER_CONTROLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_DEVICE_TYPE_BUNCH_OF_MIXER_CONTROLS, FsoDeviceBunchOfMixerControlsClass))
#define FSO_DEVICE_IS_BUNCH_OF_MIXER_CONTROLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_DEVICE_TYPE_BUNCH_OF_MIXER_CONTROLS))
#define FSO_DEVICE_IS_BUNCH_OF_MIXER_CONTROLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_DEVICE_TYPE_BUNCH_OF_MIXER_CONTROLS))
#define FSO_DEVICE_BUNCH_OF_MIXER_CONTROLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_DEVICE_TYPE_BUNCH_OF_MIXER_CONTROLS, FsoDeviceBunchOfMixerControlsClass))

typedef struct _FsoDeviceBunchOfMixerControls FsoDeviceBunchOfMixerControls;
typedef struct _FsoDeviceBunchOfMixerControlsClass FsoDeviceBunchOfMixerControlsClass;
typedef struct _FsoDeviceBunchOfMixerControlsPrivate FsoDeviceBunchOfMixerControlsPrivate;

#define FSO_DEVICE_TYPE_MIXER_CONTROL (fso_device_mixer_control_get_type ())
#define FSO_DEVICE_MIXER_CONTROL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_DEVICE_TYPE_MIXER_CONTROL, FsoDeviceMixerControl))
#define FSO_DEVICE_MIXER_CONTROL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_DEVICE_TYPE_MIXER_CONTROL, FsoDeviceMixerControlClass))
#define FSO_DEVICE_IS_MIXER_CONTROL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_DEVICE_TYPE_MIXER_CONTROL))
#define FSO_DEVICE_IS_MIXER_CONTROL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_DEVICE_TYPE_MIXER_CONTROL))
#define FSO_DEVICE_MIXER_CONTROL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_DEVICE_TYPE_MIXER_CONTROL, FsoDeviceMixerControlClass))

typedef struct _FsoDeviceMixerControl FsoDeviceMixerControl;
typedef struct _FsoDeviceMixerControlClass FsoDeviceMixerControlClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _FsoDeviceParamSpecBunchOfMixerControls FsoDeviceParamSpecBunchOfMixerControls;

#define FSO_DEVICE_TYPE_SOUND_DEVICE (fso_device_sound_device_get_type ())
#define FSO_DEVICE_SOUND_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_DEVICE_TYPE_SOUND_DEVICE, FsoDeviceSoundDevice))
#define FSO_DEVICE_SOUND_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_DEVICE_TYPE_SOUND_DEVICE, FsoDeviceSoundDeviceClass))
#define FSO_DEVICE_IS_SOUND_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_DEVICE_TYPE_SOUND_DEVICE))
#define FSO_DEVICE_IS_SOUND_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_DEVICE_TYPE_SOUND_DEVICE))
#define FSO_DEVICE_SOUND_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_DEVICE_TYPE_SOUND_DEVICE, FsoDeviceSoundDeviceClass))

typedef struct _FsoDeviceSoundDevice FsoDeviceSoundDevice;
typedef struct _FsoDeviceSoundDeviceClass FsoDeviceSoundDeviceClass;
typedef struct _FsoDeviceSoundDevicePrivate FsoDeviceSoundDevicePrivate;
#define _snd_ctl_close0(var) ((var == NULL) ? NULL : (var = (snd_ctl_close (var), NULL)))
#define _snd_ctl_elem_list_free0(var) ((var == NULL) ? NULL : (var = (snd_ctl_elem_list_free (var), NULL)))
#define _snd_ctl_card_info_free0(var) ((var == NULL) ? NULL : (var = (snd_ctl_card_info_free (var), NULL)))
#define _snd_ctl_elem_id_free0(var) ((var == NULL) ? NULL : (var = (snd_ctl_elem_id_free (var), NULL)))
#define _snd_ctl_elem_info_free0(var) ((var == NULL) ? NULL : (var = (snd_ctl_elem_info_free (var), NULL)))
#define _snd_ctl_elem_value_free0(var) ((var == NULL) ? NULL : (var = (snd_ctl_elem_value_free (var), NULL)))
typedef struct _FsoDeviceMixerControlPrivate FsoDeviceMixerControlPrivate;
#define _fso_device_mixer_control_unref0(var) ((var == NULL) ? NULL : (var = (fso_device_mixer_control_unref (var), NULL)))
#define _snd_mixer_close0(var) ((var == NULL) ? NULL : (var = (snd_mixer_close (var), NULL)))
#define _0(var) ((var == NULL) ? NULL : (var = ( (var), NULL)))
typedef struct _FsoDeviceParamSpecMixerControl FsoDeviceParamSpecMixerControl;

/**
 * Errordomain
 **/
typedef enum  {
	FSO_DEVICE_SOUND_ERROR_NO_DEVICE,
	FSO_DEVICE_SOUND_ERROR_DEVICE_ERROR,
	FSO_DEVICE_SOUND_ERROR_NOT_ENOUGH_CONTROLS,
	FSO_DEVICE_SOUND_ERROR_INVALID_DESCRIPTOR
} FsoDeviceSoundError;
#define FSO_DEVICE_SOUND_ERROR fso_device_sound_error_quark ()
struct _FsoDeviceBunchOfMixerControls {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FsoDeviceBunchOfMixerControlsPrivate * priv;
	FsoDeviceMixerControl** controls;
	gint controls_length1;
	guint idxMainVolume;
};

struct _FsoDeviceBunchOfMixerControlsClass {
	GTypeClass parent_class;
	void (*finalize) (FsoDeviceBunchOfMixerControls *self);
};

struct _FsoDeviceParamSpecBunchOfMixerControls {
	GParamSpec parent_instance;
};

struct _FsoDeviceSoundDevice {
	FsoFrameworkAbstractObject parent_instance;
	FsoDeviceSoundDevicePrivate * priv;
	gchar* name;
	gchar* fullname;
	gchar* mixername;
	gchar* cardname;
};

struct _FsoDeviceSoundDeviceClass {
	FsoFrameworkAbstractObjectClass parent_class;
};

struct _FsoDeviceSoundDevicePrivate {
	snd_ctl_t* card;
	snd_ctl_elem_list_t* list;
};

struct _FsoDeviceMixerControl {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FsoDeviceMixerControlPrivate * priv;
	snd_ctl_elem_id_t* eid;
	snd_ctl_elem_info_t* info;
	snd_ctl_elem_value_t* value;
};

struct _FsoDeviceMixerControlClass {
	GTypeClass parent_class;
	void (*finalize) (FsoDeviceMixerControl *self);
};

struct _FsoDeviceParamSpecMixerControl {
	GParamSpec parent_instance;
};


static gpointer fso_device_bunch_of_mixer_controls_parent_class = NULL;
static gpointer fso_device_sound_device_parent_class = NULL;
static gpointer fso_device_mixer_control_parent_class = NULL;

GQuark fso_device_sound_error_quark (void);
gpointer fso_device_bunch_of_mixer_controls_ref (gpointer instance);
void fso_device_bunch_of_mixer_controls_unref (gpointer instance);
GParamSpec* fso_device_param_spec_bunch_of_mixer_controls (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void fso_device_value_set_bunch_of_mixer_controls (GValue* value, gpointer v_object);
void fso_device_value_take_bunch_of_mixer_controls (GValue* value, gpointer v_object);
gpointer fso_device_value_get_bunch_of_mixer_controls (const GValue* value);
GType fso_device_bunch_of_mixer_controls_get_type (void) G_GNUC_CONST;
gpointer fso_device_mixer_control_ref (gpointer instance);
void fso_device_mixer_control_unref (gpointer instance);
GParamSpec* fso_device_param_spec_mixer_control (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void fso_device_value_set_mixer_control (GValue* value, gpointer v_object);
void fso_device_value_take_mixer_control (GValue* value, gpointer v_object);
gpointer fso_device_value_get_mixer_control (const GValue* value);
GType fso_device_mixer_control_get_type (void) G_GNUC_CONST;
enum  {
	FSO_DEVICE_BUNCH_OF_MIXER_CONTROLS_DUMMY_PROPERTY
};
FsoDeviceBunchOfMixerControls* fso_device_bunch_of_mixer_controls_new (FsoDeviceMixerControl** controls, int controls_length1, guint idxMainVolume);
FsoDeviceBunchOfMixerControls* fso_device_bunch_of_mixer_controls_construct (GType object_type, FsoDeviceMixerControl** controls, int controls_length1, guint idxMainVolume);
static FsoDeviceMixerControl** _vala_array_dup1 (FsoDeviceMixerControl** self, int length);
gchar* fso_device_bunch_of_mixer_controls_to_string (FsoDeviceBunchOfMixerControls* self);
gchar* fso_device_mixer_control_to_string (FsoDeviceMixerControl* self);
static void fso_device_bunch_of_mixer_controls_finalize (FsoDeviceBunchOfMixerControls* obj);
GType fso_device_sound_device_get_type (void) G_GNUC_CONST;
#define FSO_DEVICE_SOUND_DEVICE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FSO_DEVICE_TYPE_SOUND_DEVICE, FsoDeviceSoundDevicePrivate))
enum  {
	FSO_DEVICE_SOUND_DEVICE_DUMMY_PROPERTY
};
static FsoDeviceSoundDevice* fso_device_sound_device_new (snd_ctl_t** card, snd_ctl_elem_list_t** list, const gchar* name, const gchar* fullname, const gchar* mixername, const gchar* cardname);
static FsoDeviceSoundDevice* fso_device_sound_device_construct (GType object_type, snd_ctl_t** card, snd_ctl_elem_list_t** list, const gchar* name, const gchar* fullname, const gchar* mixername, const gchar* cardname);
FsoDeviceSoundDevice* fso_device_sound_device_create (const gchar* cardname, GError** error);
static gchar* fso_device_sound_device_real_repr (FsoFrameworkAbstractObject* base);
FsoDeviceMixerControl* fso_device_sound_device_controlForId (FsoDeviceSoundDevice* self, guint idx, GError** error);
FsoDeviceMixerControl* fso_device_mixer_control_new (snd_ctl_elem_id_t** eid, snd_ctl_elem_info_t** info, snd_ctl_elem_value_t** value);
FsoDeviceMixerControl* fso_device_mixer_control_construct (GType object_type, snd_ctl_elem_id_t** eid, snd_ctl_elem_info_t** info, snd_ctl_elem_value_t** value);
void fso_device_sound_device_setControl (FsoDeviceSoundDevice* self, FsoDeviceMixerControl* control, GError** error);
FsoDeviceMixerControl** fso_device_sound_device_allMixerControls (FsoDeviceSoundDevice* self, int* result_length1, GError** error);
static void _vala_array_add1 (FsoDeviceMixerControl*** array, int* length, int* size, FsoDeviceMixerControl* value);
void fso_device_sound_device_setAllMixerControls (FsoDeviceSoundDevice* self, FsoDeviceMixerControl** controls, int controls_length1, GError** error);
FsoDeviceMixerControl* fso_device_sound_device_controlForString (FsoDeviceSoundDevice* self, const gchar* description, GError** error);
guint8 fso_device_sound_device_volumeForIndex (FsoDeviceSoundDevice* self, guint id);
void fso_device_sound_device_setVolumeForIndex (FsoDeviceSoundDevice* self, guint id, guint8 val);
static void fso_device_sound_device_finalize (GObject* obj);
enum  {
	FSO_DEVICE_MIXER_CONTROL_DUMMY_PROPERTY
};
guint fso_device_mixer_control_get_volume (FsoDeviceMixerControl* self);
void fso_device_mixer_control_set_volume (FsoDeviceMixerControl* self, guint value);
static void fso_device_mixer_control_finalize (FsoDeviceMixerControl* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark fso_device_sound_error_quark (void) {
	return g_quark_from_static_string ("fso_device_sound_error-quark");
}


static gpointer _fso_device_mixer_control_ref0 (gpointer self) {
	return self ? fso_device_mixer_control_ref (self) : NULL;
}


static FsoDeviceMixerControl** _vala_array_dup1 (FsoDeviceMixerControl** self, int length) {
	FsoDeviceMixerControl** result;
	int i;
	result = g_new0 (FsoDeviceMixerControl*, length + 1);
	for (i = 0; i < length; i++) {
		FsoDeviceMixerControl* _tmp0_;
		_tmp0_ = _fso_device_mixer_control_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


FsoDeviceBunchOfMixerControls* fso_device_bunch_of_mixer_controls_construct (GType object_type, FsoDeviceMixerControl** controls, int controls_length1, guint idxMainVolume) {
	FsoDeviceBunchOfMixerControls* self = NULL;
	FsoDeviceMixerControl** _tmp0_;
	gint _tmp0__length1;
	FsoDeviceMixerControl** _tmp1_;
	gint _tmp1__length1;
	guint _tmp2_;
	self = (FsoDeviceBunchOfMixerControls*) g_type_create_instance (object_type);
	_tmp0_ = controls;
	_tmp0__length1 = controls_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup1 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	self->controls = (_vala_array_free (self->controls, self->controls_length1, (GDestroyNotify) fso_device_mixer_control_unref), NULL);
	self->controls = _tmp1_;
	self->controls_length1 = _tmp1__length1;
	_tmp2_ = idxMainVolume;
	self->idxMainVolume = _tmp2_;
	return self;
}


FsoDeviceBunchOfMixerControls* fso_device_bunch_of_mixer_controls_new (FsoDeviceMixerControl** controls, int controls_length1, guint idxMainVolume) {
	return fso_device_bunch_of_mixer_controls_construct (FSO_DEVICE_TYPE_BUNCH_OF_MIXER_CONTROLS, controls, controls_length1, idxMainVolume);
}


gchar* fso_device_bunch_of_mixer_controls_to_string (FsoDeviceBunchOfMixerControls* self) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* str;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	str = _tmp0_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_;
				gint _tmp4_;
				FsoDeviceMixerControl** _tmp5_;
				gint _tmp5__length1;
				const gchar* _tmp6_;
				FsoDeviceMixerControl** _tmp7_;
				gint _tmp7__length1;
				gint _tmp8_;
				FsoDeviceMixerControl* _tmp9_;
				gchar* _tmp10_ = NULL;
				gchar* _tmp11_;
				gchar* _tmp12_ = NULL;
				gchar* _tmp13_;
				gchar* _tmp14_;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = self->controls;
				_tmp5__length1 = self->controls_length1;
				if (!(_tmp4_ < _tmp5__length1)) {
					break;
				}
				_tmp6_ = str;
				_tmp7_ = self->controls;
				_tmp7__length1 = self->controls_length1;
				_tmp8_ = i;
				_tmp9_ = _tmp7_[_tmp8_];
				_tmp10_ = fso_device_mixer_control_to_string (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = g_strconcat (_tmp11_, "\n", NULL);
				_tmp13_ = _tmp12_;
				_tmp14_ = g_strconcat (_tmp6_, _tmp13_, NULL);
				_g_free0 (str);
				str = _tmp14_;
				_g_free0 (_tmp13_);
				_g_free0 (_tmp11_);
			}
		}
	}
	result = str;
	return result;
}


static void fso_device_value_bunch_of_mixer_controls_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void fso_device_value_bunch_of_mixer_controls_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		fso_device_bunch_of_mixer_controls_unref (value->data[0].v_pointer);
	}
}


static void fso_device_value_bunch_of_mixer_controls_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = fso_device_bunch_of_mixer_controls_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer fso_device_value_bunch_of_mixer_controls_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* fso_device_value_bunch_of_mixer_controls_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		FsoDeviceBunchOfMixerControls* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = fso_device_bunch_of_mixer_controls_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* fso_device_value_bunch_of_mixer_controls_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	FsoDeviceBunchOfMixerControls** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = fso_device_bunch_of_mixer_controls_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* fso_device_param_spec_bunch_of_mixer_controls (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	FsoDeviceParamSpecBunchOfMixerControls* spec;
	g_return_val_if_fail (g_type_is_a (object_type, FSO_DEVICE_TYPE_BUNCH_OF_MIXER_CONTROLS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer fso_device_value_get_bunch_of_mixer_controls (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FSO_DEVICE_TYPE_BUNCH_OF_MIXER_CONTROLS), NULL);
	return value->data[0].v_pointer;
}


void fso_device_value_set_bunch_of_mixer_controls (GValue* value, gpointer v_object) {
	FsoDeviceBunchOfMixerControls* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FSO_DEVICE_TYPE_BUNCH_OF_MIXER_CONTROLS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FSO_DEVICE_TYPE_BUNCH_OF_MIXER_CONTROLS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		fso_device_bunch_of_mixer_controls_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		fso_device_bunch_of_mixer_controls_unref (old);
	}
}


void fso_device_value_take_bunch_of_mixer_controls (GValue* value, gpointer v_object) {
	FsoDeviceBunchOfMixerControls* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FSO_DEVICE_TYPE_BUNCH_OF_MIXER_CONTROLS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FSO_DEVICE_TYPE_BUNCH_OF_MIXER_CONTROLS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		fso_device_bunch_of_mixer_controls_unref (old);
	}
}


static void fso_device_bunch_of_mixer_controls_class_init (FsoDeviceBunchOfMixerControlsClass * klass) {
	fso_device_bunch_of_mixer_controls_parent_class = g_type_class_peek_parent (klass);
	FSO_DEVICE_BUNCH_OF_MIXER_CONTROLS_CLASS (klass)->finalize = fso_device_bunch_of_mixer_controls_finalize;
}


static void fso_device_bunch_of_mixer_controls_instance_init (FsoDeviceBunchOfMixerControls * self) {
	self->ref_count = 1;
}


static void fso_device_bunch_of_mixer_controls_finalize (FsoDeviceBunchOfMixerControls* obj) {
	FsoDeviceBunchOfMixerControls * self;
	self = FSO_DEVICE_BUNCH_OF_MIXER_CONTROLS (obj);
	self->controls = (_vala_array_free (self->controls, self->controls_length1, (GDestroyNotify) fso_device_mixer_control_unref), NULL);
}


/**
 * @class FsoDevice.BunchOfMixerControls
 **/
GType fso_device_bunch_of_mixer_controls_get_type (void) {
	static volatile gsize fso_device_bunch_of_mixer_controls_type_id__volatile = 0;
	if (g_once_init_enter (&fso_device_bunch_of_mixer_controls_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { fso_device_value_bunch_of_mixer_controls_init, fso_device_value_bunch_of_mixer_controls_free_value, fso_device_value_bunch_of_mixer_controls_copy_value, fso_device_value_bunch_of_mixer_controls_peek_pointer, "p", fso_device_value_bunch_of_mixer_controls_collect_value, "p", fso_device_value_bunch_of_mixer_controls_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (FsoDeviceBunchOfMixerControlsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fso_device_bunch_of_mixer_controls_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FsoDeviceBunchOfMixerControls), 0, (GInstanceInitFunc) fso_device_bunch_of_mixer_controls_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType fso_device_bunch_of_mixer_controls_type_id;
		fso_device_bunch_of_mixer_controls_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FsoDeviceBunchOfMixerControls", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&fso_device_bunch_of_mixer_controls_type_id__volatile, fso_device_bunch_of_mixer_controls_type_id);
	}
	return fso_device_bunch_of_mixer_controls_type_id__volatile;
}


gpointer fso_device_bunch_of_mixer_controls_ref (gpointer instance) {
	FsoDeviceBunchOfMixerControls* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void fso_device_bunch_of_mixer_controls_unref (gpointer instance) {
	FsoDeviceBunchOfMixerControls* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		FSO_DEVICE_BUNCH_OF_MIXER_CONTROLS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static FsoDeviceSoundDevice* fso_device_sound_device_construct (GType object_type, snd_ctl_t** card, snd_ctl_elem_list_t** list, const gchar* name, const gchar* fullname, const gchar* mixername, const gchar* cardname) {
	FsoDeviceSoundDevice * self = NULL;
	snd_ctl_t* _tmp0_;
	snd_ctl_elem_list_t* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	g_return_val_if_fail (card != NULL, NULL);
	g_return_val_if_fail (list != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (fullname != NULL, NULL);
	g_return_val_if_fail (mixername != NULL, NULL);
	g_return_val_if_fail (cardname != NULL, NULL);
	self = (FsoDeviceSoundDevice*) fso_framework_abstract_object_construct (object_type);
	_tmp0_ = *card;
	*card = NULL;
	_snd_ctl_close0 (self->priv->card);
	self->priv->card = _tmp0_;
	_tmp1_ = *list;
	*list = NULL;
	_snd_ctl_elem_list_free0 (self->priv->list);
	self->priv->list = _tmp1_;
	_tmp2_ = name;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->name);
	self->name = _tmp3_;
	_tmp4_ = fullname;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (self->fullname);
	self->fullname = _tmp5_;
	_tmp6_ = mixername;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 (self->mixername);
	self->mixername = _tmp7_;
	_tmp8_ = cardname;
	_tmp9_ = g_strdup (_tmp8_);
	_g_free0 (self->cardname);
	self->cardname = _tmp9_;
	return self;
}


static FsoDeviceSoundDevice* fso_device_sound_device_new (snd_ctl_t** card, snd_ctl_elem_list_t** list, const gchar* name, const gchar* fullname, const gchar* mixername, const gchar* cardname) {
	return fso_device_sound_device_construct (FSO_DEVICE_TYPE_SOUND_DEVICE, card, list, name, fullname, mixername, cardname);
}


/**
     * Create @a SoundDevice class, attached to a specific Alsa card.
     **/
FsoDeviceSoundDevice* fso_device_sound_device_create (const gchar* cardname, GError** error) {
	FsoDeviceSoundDevice* result = NULL;
	snd_ctl_t* card = NULL;
	const gchar* _tmp0_;
	snd_ctl_t* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint res;
	gint _tmp3_;
	snd_ctl_card_info_t* info = NULL;
	snd_ctl_card_info_t* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_;
	snd_ctl_t* _tmp19_;
	snd_ctl_card_info_t* _tmp20_;
	gint _tmp21_ = 0;
	gint _tmp22_;
	snd_ctl_elem_list_t* list = NULL;
	snd_ctl_elem_list_t* _tmp29_ = NULL;
	gint _tmp30_ = 0;
	gint _tmp31_;
	snd_ctl_t* _tmp38_;
	snd_ctl_elem_list_t* _tmp39_;
	gint _tmp40_ = 0;
	gint _tmp41_;
	snd_ctl_elem_list_t* _tmp48_;
	snd_ctl_elem_list_t* _tmp49_;
	snd_ctl_elem_list_t* _tmp50_;
	guint _tmp51_ = 0U;
	gint _tmp52_ = 0;
	gint _tmp53_;
	snd_ctl_t* _tmp60_;
	snd_ctl_elem_list_t* _tmp61_;
	gint _tmp62_ = 0;
	gint _tmp63_;
	snd_ctl_card_info_t* _tmp70_;
	const gchar* _tmp71_ = NULL;
	snd_ctl_card_info_t* _tmp72_;
	const gchar* _tmp73_ = NULL;
	snd_ctl_card_info_t* _tmp74_;
	const gchar* _tmp75_ = NULL;
	const gchar* _tmp76_;
	FsoDeviceSoundDevice* _tmp77_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (cardname != NULL, NULL);
	_tmp0_ = cardname;
	_tmp2_ = snd_ctl_open (&_tmp1_, _tmp0_, 0);
	_snd_ctl_close0 (card);
	card = _tmp1_;
	res = _tmp2_;
	_tmp3_ = res;
	if (_tmp3_ < 0) {
		gint _tmp4_;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		GError* _tmp8_;
		GError* _tmp9_;
		_tmp4_ = res;
		_tmp5_ = snd_strerror (_tmp4_);
		_tmp6_ = g_strdup_printf ("%s", _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_error_new_literal (FSO_DEVICE_SOUND_ERROR, FSO_DEVICE_SOUND_ERROR_NO_DEVICE, _tmp7_);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		_inner_error_ = _tmp9_;
		if (_inner_error_->domain == FSO_DEVICE_SOUND_ERROR) {
			g_propagate_error (error, _inner_error_);
			_snd_ctl_close0 (card);
			return NULL;
		} else {
			_snd_ctl_close0 (card);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp11_ = snd_ctl_card_info_malloc (&_tmp10_);
	_snd_ctl_card_info_free0 (info);
	info = _tmp10_;
	res = _tmp11_;
	_tmp12_ = res;
	if (_tmp12_ < 0) {
		gint _tmp13_;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
		GError* _tmp17_;
		GError* _tmp18_;
		_tmp13_ = res;
		_tmp14_ = snd_strerror (_tmp13_);
		_tmp15_ = g_strdup_printf ("%s", _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_error_new_literal (FSO_DEVICE_SOUND_ERROR, FSO_DEVICE_SOUND_ERROR_DEVICE_ERROR, _tmp16_);
		_tmp18_ = _tmp17_;
		_g_free0 (_tmp16_);
		_inner_error_ = _tmp18_;
		if (_inner_error_->domain == FSO_DEVICE_SOUND_ERROR) {
			g_propagate_error (error, _inner_error_);
			_snd_ctl_card_info_free0 (info);
			_snd_ctl_close0 (card);
			return NULL;
		} else {
			_snd_ctl_card_info_free0 (info);
			_snd_ctl_close0 (card);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp19_ = card;
	_tmp20_ = info;
	_tmp21_ = snd_ctl_card_info (_tmp19_, _tmp20_);
	res = _tmp21_;
	_tmp22_ = res;
	if (_tmp22_ < 0) {
		gint _tmp23_;
		const gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_;
		GError* _tmp27_;
		GError* _tmp28_;
		_tmp23_ = res;
		_tmp24_ = snd_strerror (_tmp23_);
		_tmp25_ = g_strdup_printf ("%s", _tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = g_error_new_literal (FSO_DEVICE_SOUND_ERROR, FSO_DEVICE_SOUND_ERROR_DEVICE_ERROR, _tmp26_);
		_tmp28_ = _tmp27_;
		_g_free0 (_tmp26_);
		_inner_error_ = _tmp28_;
		if (_inner_error_->domain == FSO_DEVICE_SOUND_ERROR) {
			g_propagate_error (error, _inner_error_);
			_snd_ctl_card_info_free0 (info);
			_snd_ctl_close0 (card);
			return NULL;
		} else {
			_snd_ctl_card_info_free0 (info);
			_snd_ctl_close0 (card);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp30_ = snd_ctl_elem_list_malloc (&_tmp29_);
	_snd_ctl_elem_list_free0 (list);
	list = _tmp29_;
	res = _tmp30_;
	_tmp31_ = res;
	if (_tmp31_ < 0) {
		gint _tmp32_;
		const gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_;
		GError* _tmp36_;
		GError* _tmp37_;
		_tmp32_ = res;
		_tmp33_ = snd_strerror (_tmp32_);
		_tmp34_ = g_strdup_printf ("%s", _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_error_new_literal (FSO_DEVICE_SOUND_ERROR, FSO_DEVICE_SOUND_ERROR_DEVICE_ERROR, _tmp35_);
		_tmp37_ = _tmp36_;
		_g_free0 (_tmp35_);
		_inner_error_ = _tmp37_;
		if (_inner_error_->domain == FSO_DEVICE_SOUND_ERROR) {
			g_propagate_error (error, _inner_error_);
			_snd_ctl_elem_list_free0 (list);
			_snd_ctl_card_info_free0 (info);
			_snd_ctl_close0 (card);
			return NULL;
		} else {
			_snd_ctl_elem_list_free0 (list);
			_snd_ctl_card_info_free0 (info);
			_snd_ctl_close0 (card);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp38_ = card;
	_tmp39_ = list;
	_tmp40_ = snd_ctl_elem_list (_tmp38_, _tmp39_);
	res = _tmp40_;
	_tmp41_ = res;
	if (_tmp41_ < 0) {
		gint _tmp42_;
		const gchar* _tmp43_ = NULL;
		gchar* _tmp44_ = NULL;
		gchar* _tmp45_;
		GError* _tmp46_;
		GError* _tmp47_;
		_tmp42_ = res;
		_tmp43_ = snd_strerror (_tmp42_);
		_tmp44_ = g_strdup_printf ("%s", _tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = g_error_new_literal (FSO_DEVICE_SOUND_ERROR, FSO_DEVICE_SOUND_ERROR_DEVICE_ERROR, _tmp45_);
		_tmp47_ = _tmp46_;
		_g_free0 (_tmp45_);
		_inner_error_ = _tmp47_;
		if (_inner_error_->domain == FSO_DEVICE_SOUND_ERROR) {
			g_propagate_error (error, _inner_error_);
			_snd_ctl_elem_list_free0 (list);
			_snd_ctl_card_info_free0 (info);
			_snd_ctl_close0 (card);
			return NULL;
		} else {
			_snd_ctl_elem_list_free0 (list);
			_snd_ctl_card_info_free0 (info);
			_snd_ctl_close0 (card);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp48_ = list;
	snd_ctl_elem_list_set_offset (_tmp48_, (guint) 0);
	_tmp49_ = list;
	_tmp50_ = list;
	_tmp51_ = snd_ctl_elem_list_get_count (_tmp50_);
	_tmp52_ = snd_ctl_elem_list_alloc_space (_tmp49_, _tmp51_);
	res = _tmp52_;
	_tmp53_ = res;
	if (_tmp53_ < 0) {
		gint _tmp54_;
		const gchar* _tmp55_ = NULL;
		gchar* _tmp56_ = NULL;
		gchar* _tmp57_;
		GError* _tmp58_;
		GError* _tmp59_;
		_tmp54_ = res;
		_tmp55_ = snd_strerror (_tmp54_);
		_tmp56_ = g_strdup_printf ("%s", _tmp55_);
		_tmp57_ = _tmp56_;
		_tmp58_ = g_error_new_literal (FSO_DEVICE_SOUND_ERROR, FSO_DEVICE_SOUND_ERROR_DEVICE_ERROR, _tmp57_);
		_tmp59_ = _tmp58_;
		_g_free0 (_tmp57_);
		_inner_error_ = _tmp59_;
		if (_inner_error_->domain == FSO_DEVICE_SOUND_ERROR) {
			g_propagate_error (error, _inner_error_);
			_snd_ctl_elem_list_free0 (list);
			_snd_ctl_card_info_free0 (info);
			_snd_ctl_close0 (card);
			return NULL;
		} else {
			_snd_ctl_elem_list_free0 (list);
			_snd_ctl_card_info_free0 (info);
			_snd_ctl_close0 (card);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp60_ = card;
	_tmp61_ = list;
	_tmp62_ = snd_ctl_elem_list (_tmp60_, _tmp61_);
	res = _tmp62_;
	_tmp63_ = res;
	if (_tmp63_ < 0) {
		gint _tmp64_;
		const gchar* _tmp65_ = NULL;
		gchar* _tmp66_ = NULL;
		gchar* _tmp67_;
		GError* _tmp68_;
		GError* _tmp69_;
		_tmp64_ = res;
		_tmp65_ = snd_strerror (_tmp64_);
		_tmp66_ = g_strdup_printf ("%s", _tmp65_);
		_tmp67_ = _tmp66_;
		_tmp68_ = g_error_new_literal (FSO_DEVICE_SOUND_ERROR, FSO_DEVICE_SOUND_ERROR_DEVICE_ERROR, _tmp67_);
		_tmp69_ = _tmp68_;
		_g_free0 (_tmp67_);
		_inner_error_ = _tmp69_;
		if (_inner_error_->domain == FSO_DEVICE_SOUND_ERROR) {
			g_propagate_error (error, _inner_error_);
			_snd_ctl_elem_list_free0 (list);
			_snd_ctl_card_info_free0 (info);
			_snd_ctl_close0 (card);
			return NULL;
		} else {
			_snd_ctl_elem_list_free0 (list);
			_snd_ctl_card_info_free0 (info);
			_snd_ctl_close0 (card);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp70_ = info;
	_tmp71_ = snd_ctl_card_info_get_id (_tmp70_);
	_tmp72_ = info;
	_tmp73_ = snd_ctl_card_info_get_longname (_tmp72_);
	_tmp74_ = info;
	_tmp75_ = snd_ctl_card_info_get_mixername (_tmp74_);
	_tmp76_ = cardname;
	_tmp77_ = fso_device_sound_device_new (&card, &list, _tmp71_, _tmp73_, _tmp75_, _tmp76_);
	result = _tmp77_;
	_snd_ctl_elem_list_free0 (list);
	_snd_ctl_card_info_free0 (info);
	_snd_ctl_close0 (card);
	return result;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static gchar* fso_device_sound_device_real_repr (FsoFrameworkAbstractObject* base) {
	FsoDeviceSoundDevice * self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	self = (FsoDeviceSoundDevice*) base;
	_tmp0_ = self->name;
	_tmp1_ = string_to_string (_tmp0_);
	_tmp2_ = g_strconcat ("<", _tmp1_, ">", NULL);
	result = _tmp2_;
	return result;
}


FsoDeviceMixerControl* fso_device_sound_device_controlForId (FsoDeviceSoundDevice* self, guint idx, GError** error) {
	FsoDeviceMixerControl* result = NULL;
	snd_ctl_elem_id_t* eid = NULL;
	snd_ctl_elem_id_t* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint res;
	gint _tmp2_;
	snd_ctl_elem_list_t* _tmp9_;
	snd_ctl_elem_list_t* _tmp10_;
	guint _tmp11_;
	snd_ctl_elem_id_t* _tmp12_;
	snd_ctl_elem_info_t* info = NULL;
	snd_ctl_elem_info_t* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_;
	snd_ctl_elem_info_t* _tmp22_;
	snd_ctl_elem_id_t* _tmp23_;
	snd_ctl_t* _tmp24_;
	snd_ctl_elem_info_t* _tmp25_;
	gint _tmp26_ = 0;
	gint _tmp27_;
	snd_ctl_elem_value_t* value = NULL;
	snd_ctl_elem_value_t* _tmp34_ = NULL;
	gint _tmp35_ = 0;
	gint _tmp36_;
	snd_ctl_elem_value_t* _tmp43_;
	snd_ctl_elem_id_t* _tmp44_;
	snd_ctl_t* _tmp45_;
	snd_ctl_elem_value_t* _tmp46_;
	gint _tmp47_ = 0;
	gint _tmp48_;
	FsoDeviceMixerControl* _tmp55_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = snd_ctl_elem_id_malloc (&_tmp0_);
	_snd_ctl_elem_id_free0 (eid);
	eid = _tmp0_;
	res = _tmp1_;
	_tmp2_ = res;
	if (_tmp2_ < 0) {
		gint _tmp3_;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		GError* _tmp7_;
		GError* _tmp8_;
		_tmp3_ = res;
		_tmp4_ = snd_strerror (_tmp3_);
		_tmp5_ = g_strdup_printf ("%s", _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_error_new_literal (FSO_DEVICE_SOUND_ERROR, FSO_DEVICE_SOUND_ERROR_DEVICE_ERROR, _tmp6_);
		_tmp8_ = _tmp7_;
		_g_free0 (_tmp6_);
		_inner_error_ = _tmp8_;
		if (_inner_error_->domain == FSO_DEVICE_SOUND_ERROR) {
			g_propagate_error (error, _inner_error_);
			_snd_ctl_elem_id_free0 (eid);
			return NULL;
		} else {
			_snd_ctl_elem_id_free0 (eid);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp9_ = self->priv->list;
	g_assert (_tmp9_ != NULL);
	_tmp10_ = self->priv->list;
	_tmp11_ = idx;
	_tmp12_ = eid;
	snd_ctl_elem_list_get_id (_tmp10_, _tmp11_, _tmp12_);
	_tmp14_ = snd_ctl_elem_info_malloc (&_tmp13_);
	_snd_ctl_elem_info_free0 (info);
	info = _tmp13_;
	res = _tmp14_;
	_tmp15_ = res;
	if (_tmp15_ < 0) {
		gint _tmp16_;
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		GError* _tmp20_;
		GError* _tmp21_;
		_tmp16_ = res;
		_tmp17_ = snd_strerror (_tmp16_);
		_tmp18_ = g_strdup_printf ("%s", _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_error_new_literal (FSO_DEVICE_SOUND_ERROR, FSO_DEVICE_SOUND_ERROR_DEVICE_ERROR, _tmp19_);
		_tmp21_ = _tmp20_;
		_g_free0 (_tmp19_);
		_inner_error_ = _tmp21_;
		if (_inner_error_->domain == FSO_DEVICE_SOUND_ERROR) {
			g_propagate_error (error, _inner_error_);
			_snd_ctl_elem_info_free0 (info);
			_snd_ctl_elem_id_free0 (eid);
			return NULL;
		} else {
			_snd_ctl_elem_info_free0 (info);
			_snd_ctl_elem_id_free0 (eid);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp22_ = info;
	_tmp23_ = eid;
	snd_ctl_elem_info_set_id (_tmp22_, _tmp23_);
	_tmp24_ = self->priv->card;
	_tmp25_ = info;
	_tmp26_ = snd_ctl_elem_info (_tmp24_, _tmp25_);
	res = _tmp26_;
	_tmp27_ = res;
	if (_tmp27_ < 0) {
		gint _tmp28_;
		const gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_;
		GError* _tmp32_;
		GError* _tmp33_;
		_tmp28_ = res;
		_tmp29_ = snd_strerror (_tmp28_);
		_tmp30_ = g_strdup_printf ("%s", _tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = g_error_new_literal (FSO_DEVICE_SOUND_ERROR, FSO_DEVICE_SOUND_ERROR_DEVICE_ERROR, _tmp31_);
		_tmp33_ = _tmp32_;
		_g_free0 (_tmp31_);
		_inner_error_ = _tmp33_;
		if (_inner_error_->domain == FSO_DEVICE_SOUND_ERROR) {
			g_propagate_error (error, _inner_error_);
			_snd_ctl_elem_info_free0 (info);
			_snd_ctl_elem_id_free0 (eid);
			return NULL;
		} else {
			_snd_ctl_elem_info_free0 (info);
			_snd_ctl_elem_id_free0 (eid);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp35_ = snd_ctl_elem_value_malloc (&_tmp34_);
	_snd_ctl_elem_value_free0 (value);
	value = _tmp34_;
	res = _tmp35_;
	_tmp36_ = res;
	if (_tmp36_ < 0) {
		gint _tmp37_;
		const gchar* _tmp38_ = NULL;
		gchar* _tmp39_ = NULL;
		gchar* _tmp40_;
		GError* _tmp41_;
		GError* _tmp42_;
		_tmp37_ = res;
		_tmp38_ = snd_strerror (_tmp37_);
		_tmp39_ = g_strdup_printf ("%s", _tmp38_);
		_tmp40_ = _tmp39_;
		_tmp41_ = g_error_new_literal (FSO_DEVICE_SOUND_ERROR, FSO_DEVICE_SOUND_ERROR_DEVICE_ERROR, _tmp40_);
		_tmp42_ = _tmp41_;
		_g_free0 (_tmp40_);
		_inner_error_ = _tmp42_;
		if (_inner_error_->domain == FSO_DEVICE_SOUND_ERROR) {
			g_propagate_error (error, _inner_error_);
			_snd_ctl_elem_value_free0 (value);
			_snd_ctl_elem_info_free0 (info);
			_snd_ctl_elem_id_free0 (eid);
			return NULL;
		} else {
			_snd_ctl_elem_value_free0 (value);
			_snd_ctl_elem_info_free0 (info);
			_snd_ctl_elem_id_free0 (eid);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp43_ = value;
	_tmp44_ = eid;
	snd_ctl_elem_value_set_id (_tmp43_, _tmp44_);
	_tmp45_ = self->priv->card;
	_tmp46_ = value;
	_tmp47_ = snd_ctl_elem_read (_tmp45_, _tmp46_);
	res = _tmp47_;
	_tmp48_ = res;
	if (_tmp48_ < 0) {
		gint _tmp49_;
		const gchar* _tmp50_ = NULL;
		gchar* _tmp51_ = NULL;
		gchar* _tmp52_;
		GError* _tmp53_;
		GError* _tmp54_;
		_tmp49_ = res;
		_tmp50_ = snd_strerror (_tmp49_);
		_tmp51_ = g_strdup_printf ("%s", _tmp50_);
		_tmp52_ = _tmp51_;
		_tmp53_ = g_error_new_literal (FSO_DEVICE_SOUND_ERROR, FSO_DEVICE_SOUND_ERROR_DEVICE_ERROR, _tmp52_);
		_tmp54_ = _tmp53_;
		_g_free0 (_tmp52_);
		_inner_error_ = _tmp54_;
		if (_inner_error_->domain == FSO_DEVICE_SOUND_ERROR) {
			g_propagate_error (error, _inner_error_);
			_snd_ctl_elem_value_free0 (value);
			_snd_ctl_elem_info_free0 (info);
			_snd_ctl_elem_id_free0 (eid);
			return NULL;
		} else {
			_snd_ctl_elem_value_free0 (value);
			_snd_ctl_elem_info_free0 (info);
			_snd_ctl_elem_id_free0 (eid);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp55_ = fso_device_mixer_control_new (&eid, &info, &value);
	result = _tmp55_;
	_snd_ctl_elem_value_free0 (value);
	_snd_ctl_elem_info_free0 (info);
	_snd_ctl_elem_id_free0 (eid);
	return result;
}


/**
     * Set control to the value specified by @a MixerControl.
     **/
void fso_device_sound_device_setControl (FsoDeviceSoundDevice* self, FsoDeviceMixerControl* control, GError** error) {
	FsoDeviceMixerControl* _tmp0_;
	snd_ctl_elem_info_t* _tmp1_;
	snd_ctl_elem_type_t _tmp2_ = 0;
	snd_ctl_elem_type_t type;
	snd_ctl_elem_type_t _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (control != NULL);
	_tmp0_ = control;
	_tmp1_ = _tmp0_->info;
	_tmp2_ = snd_ctl_elem_info_get_type (_tmp1_);
	type = _tmp2_;
	_tmp3_ = type;
	if (_tmp3_ != SND_CTL_ELEM_TYPE_IEC958) {
		snd_ctl_t* _tmp4_;
		FsoDeviceMixerControl* _tmp5_;
		snd_ctl_elem_value_t* _tmp6_;
		gint _tmp7_ = 0;
		gint res;
		gint _tmp8_;
		_tmp4_ = self->priv->card;
		_tmp5_ = control;
		_tmp6_ = _tmp5_->value;
		_tmp7_ = snd_ctl_elem_write (_tmp4_, _tmp6_);
		res = _tmp7_;
		_tmp8_ = res;
		if (_tmp8_ < 0) {
			gint _tmp9_;
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			gchar* _tmp12_;
			GError* _tmp13_;
			GError* _tmp14_;
			_tmp9_ = res;
			_tmp10_ = snd_strerror (_tmp9_);
			_tmp11_ = g_strdup_printf ("%s", _tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_error_new_literal (FSO_DEVICE_SOUND_ERROR, FSO_DEVICE_SOUND_ERROR_DEVICE_ERROR, _tmp12_);
			_tmp14_ = _tmp13_;
			_g_free0 (_tmp12_);
			_inner_error_ = _tmp14_;
			if (_inner_error_->domain == FSO_DEVICE_SOUND_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	} else {
	}
}


/**
     * Get all controls (aka a scenario).
     **/
static void _vala_array_add1 (FsoDeviceMixerControl*** array, int* length, int* size, FsoDeviceMixerControl* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (FsoDeviceMixerControl*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


FsoDeviceMixerControl** fso_device_sound_device_allMixerControls (FsoDeviceSoundDevice* self, int* result_length1, GError** error) {
	FsoDeviceMixerControl** result = NULL;
	FsoDeviceMixerControl** _tmp0_ = NULL;
	FsoDeviceMixerControl** controls;
	gint controls_length1;
	gint _controls_size_;
	snd_ctl_elem_list_t* _tmp1_;
	guint _tmp2_ = 0U;
	guint count;
	FsoDeviceMixerControl** _tmp12_;
	gint _tmp12__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (FsoDeviceMixerControl*, 0 + 1);
	controls = _tmp0_;
	controls_length1 = 0;
	_controls_size_ = controls_length1;
	_tmp1_ = self->priv->list;
	_tmp2_ = snd_ctl_elem_list_get_count (_tmp1_);
	count = _tmp2_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_;
				gint _tmp6_;
				guint _tmp7_;
				gint _tmp8_;
				FsoDeviceMixerControl* _tmp9_ = NULL;
				FsoDeviceMixerControl* _tmp10_;
				FsoDeviceMixerControl** _tmp11_;
				gint _tmp11__length1;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = count;
				if (!(((guint) _tmp6_) < _tmp7_)) {
					break;
				}
				_tmp8_ = i;
				_tmp9_ = fso_device_sound_device_controlForId (self, (guint) _tmp8_, &_inner_error_);
				_tmp10_ = _tmp9_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == FSO_DEVICE_SOUND_ERROR) {
						g_propagate_error (error, _inner_error_);
						controls = (_vala_array_free (controls, controls_length1, (GDestroyNotify) fso_device_mixer_control_unref), NULL);
						return NULL;
					} else {
						controls = (_vala_array_free (controls, controls_length1, (GDestroyNotify) fso_device_mixer_control_unref), NULL);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp11_ = controls;
				_tmp11__length1 = controls_length1;
				_vala_array_add1 (&controls, &controls_length1, &_controls_size_, _tmp10_);
			}
		}
	}
	_tmp12_ = controls;
	_tmp12__length1 = controls_length1;
	if (result_length1) {
		*result_length1 = _tmp12__length1;
	}
	result = _tmp12_;
	return result;
}


/**
     * Set all controls (aka a scenario).
     **/
void fso_device_sound_device_setAllMixerControls (FsoDeviceSoundDevice* self, FsoDeviceMixerControl** controls, int controls_length1, GError** error) {
	FsoDeviceMixerControl** _tmp0_;
	gint _tmp0__length1;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = controls;
	_tmp0__length1 = controls_length1;
	{
		FsoDeviceMixerControl** control_collection = NULL;
		gint control_collection_length1 = 0;
		gint _control_collection_size_ = 0;
		gint control_it = 0;
		control_collection = _tmp0_;
		control_collection_length1 = _tmp0__length1;
		for (control_it = 0; control_it < _tmp0__length1; control_it = control_it + 1) {
			FsoDeviceMixerControl* _tmp1_;
			FsoDeviceMixerControl* control = NULL;
			_tmp1_ = _fso_device_mixer_control_ref0 (control_collection[control_it]);
			control = _tmp1_;
			{
				FsoDeviceMixerControl* _tmp2_;
				_tmp2_ = control;
				fso_device_sound_device_setControl (self, _tmp2_, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == FSO_DEVICE_SOUND_ERROR) {
						g_propagate_error (error, _inner_error_);
						_fso_device_mixer_control_unref0 (control);
						return;
					} else {
						_fso_device_mixer_control_unref0 (control);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_fso_device_mixer_control_unref0 (control);
			}
		}
	}
}


/**
     * Construct @a MixerControl from a string description.
     **/
static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


FsoDeviceMixerControl* fso_device_sound_device_controlForString (FsoDeviceSoundDevice* self, const gchar* description, GError** error) {
	FsoDeviceMixerControl* result = NULL;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** strings;
	gint strings_length1;
	gint _strings_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp9_;
	gint _tmp9__length1;
	const gchar* _tmp10_;
	gint _tmp11_ = 0;
	gint idx;
	gchar** _tmp12_;
	gint _tmp12__length1;
	const gchar* _tmp13_;
	gint _tmp14_ = 0;
	gint count;
	gchar** _tmp15_;
	gint _tmp15__length1;
	const gchar* _tmp16_;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_;
	gchar** _tmp19_;
	gchar** _tmp20_ = NULL;
	gchar** _tmp21_;
	gint _tmp21__length1;
	gchar** segments;
	gint segments_length1;
	gint _segments_size_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	gint _tmp23_;
	gint _tmp30_;
	FsoDeviceMixerControl* _tmp31_ = NULL;
	FsoDeviceMixerControl* control;
	FsoDeviceMixerControl* _tmp32_;
	snd_ctl_elem_info_t* _tmp33_;
	snd_ctl_elem_type_t _tmp34_ = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (description != NULL, NULL);
	_tmp0_ = description;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, ":", 0);
	strings = _tmp2_;
	strings_length1 = _vala_array_length (_tmp1_);
	_strings_size_ = strings_length1;
	_tmp3_ = strings;
	_tmp3__length1 = strings_length1;
	if (_tmp3__length1 != 4) {
		gchar** _tmp4_;
		gint _tmp4__length1;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		GError* _tmp7_;
		GError* _tmp8_;
		_tmp4_ = strings;
		_tmp4__length1 = strings_length1;
		_tmp5_ = g_strdup_printf ("Expected 4 descriptor components, got %d", _tmp4__length1);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_error_new_literal (FSO_DEVICE_SOUND_ERROR, FSO_DEVICE_SOUND_ERROR_INVALID_DESCRIPTOR, _tmp6_);
		_tmp8_ = _tmp7_;
		_g_free0 (_tmp6_);
		_inner_error_ = _tmp8_;
		if (_inner_error_->domain == FSO_DEVICE_SOUND_ERROR) {
			g_propagate_error (error, _inner_error_);
			strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		} else {
			strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp9_ = strings;
	_tmp9__length1 = strings_length1;
	_tmp10_ = _tmp9_[0];
	_tmp11_ = atoi (_tmp10_);
	idx = _tmp11_;
	_tmp12_ = strings;
	_tmp12__length1 = strings_length1;
	_tmp13_ = _tmp12_[2];
	_tmp14_ = atoi (_tmp13_);
	count = _tmp14_;
	_tmp15_ = strings;
	_tmp15__length1 = strings_length1;
	_tmp16_ = _tmp15_[3];
	_tmp17_ = string_strip (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp20_ = _tmp19_ = g_strsplit (_tmp18_, ",", 0);
	_tmp21_ = _tmp20_;
	_tmp21__length1 = _vala_array_length (_tmp19_);
	_g_free0 (_tmp18_);
	segments = _tmp21_;
	segments_length1 = _tmp21__length1;
	_segments_size_ = segments_length1;
	_tmp22_ = segments;
	_tmp22__length1 = segments_length1;
	_tmp23_ = count;
	if (_tmp22__length1 != _tmp23_) {
		gint _tmp24_;
		gchar** _tmp25_;
		gint _tmp25__length1;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_;
		GError* _tmp28_;
		GError* _tmp29_;
		_tmp24_ = count;
		_tmp25_ = segments;
		_tmp25__length1 = segments_length1;
		_tmp26_ = g_strdup_printf ("Expected %d value parameters, got %d", _tmp24_, _tmp25__length1);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_error_new_literal (FSO_DEVICE_SOUND_ERROR, FSO_DEVICE_SOUND_ERROR_INVALID_DESCRIPTOR, _tmp27_);
		_tmp29_ = _tmp28_;
		_g_free0 (_tmp27_);
		_inner_error_ = _tmp29_;
		if (_inner_error_->domain == FSO_DEVICE_SOUND_ERROR) {
			g_propagate_error (error, _inner_error_);
			segments = (_vala_array_free (segments, segments_length1, (GDestroyNotify) g_free), NULL);
			strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		} else {
			segments = (_vala_array_free (segments, segments_length1, (GDestroyNotify) g_free), NULL);
			strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp30_ = idx;
	_tmp31_ = fso_device_sound_device_controlForId (self, (guint) (_tmp30_ - 1), &_inner_error_);
	control = _tmp31_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == FSO_DEVICE_SOUND_ERROR) {
			g_propagate_error (error, _inner_error_);
			segments = (_vala_array_free (segments, segments_length1, (GDestroyNotify) g_free), NULL);
			strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		} else {
			segments = (_vala_array_free (segments, segments_length1, (GDestroyNotify) g_free), NULL);
			strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp32_ = control;
	_tmp33_ = _tmp32_->info;
	_tmp34_ = snd_ctl_elem_info_get_type (_tmp33_);
	switch (_tmp34_) {
		case SND_CTL_ELEM_TYPE_BOOLEAN:
		{
			{
				gint i;
				i = 0;
				{
					gboolean _tmp35_;
					_tmp35_ = TRUE;
					while (TRUE) {
						gboolean _tmp36_;
						gint _tmp38_;
						gint _tmp39_;
						FsoDeviceMixerControl* _tmp40_;
						snd_ctl_elem_value_t* _tmp41_;
						gint _tmp42_;
						gchar** _tmp43_;
						gint _tmp43__length1;
						gint _tmp44_;
						const gchar* _tmp45_;
						_tmp36_ = _tmp35_;
						if (!_tmp36_) {
							gint _tmp37_;
							_tmp37_ = i;
							i = _tmp37_ + 1;
						}
						_tmp35_ = FALSE;
						_tmp38_ = i;
						_tmp39_ = count;
						if (!(_tmp38_ < _tmp39_)) {
							break;
						}
						_tmp40_ = control;
						_tmp41_ = _tmp40_->value;
						_tmp42_ = i;
						_tmp43_ = segments;
						_tmp43__length1 = segments_length1;
						_tmp44_ = i;
						_tmp45_ = _tmp43_[_tmp44_];
						snd_ctl_elem_value_set_boolean (_tmp41_, (guint) _tmp42_, g_strcmp0 (_tmp45_, "1") == 0);
					}
				}
			}
			break;
		}
		case SND_CTL_ELEM_TYPE_INTEGER:
		{
			{
				gint i;
				i = 0;
				{
					gboolean _tmp46_;
					_tmp46_ = TRUE;
					while (TRUE) {
						gboolean _tmp47_;
						gint _tmp49_;
						gint _tmp50_;
						FsoDeviceMixerControl* _tmp51_;
						snd_ctl_elem_value_t* _tmp52_;
						gint _tmp53_;
						gchar** _tmp54_;
						gint _tmp54__length1;
						gint _tmp55_;
						const gchar* _tmp56_;
						gint _tmp57_ = 0;
						_tmp47_ = _tmp46_;
						if (!_tmp47_) {
							gint _tmp48_;
							_tmp48_ = i;
							i = _tmp48_ + 1;
						}
						_tmp46_ = FALSE;
						_tmp49_ = i;
						_tmp50_ = count;
						if (!(_tmp49_ < _tmp50_)) {
							break;
						}
						_tmp51_ = control;
						_tmp52_ = _tmp51_->value;
						_tmp53_ = i;
						_tmp54_ = segments;
						_tmp54__length1 = segments_length1;
						_tmp55_ = i;
						_tmp56_ = _tmp54_[_tmp55_];
						_tmp57_ = atoi (_tmp56_);
						snd_ctl_elem_value_set_integer (_tmp52_, (guint) _tmp53_, (glong) _tmp57_);
					}
				}
			}
			break;
		}
		case SND_CTL_ELEM_TYPE_INTEGER64:
		{
			{
				gint i;
				i = 0;
				{
					gboolean _tmp58_;
					_tmp58_ = TRUE;
					while (TRUE) {
						gboolean _tmp59_;
						gint _tmp61_;
						gint _tmp62_;
						FsoDeviceMixerControl* _tmp63_;
						snd_ctl_elem_value_t* _tmp64_;
						gint _tmp65_;
						gchar** _tmp66_;
						gint _tmp66__length1;
						gint _tmp67_;
						const gchar* _tmp68_;
						gint64 _tmp69_ = 0LL;
						_tmp59_ = _tmp58_;
						if (!_tmp59_) {
							gint _tmp60_;
							_tmp60_ = i;
							i = _tmp60_ + 1;
						}
						_tmp58_ = FALSE;
						_tmp61_ = i;
						_tmp62_ = count;
						if (!(_tmp61_ < _tmp62_)) {
							break;
						}
						_tmp63_ = control;
						_tmp64_ = _tmp63_->value;
						_tmp65_ = i;
						_tmp66_ = segments;
						_tmp66__length1 = segments_length1;
						_tmp67_ = i;
						_tmp68_ = _tmp66_[_tmp67_];
						_tmp69_ = g_ascii_strtoll (_tmp68_, NULL, 0);
						snd_ctl_elem_value_set_integer64 (_tmp64_, (guint) _tmp65_, _tmp69_);
					}
				}
			}
			break;
		}
		case SND_CTL_ELEM_TYPE_ENUMERATED:
		{
			{
				gint i;
				i = 0;
				{
					gboolean _tmp70_;
					_tmp70_ = TRUE;
					while (TRUE) {
						gboolean _tmp71_;
						gint _tmp73_;
						gint _tmp74_;
						FsoDeviceMixerControl* _tmp75_;
						snd_ctl_elem_value_t* _tmp76_;
						gint _tmp77_;
						gchar** _tmp78_;
						gint _tmp78__length1;
						gint _tmp79_;
						const gchar* _tmp80_;
						gint _tmp81_ = 0;
						_tmp71_ = _tmp70_;
						if (!_tmp71_) {
							gint _tmp72_;
							_tmp72_ = i;
							i = _tmp72_ + 1;
						}
						_tmp70_ = FALSE;
						_tmp73_ = i;
						_tmp74_ = count;
						if (!(_tmp73_ < _tmp74_)) {
							break;
						}
						_tmp75_ = control;
						_tmp76_ = _tmp75_->value;
						_tmp77_ = i;
						_tmp78_ = segments;
						_tmp78__length1 = segments_length1;
						_tmp79_ = i;
						_tmp80_ = _tmp78_[_tmp79_];
						_tmp81_ = atoi (_tmp80_);
						snd_ctl_elem_value_set_enumerated (_tmp76_, (guint) _tmp77_, (guint) _tmp81_);
					}
				}
			}
			break;
		}
		case SND_CTL_ELEM_TYPE_BYTES:
		{
			{
				gint i;
				i = 0;
				{
					gboolean _tmp82_;
					_tmp82_ = TRUE;
					while (TRUE) {
						gboolean _tmp83_;
						gint _tmp85_;
						gint _tmp86_;
						FsoDeviceMixerControl* _tmp87_;
						snd_ctl_elem_value_t* _tmp88_;
						gint _tmp89_;
						gchar** _tmp90_;
						gint _tmp90__length1;
						gint _tmp91_;
						const gchar* _tmp92_;
						gint _tmp93_ = 0;
						_tmp83_ = _tmp82_;
						if (!_tmp83_) {
							gint _tmp84_;
							_tmp84_ = i;
							i = _tmp84_ + 1;
						}
						_tmp82_ = FALSE;
						_tmp85_ = i;
						_tmp86_ = count;
						if (!(_tmp85_ < _tmp86_)) {
							break;
						}
						_tmp87_ = control;
						_tmp88_ = _tmp87_->value;
						_tmp89_ = i;
						_tmp90_ = segments;
						_tmp90__length1 = segments_length1;
						_tmp91_ = i;
						_tmp92_ = _tmp90_[_tmp91_];
						_tmp93_ = atoi (_tmp92_);
						snd_ctl_elem_value_set_byte (_tmp88_, (guint) _tmp89_, (guchar) (_tmp93_ & 0xff));
					}
				}
			}
			break;
		}
		case SND_CTL_ELEM_TYPE_IEC958:
		{
			break;
		}
		default:
		{
			FsoDeviceMixerControl* _tmp94_;
			snd_ctl_elem_info_t* _tmp95_;
			snd_ctl_elem_type_t _tmp96_ = 0;
			gchar* _tmp97_ = NULL;
			gchar* _tmp98_;
			_tmp94_ = control;
			_tmp95_ = _tmp94_->info;
			_tmp96_ = snd_ctl_elem_info_get_type (_tmp95_);
			_tmp97_ = g_strdup_printf ("Unknown type %d... ignoring", (gint) _tmp96_);
			_tmp98_ = _tmp97_;
			g_warning ("alsa.vala:256: %s", _tmp98_);
			_g_free0 (_tmp98_);
			break;
		}
	}
	result = control;
	segments = (_vala_array_free (segments, segments_length1, (GDestroyNotify) g_free), NULL);
	strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


/**
     * @return volume percent for mixer element with @a id
     **/
guint8 fso_device_sound_device_volumeForIndex (FsoDeviceSoundDevice* self, guint id) {
	guint8 result = 0U;
	snd_mixer_t* mix = NULL;
	snd_mixer_t* _tmp0_ = NULL;
	snd_mixer_t* _tmp1_;
	snd_mixer_t* _tmp2_;
	const gchar* _tmp3_;
	snd_mixer_t* _tmp4_;
	snd_mixer_t* _tmp5_;
	snd_mixer_t* _tmp6_;
	snd_mixer_elem_t* _tmp7_ = NULL;
	snd_mixer_elem_t* mel;
	snd_mixer_elem_t* _tmp8_;
	glong val = 0L;
	glong min = 0L;
	glong max = 0L;
	snd_mixer_elem_t* _tmp13_;
	glong _tmp14_ = 0L;
	snd_mixer_elem_t* _tmp15_;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gdouble _tmp22_ = 0.0;
	g_return_val_if_fail (self != NULL, 0U);
	snd_mixer_open (&_tmp0_, 0);
	_snd_mixer_close0 (mix);
	mix = _tmp0_;
	_tmp1_ = mix;
	g_assert (_tmp1_ != NULL);
	_tmp2_ = mix;
	_tmp3_ = self->cardname;
	snd_mixer_attach (_tmp2_, _tmp3_);
	_tmp4_ = mix;
	snd_mixer_selem_register (_tmp4_, NULL, NULL);
	_tmp5_ = mix;
	snd_mixer_load (_tmp5_);
	_tmp6_ = mix;
	_tmp7_ = snd_mixer_first_elem (_tmp6_);
	mel = _tmp7_;
	_tmp8_ = mel;
	if (_tmp8_ == NULL) {
		g_warning ("alsa.vala:277: mix.first_elem() returned NULL");
		result = (guint8) 0;
		_0 (mel);
		_snd_mixer_close0 (mix);
		return result;
	}
	while (TRUE) {
		guint _tmp9_;
		snd_mixer_elem_t* _tmp10_;
		snd_mixer_elem_t* _tmp11_ = NULL;
		snd_mixer_elem_t* _tmp12_;
		_tmp9_ = id;
		id = _tmp9_ - 1;
		if (!(_tmp9_ > ((guint) 0))) {
			break;
		}
		_tmp10_ = mel;
		_tmp11_ = snd_mixer_elem_next (_tmp10_);
		_0 (mel);
		mel = _tmp11_;
		_tmp12_ = mel;
		g_assert (_tmp12_ != NULL);
	}
	_tmp13_ = mel;
	snd_mixer_selem_get_playback_volume (_tmp13_, SND_MIXER_SCHN_MONO, &_tmp14_);
	val = _tmp14_;
	_tmp15_ = mel;
	snd_mixer_selem_get_playback_volume_range (_tmp15_, &_tmp16_, &_tmp17_);
	min = _tmp16_;
	max = _tmp17_;
	_tmp18_ = val;
	_tmp19_ = min;
	_tmp20_ = max;
	_tmp21_ = min;
	_tmp22_ = round (((_tmp18_ - _tmp19_) * 100) / ((gdouble) (_tmp20_ - _tmp21_)));
	result = (guint8) _tmp22_;
	_0 (mel);
	_snd_mixer_close0 (mix);
	return result;
}


/**
     * @set volume percent for mixer element with @a id
     **/
void fso_device_sound_device_setVolumeForIndex (FsoDeviceSoundDevice* self, guint id, guint8 val) {
	snd_mixer_t* mix = NULL;
	snd_mixer_t* _tmp0_ = NULL;
	snd_mixer_t* _tmp1_;
	snd_mixer_t* _tmp2_;
	const gchar* _tmp3_;
	snd_mixer_t* _tmp4_;
	snd_mixer_t* _tmp5_;
	snd_mixer_t* _tmp6_;
	snd_mixer_elem_t* _tmp7_ = NULL;
	snd_mixer_elem_t* mel;
	snd_mixer_elem_t* _tmp8_;
	glong min = 0L;
	glong max = 0L;
	snd_mixer_elem_t* _tmp13_;
	glong _tmp14_ = 0L;
	glong _tmp15_ = 0L;
	snd_mixer_elem_t* _tmp16_;
	glong _tmp17_;
	guint8 _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	g_return_if_fail (self != NULL);
	snd_mixer_open (&_tmp0_, 0);
	_snd_mixer_close0 (mix);
	mix = _tmp0_;
	_tmp1_ = mix;
	g_assert (_tmp1_ != NULL);
	_tmp2_ = mix;
	_tmp3_ = self->cardname;
	snd_mixer_attach (_tmp2_, _tmp3_);
	_tmp4_ = mix;
	snd_mixer_selem_register (_tmp4_, NULL, NULL);
	_tmp5_ = mix;
	snd_mixer_load (_tmp5_);
	_tmp6_ = mix;
	_tmp7_ = snd_mixer_first_elem (_tmp6_);
	mel = _tmp7_;
	_tmp8_ = mel;
	if (_tmp8_ == NULL) {
		g_warning ("alsa.vala:310: mix.first_elem() returned NULL");
		_0 (mel);
		_snd_mixer_close0 (mix);
		return;
	}
	while (TRUE) {
		guint _tmp9_;
		snd_mixer_elem_t* _tmp10_;
		snd_mixer_elem_t* _tmp11_ = NULL;
		snd_mixer_elem_t* _tmp12_;
		_tmp9_ = id;
		id = _tmp9_ - 1;
		if (!(_tmp9_ > ((guint) 0))) {
			break;
		}
		_tmp10_ = mel;
		_tmp11_ = snd_mixer_elem_next (_tmp10_);
		_0 (mel);
		mel = _tmp11_;
		_tmp12_ = mel;
		g_assert (_tmp12_ != NULL);
	}
	_tmp13_ = mel;
	snd_mixer_selem_get_playback_volume_range (_tmp13_, &_tmp14_, &_tmp15_);
	min = _tmp14_;
	max = _tmp15_;
	_tmp16_ = mel;
	_tmp17_ = min;
	_tmp18_ = val;
	_tmp19_ = max;
	_tmp20_ = min;
	snd_mixer_selem_set_playback_volume_all (_tmp16_, _tmp17_ + ((_tmp18_ * (_tmp19_ - _tmp20_)) / 100));
	_0 (mel);
	_snd_mixer_close0 (mix);
}


static void fso_device_sound_device_class_init (FsoDeviceSoundDeviceClass * klass) {
	fso_device_sound_device_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FsoDeviceSoundDevicePrivate));
	FSO_FRAMEWORK_ABSTRACT_OBJECT_CLASS (klass)->repr = fso_device_sound_device_real_repr;
	G_OBJECT_CLASS (klass)->finalize = fso_device_sound_device_finalize;
}


static void fso_device_sound_device_instance_init (FsoDeviceSoundDevice * self) {
	self->priv = FSO_DEVICE_SOUND_DEVICE_GET_PRIVATE (self);
}


static void fso_device_sound_device_finalize (GObject* obj) {
	FsoDeviceSoundDevice * self;
	self = FSO_DEVICE_SOUND_DEVICE (obj);
	_snd_ctl_close0 (self->priv->card);
	_snd_ctl_elem_list_free0 (self->priv->list);
	_g_free0 (self->name);
	_g_free0 (self->fullname);
	_g_free0 (self->mixername);
	_g_free0 (self->cardname);
	G_OBJECT_CLASS (fso_device_sound_device_parent_class)->finalize (obj);
}


/**
 * @class FsoDevice.SoundDevice
 **/
GType fso_device_sound_device_get_type (void) {
	static volatile gsize fso_device_sound_device_type_id__volatile = 0;
	if (g_once_init_enter (&fso_device_sound_device_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FsoDeviceSoundDeviceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fso_device_sound_device_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FsoDeviceSoundDevice), 0, (GInstanceInitFunc) fso_device_sound_device_instance_init, NULL };
		GType fso_device_sound_device_type_id;
		fso_device_sound_device_type_id = g_type_register_static (FSO_FRAMEWORK_TYPE_ABSTRACT_OBJECT, "FsoDeviceSoundDevice", &g_define_type_info, 0);
		g_once_init_leave (&fso_device_sound_device_type_id__volatile, fso_device_sound_device_type_id);
	}
	return fso_device_sound_device_type_id__volatile;
}


FsoDeviceMixerControl* fso_device_mixer_control_construct (GType object_type, snd_ctl_elem_id_t** eid, snd_ctl_elem_info_t** info, snd_ctl_elem_value_t** value) {
	FsoDeviceMixerControl* self = NULL;
	snd_ctl_elem_id_t* _tmp0_;
	snd_ctl_elem_info_t* _tmp1_;
	snd_ctl_elem_value_t* _tmp2_;
	g_return_val_if_fail (eid != NULL, NULL);
	g_return_val_if_fail (info != NULL, NULL);
	g_return_val_if_fail (value != NULL, NULL);
	self = (FsoDeviceMixerControl*) g_type_create_instance (object_type);
	_tmp0_ = *eid;
	*eid = NULL;
	_snd_ctl_elem_id_free0 (self->eid);
	self->eid = _tmp0_;
	_tmp1_ = *info;
	*info = NULL;
	_snd_ctl_elem_info_free0 (self->info);
	self->info = _tmp1_;
	_tmp2_ = *value;
	*value = NULL;
	_snd_ctl_elem_value_free0 (self->value);
	self->value = _tmp2_;
	return self;
}


FsoDeviceMixerControl* fso_device_mixer_control_new (snd_ctl_elem_id_t** eid, snd_ctl_elem_info_t** info, snd_ctl_elem_value_t** value) {
	return fso_device_mixer_control_construct (FSO_DEVICE_TYPE_MIXER_CONTROL, eid, info, value);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


gchar* fso_device_mixer_control_to_string (FsoDeviceMixerControl* self) {
	gchar* result = NULL;
	snd_ctl_elem_id_t* _tmp0_;
	guint _tmp1_ = 0U;
	snd_ctl_elem_id_t* _tmp2_;
	const gchar* _tmp3_ = NULL;
	snd_ctl_elem_info_t* _tmp4_;
	guint _tmp5_ = 0U;
	gchar* _tmp6_ = NULL;
	gchar* infoline;
	snd_ctl_elem_info_t* _tmp7_;
	snd_ctl_elem_type_t _tmp8_ = 0;
	snd_ctl_elem_type_t type;
	snd_ctl_elem_info_t* _tmp9_;
	guint _tmp10_ = 0U;
	guint count;
	snd_ctl_elem_type_t _tmp11_;
	gchar* _tmp84_ = NULL;
	const gchar* _tmp85_;
	const gchar* _tmp86_;
	gint _tmp87_;
	gint _tmp88_;
	gchar _tmp89_ = '\0';
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->eid;
	_tmp1_ = snd_ctl_elem_id_get_numid (_tmp0_);
	_tmp2_ = self->eid;
	_tmp3_ = snd_ctl_elem_id_get_name (_tmp2_);
	_tmp4_ = self->info;
	_tmp5_ = snd_ctl_elem_info_get_count (_tmp4_);
	_tmp6_ = g_strdup_printf ("%u:'%s':%u:", _tmp1_, _tmp3_, _tmp5_);
	infoline = _tmp6_;
	_tmp7_ = self->info;
	_tmp8_ = snd_ctl_elem_info_get_type (_tmp7_);
	type = _tmp8_;
	_tmp9_ = self->info;
	_tmp10_ = snd_ctl_elem_info_get_count (_tmp9_);
	count = _tmp10_;
	_tmp11_ = type;
	switch (_tmp11_) {
		case SND_CTL_ELEM_TYPE_BOOLEAN:
		{
			{
				gint i;
				i = 0;
				{
					gboolean _tmp12_;
					_tmp12_ = TRUE;
					while (TRUE) {
						gboolean _tmp13_;
						gint _tmp15_;
						guint _tmp16_;
						const gchar* _tmp17_;
						snd_ctl_elem_value_t* _tmp18_;
						gint _tmp19_;
						gboolean _tmp20_ = FALSE;
						gchar* _tmp21_ = NULL;
						gchar* _tmp22_;
						gchar* _tmp23_;
						_tmp13_ = _tmp12_;
						if (!_tmp13_) {
							gint _tmp14_;
							_tmp14_ = i;
							i = _tmp14_ + 1;
						}
						_tmp12_ = FALSE;
						_tmp15_ = i;
						_tmp16_ = count;
						if (!(((guint) _tmp15_) < _tmp16_)) {
							break;
						}
						_tmp17_ = infoline;
						_tmp18_ = self->value;
						_tmp19_ = i;
						_tmp20_ = snd_ctl_elem_value_get_boolean (_tmp18_, (guint) _tmp19_);
						_tmp21_ = g_strdup_printf ("%u,", (guint) _tmp20_);
						_tmp22_ = _tmp21_;
						_tmp23_ = g_strconcat (_tmp17_, _tmp22_, NULL);
						_g_free0 (infoline);
						infoline = _tmp23_;
						_g_free0 (_tmp22_);
					}
				}
			}
			break;
		}
		case SND_CTL_ELEM_TYPE_INTEGER:
		{
			{
				gint i;
				i = 0;
				{
					gboolean _tmp24_;
					_tmp24_ = TRUE;
					while (TRUE) {
						gboolean _tmp25_;
						gint _tmp27_;
						guint _tmp28_;
						const gchar* _tmp29_;
						snd_ctl_elem_value_t* _tmp30_;
						gint _tmp31_;
						glong _tmp32_ = 0L;
						gchar* _tmp33_ = NULL;
						gchar* _tmp34_;
						gchar* _tmp35_;
						_tmp25_ = _tmp24_;
						if (!_tmp25_) {
							gint _tmp26_;
							_tmp26_ = i;
							i = _tmp26_ + 1;
						}
						_tmp24_ = FALSE;
						_tmp27_ = i;
						_tmp28_ = count;
						if (!(((guint) _tmp27_) < _tmp28_)) {
							break;
						}
						_tmp29_ = infoline;
						_tmp30_ = self->value;
						_tmp31_ = i;
						_tmp32_ = snd_ctl_elem_value_get_integer (_tmp30_, (guint) _tmp31_);
						_tmp33_ = g_strdup_printf ("%ld,", _tmp32_);
						_tmp34_ = _tmp33_;
						_tmp35_ = g_strconcat (_tmp29_, _tmp34_, NULL);
						_g_free0 (infoline);
						infoline = _tmp35_;
						_g_free0 (_tmp34_);
					}
				}
			}
			break;
		}
		case SND_CTL_ELEM_TYPE_INTEGER64:
		{
			{
				gint i;
				i = 0;
				{
					gboolean _tmp36_;
					_tmp36_ = TRUE;
					while (TRUE) {
						gboolean _tmp37_;
						gint _tmp39_;
						guint _tmp40_;
						const gchar* _tmp41_;
						snd_ctl_elem_value_t* _tmp42_;
						gint _tmp43_;
						gint64 _tmp44_ = 0LL;
						gchar* _tmp45_ = NULL;
						gchar* _tmp46_;
						gchar* _tmp47_;
						_tmp37_ = _tmp36_;
						if (!_tmp37_) {
							gint _tmp38_;
							_tmp38_ = i;
							i = _tmp38_ + 1;
						}
						_tmp36_ = FALSE;
						_tmp39_ = i;
						_tmp40_ = count;
						if (!(((guint) _tmp39_) < _tmp40_)) {
							break;
						}
						_tmp41_ = infoline;
						_tmp42_ = self->value;
						_tmp43_ = i;
						_tmp44_ = snd_ctl_elem_value_get_integer64 (_tmp42_, (guint) _tmp43_);
						_tmp45_ = g_strdup_printf ("%ld,", (glong) _tmp44_);
						_tmp46_ = _tmp45_;
						_tmp47_ = g_strconcat (_tmp41_, _tmp46_, NULL);
						_g_free0 (infoline);
						infoline = _tmp47_;
						_g_free0 (_tmp46_);
					}
				}
			}
			break;
		}
		case SND_CTL_ELEM_TYPE_ENUMERATED:
		{
			{
				gint i;
				i = 0;
				{
					gboolean _tmp48_;
					_tmp48_ = TRUE;
					while (TRUE) {
						gboolean _tmp49_;
						gint _tmp51_;
						guint _tmp52_;
						const gchar* _tmp53_;
						snd_ctl_elem_value_t* _tmp54_;
						gint _tmp55_;
						guint _tmp56_ = 0U;
						gchar* _tmp57_ = NULL;
						gchar* _tmp58_;
						gchar* _tmp59_;
						_tmp49_ = _tmp48_;
						if (!_tmp49_) {
							gint _tmp50_;
							_tmp50_ = i;
							i = _tmp50_ + 1;
						}
						_tmp48_ = FALSE;
						_tmp51_ = i;
						_tmp52_ = count;
						if (!(((guint) _tmp51_) < _tmp52_)) {
							break;
						}
						_tmp53_ = infoline;
						_tmp54_ = self->value;
						_tmp55_ = i;
						_tmp56_ = snd_ctl_elem_value_get_enumerated (_tmp54_, (guint) _tmp55_);
						_tmp57_ = g_strdup_printf ("%u,", _tmp56_);
						_tmp58_ = _tmp57_;
						_tmp59_ = g_strconcat (_tmp53_, _tmp58_, NULL);
						_g_free0 (infoline);
						infoline = _tmp59_;
						_g_free0 (_tmp58_);
					}
				}
			}
			break;
		}
		case SND_CTL_ELEM_TYPE_BYTES:
		{
			{
				gint i;
				i = 0;
				{
					gboolean _tmp60_;
					_tmp60_ = TRUE;
					while (TRUE) {
						gboolean _tmp61_;
						gint _tmp63_;
						guint _tmp64_;
						const gchar* _tmp65_;
						snd_ctl_elem_value_t* _tmp66_;
						gint _tmp67_;
						guchar _tmp68_ = '\0';
						gchar* _tmp69_ = NULL;
						gchar* _tmp70_;
						gchar* _tmp71_;
						_tmp61_ = _tmp60_;
						if (!_tmp61_) {
							gint _tmp62_;
							_tmp62_ = i;
							i = _tmp62_ + 1;
						}
						_tmp60_ = FALSE;
						_tmp63_ = i;
						_tmp64_ = count;
						if (!(((guint) _tmp63_) < _tmp64_)) {
							break;
						}
						_tmp65_ = infoline;
						_tmp66_ = self->value;
						_tmp67_ = i;
						_tmp68_ = snd_ctl_elem_value_get_byte (_tmp66_, (guint) _tmp67_);
						_tmp69_ = g_strdup_printf ("%2.2x,", (guint) _tmp68_);
						_tmp70_ = _tmp69_;
						_tmp71_ = g_strconcat (_tmp65_, _tmp70_, NULL);
						_g_free0 (infoline);
						infoline = _tmp71_;
						_g_free0 (_tmp70_);
					}
				}
			}
			break;
		}
		case SND_CTL_ELEM_TYPE_IEC958:
		{
			snd_aes_iec958_t _tmp72_ = {0};
			snd_aes_iec958_t iec958;
			snd_ctl_elem_value_t* _tmp73_;
			snd_aes_iec958_t _tmp74_;
			const gchar* _tmp75_;
			gchar* _tmp76_;
			iec958 = _tmp72_;
			_tmp73_ = self->value;
			_tmp74_ = iec958;
			snd_ctl_elem_value_get_iec958 (_tmp73_, &_tmp74_);
			_tmp75_ = infoline;
			_tmp76_ = g_strconcat (_tmp75_, "<IEC958>", NULL);
			_g_free0 (infoline);
			infoline = _tmp76_;
			 (&iec958);
			break;
		}
		default:
		{
			{
				gint i;
				i = 0;
				{
					gboolean _tmp77_;
					_tmp77_ = TRUE;
					while (TRUE) {
						gboolean _tmp78_;
						gint _tmp80_;
						guint _tmp81_;
						const gchar* _tmp82_;
						gchar* _tmp83_;
						_tmp78_ = _tmp77_;
						if (!_tmp78_) {
							gint _tmp79_;
							_tmp79_ = i;
							i = _tmp79_ + 1;
						}
						_tmp77_ = FALSE;
						_tmp80_ = i;
						_tmp81_ = count;
						if (!(((guint) _tmp80_) < _tmp81_)) {
							break;
						}
						_tmp82_ = infoline;
						_tmp83_ = g_strconcat (_tmp82_, "<unknown>,", NULL);
						_g_free0 (infoline);
						infoline = _tmp83_;
					}
				}
			}
			break;
		}
	}
	_tmp85_ = infoline;
	_tmp86_ = infoline;
	_tmp87_ = strlen (_tmp86_);
	_tmp88_ = _tmp87_;
	_tmp89_ = string_get (_tmp85_, (glong) (_tmp88_ - 1));
	if (_tmp89_ == ',') {
		const gchar* _tmp90_;
		const gchar* _tmp91_;
		gint _tmp92_;
		gint _tmp93_;
		gchar* _tmp94_ = NULL;
		_tmp90_ = infoline;
		_tmp91_ = infoline;
		_tmp92_ = strlen (_tmp91_);
		_tmp93_ = _tmp92_;
		_tmp94_ = string_substring (_tmp90_, (glong) 0, (glong) (_tmp93_ - 1));
		_g_free0 (_tmp84_);
		_tmp84_ = _tmp94_;
	} else {
		const gchar* _tmp95_;
		gchar* _tmp96_;
		_tmp95_ = infoline;
		_tmp96_ = g_strdup (_tmp95_);
		_g_free0 (_tmp84_);
		_tmp84_ = _tmp96_;
	}
	result = _tmp84_;
	_g_free0 (infoline);
	return result;
}


guint fso_device_mixer_control_get_volume (FsoDeviceMixerControl* self) {
	g_return_val_if_fail (self != NULL, 0U);
	g_assert_not_reached ();
}


void fso_device_mixer_control_set_volume (FsoDeviceMixerControl* self, guint value) {
	g_return_if_fail (self != NULL);
	g_assert_not_reached ();
}


static void fso_device_value_mixer_control_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void fso_device_value_mixer_control_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		fso_device_mixer_control_unref (value->data[0].v_pointer);
	}
}


static void fso_device_value_mixer_control_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = fso_device_mixer_control_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer fso_device_value_mixer_control_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* fso_device_value_mixer_control_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		FsoDeviceMixerControl* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = fso_device_mixer_control_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* fso_device_value_mixer_control_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	FsoDeviceMixerControl** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = fso_device_mixer_control_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* fso_device_param_spec_mixer_control (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	FsoDeviceParamSpecMixerControl* spec;
	g_return_val_if_fail (g_type_is_a (object_type, FSO_DEVICE_TYPE_MIXER_CONTROL), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer fso_device_value_get_mixer_control (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FSO_DEVICE_TYPE_MIXER_CONTROL), NULL);
	return value->data[0].v_pointer;
}


void fso_device_value_set_mixer_control (GValue* value, gpointer v_object) {
	FsoDeviceMixerControl* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FSO_DEVICE_TYPE_MIXER_CONTROL));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FSO_DEVICE_TYPE_MIXER_CONTROL));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		fso_device_mixer_control_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		fso_device_mixer_control_unref (old);
	}
}


void fso_device_value_take_mixer_control (GValue* value, gpointer v_object) {
	FsoDeviceMixerControl* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FSO_DEVICE_TYPE_MIXER_CONTROL));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FSO_DEVICE_TYPE_MIXER_CONTROL));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		fso_device_mixer_control_unref (old);
	}
}


static void fso_device_mixer_control_class_init (FsoDeviceMixerControlClass * klass) {
	fso_device_mixer_control_parent_class = g_type_class_peek_parent (klass);
	FSO_DEVICE_MIXER_CONTROL_CLASS (klass)->finalize = fso_device_mixer_control_finalize;
}


static void fso_device_mixer_control_instance_init (FsoDeviceMixerControl * self) {
	self->ref_count = 1;
}


static void fso_device_mixer_control_finalize (FsoDeviceMixerControl* obj) {
	FsoDeviceMixerControl * self;
	self = FSO_DEVICE_MIXER_CONTROL (obj);
	_snd_ctl_elem_id_free0 (self->eid);
	_snd_ctl_elem_info_free0 (self->info);
	_snd_ctl_elem_value_free0 (self->value);
}


/**
 * @class FsoDevice.MixerControl
 **/
GType fso_device_mixer_control_get_type (void) {
	static volatile gsize fso_device_mixer_control_type_id__volatile = 0;
	if (g_once_init_enter (&fso_device_mixer_control_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { fso_device_value_mixer_control_init, fso_device_value_mixer_control_free_value, fso_device_value_mixer_control_copy_value, fso_device_value_mixer_control_peek_pointer, "p", fso_device_value_mixer_control_collect_value, "p", fso_device_value_mixer_control_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (FsoDeviceMixerControlClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fso_device_mixer_control_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FsoDeviceMixerControl), 0, (GInstanceInitFunc) fso_device_mixer_control_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType fso_device_mixer_control_type_id;
		fso_device_mixer_control_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FsoDeviceMixerControl", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&fso_device_mixer_control_type_id__volatile, fso_device_mixer_control_type_id);
	}
	return fso_device_mixer_control_type_id__volatile;
}


gpointer fso_device_mixer_control_ref (gpointer instance) {
	FsoDeviceMixerControl* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void fso_device_mixer_control_unref (gpointer instance) {
	FsoDeviceMixerControl* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		FSO_DEVICE_MIXER_CONTROL_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



