/* proximity.c generated by valac 0.14.2, the Vala compiler
 * generated from proximity.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Michael 'Mickey' Lauer <mlauer@vanille-media.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <fsobasics.h>
#include <freesmartphone.h>
#include <fsoframework.h>
#include <fcntl.h>
#include <sys/types.h>
#include <errno.h>
#include <linux/input.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <fsoresource.h>


#define PALM_PRE_TYPE_PROXIMITY (palm_pre_proximity_get_type ())
#define PALM_PRE_PROXIMITY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PALM_PRE_TYPE_PROXIMITY, PalmPreProximity))
#define PALM_PRE_PROXIMITY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PALM_PRE_TYPE_PROXIMITY, PalmPreProximityClass))
#define PALM_PRE_IS_PROXIMITY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PALM_PRE_TYPE_PROXIMITY))
#define PALM_PRE_IS_PROXIMITY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PALM_PRE_TYPE_PROXIMITY))
#define PALM_PRE_PROXIMITY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PALM_PRE_TYPE_PROXIMITY, PalmPreProximityClass))

typedef struct _PalmPreProximity PalmPreProximity;
typedef struct _PalmPreProximityClass PalmPreProximityClass;
typedef struct _PalmPreProximityPrivate PalmPreProximityPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _PalmPreProximityGetProximityData PalmPreProximityGetProximityData;
typedef struct _PalmPreProximityGetPowerData PalmPreProximityGetPowerData;
typedef struct _PalmPreProximitySetPowerData PalmPreProximitySetPowerData;

#define PALM_PRE_TYPE_PROXIMITY_RESOURCE (palm_pre_proximity_resource_get_type ())
#define PALM_PRE_PROXIMITY_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PALM_PRE_TYPE_PROXIMITY_RESOURCE, PalmPreProximityResource))
#define PALM_PRE_PROXIMITY_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PALM_PRE_TYPE_PROXIMITY_RESOURCE, PalmPreProximityResourceClass))
#define PALM_PRE_IS_PROXIMITY_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PALM_PRE_TYPE_PROXIMITY_RESOURCE))
#define PALM_PRE_IS_PROXIMITY_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PALM_PRE_TYPE_PROXIMITY_RESOURCE))
#define PALM_PRE_PROXIMITY_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PALM_PRE_TYPE_PROXIMITY_RESOURCE, PalmPreProximityResourceClass))

typedef struct _PalmPreProximityResource PalmPreProximityResource;
typedef struct _PalmPreProximityResourceClass PalmPreProximityResourceClass;
typedef struct _PalmPreProximityResourcePrivate PalmPreProximityResourcePrivate;
typedef struct _palm_pre_proximity_resource_enableResourceData palm_pre_proximity_resource_enableResourceData;
typedef struct _palm_pre_proximity_resource_disableResourceData palm_pre_proximity_resource_disableResourceData;
typedef struct _palm_pre_proximity_resource_suspendResourceData palm_pre_proximity_resource_suspendResourceData;
typedef struct _palm_pre_proximity_resource_resumeResourceData palm_pre_proximity_resource_resumeResourceData;

struct _PalmPreProximity {
	FsoFrameworkAbstractObject parent_instance;
	PalmPreProximityPrivate * priv;
};

struct _PalmPreProximityClass {
	FsoFrameworkAbstractObjectClass parent_class;
};

struct _PalmPreProximityPrivate {
	FsoFrameworkSubsystem* subsystem;
	gchar* sysfsnode;
	gchar* powernode;
	gint maxvalue;
	gint minvalue;
	glong start_timestamp;
	gint _current_proximity;
	gint _value_timestamp;
	FsoFrameworkAsyncReactorChannel* input;
};

struct _PalmPreProximityGetProximityData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	PalmPreProximity* self;
	gint proximity;
	gint timestamp;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
};

struct _PalmPreProximityGetPowerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	PalmPreProximity* self;
	gboolean result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* contents;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gboolean _tmp9_;
};

struct _PalmPreProximitySetPowerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	PalmPreProximity* self;
	gboolean on;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* contents;
	const gchar* _tmp4_;
};

struct _PalmPreProximityResource {
	FsoFrameworkAbstractDBusResource parent_instance;
	PalmPreProximityResourcePrivate * priv;
};

struct _PalmPreProximityResourceClass {
	FsoFrameworkAbstractDBusResourceClass parent_class;
};

struct _PalmPreProximityResourcePrivate {
	gboolean on;
	PalmPreProximity* _instance;
};

struct _palm_pre_proximity_resource_enableResourceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	PalmPreProximityResource* self;
	gboolean _tmp0_;
	PalmPreProximity* _tmp1_;
	GError * _inner_error_;
};

struct _palm_pre_proximity_resource_disableResourceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	PalmPreProximityResource* self;
	gboolean _tmp0_;
	PalmPreProximity* _tmp1_;
	GError * _inner_error_;
};

struct _palm_pre_proximity_resource_suspendResourceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	PalmPreProximityResource* self;
};

struct _palm_pre_proximity_resource_resumeResourceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	PalmPreProximityResource* self;
};


static gpointer palm_pre_proximity_parent_class = NULL;
extern gchar* palm_pre_devfs_root;
static FreeSmartphoneDeviceProximityIface* palm_pre_proximity_free_smartphone_device_proximity_parent_iface = NULL;
static FreeSmartphoneDevicePowerControlIface* palm_pre_proximity_free_smartphone_device_power_control_parent_iface = NULL;
static GType palm_pre_proximity_type_id = 0;
static gpointer palm_pre_proximity_resource_parent_class = NULL;
static GType palm_pre_proximity_resource_type_id = 0;

#define PALM_PRE_DEFAULT_INPUT_NODE "input/event3"
#define PALM_PRE_NEAR 0
#define PALM_PRE_FAR 100
GType palm_pre_proximity_get_type (void) G_GNUC_CONST;
GType palm_pre_proximity_register_type (GTypeModule * module);
#define PALM_PRE_PROXIMITY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), PALM_PRE_TYPE_PROXIMITY, PalmPreProximityPrivate))
enum  {
	PALM_PRE_PROXIMITY_DUMMY_PROPERTY
};
PalmPreProximity* palm_pre_proximity_new (FsoFrameworkSubsystem* subsystem, const gchar* sysfsnode);
PalmPreProximity* palm_pre_proximity_construct (GType object_type, FsoFrameworkSubsystem* subsystem, const gchar* sysfsnode);
static void palm_pre_proximity_onInputEvent (PalmPreProximity* self, void* data, gssize length);
static void _palm_pre_proximity_onInputEvent_fso_framework_async_reactor_channel_action_func (void* data, gssize length, gpointer self);
static gchar* palm_pre_proximity_real_repr (FsoFrameworkAbstractObject* base);
static gint _palm_pre_proximity_valueToPercent (PalmPreProximity* self, gint value);
static void palm_pre_proximity_set_current_proximity (PalmPreProximity* self, gint value);
static void palm_pre_proximity_real_get_proximity_data_free (gpointer _data);
static void palm_pre_proximity_real_get_proximity (FreeSmartphoneDeviceProximity* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean palm_pre_proximity_real_get_proximity_co (PalmPreProximityGetProximityData* _data_);
static gint palm_pre_proximity_get_current_proximity (PalmPreProximity* self);
static void palm_pre_proximity_real_get_power_data_free (gpointer _data);
static void palm_pre_proximity_real_get_power (FreeSmartphoneDevicePowerControl* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean palm_pre_proximity_real_get_power_co (PalmPreProximityGetPowerData* _data_);
static void palm_pre_proximity_real_set_power_data_free (gpointer _data);
static void palm_pre_proximity_real_set_power (FreeSmartphoneDevicePowerControl* base, gboolean on, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean palm_pre_proximity_real_set_power_co (PalmPreProximitySetPowerData* _data_);
static void palm_pre_proximity_finalize (GObject* obj);
static void _vala_palm_pre_proximity_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_palm_pre_proximity_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType palm_pre_proximity_resource_get_type (void) G_GNUC_CONST;
GType palm_pre_proximity_resource_register_type (GTypeModule * module);
#define PALM_PRE_PROXIMITY_RESOURCE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), PALM_PRE_TYPE_PROXIMITY_RESOURCE, PalmPreProximityResourcePrivate))
enum  {
	PALM_PRE_PROXIMITY_RESOURCE_DUMMY_PROPERTY
};
PalmPreProximityResource* palm_pre_proximity_resource_new (FsoFrameworkSubsystem* subsystem, PalmPreProximity* instance);
PalmPreProximityResource* palm_pre_proximity_resource_construct (GType object_type, FsoFrameworkSubsystem* subsystem, PalmPreProximity* instance);
static void palm_pre_proximity_resource_real_enableResource_data_free (gpointer _data);
static void palm_pre_proximity_resource_real_enableResource (FsoFrameworkAbstractDBusResource* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean palm_pre_proximity_resource_real_enableResource_co (palm_pre_proximity_resource_enableResourceData* _data_);
static void palm_pre_proximity_resource_enableResource_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void palm_pre_proximity_resource_real_disableResource_data_free (gpointer _data);
static void palm_pre_proximity_resource_real_disableResource (FsoFrameworkAbstractDBusResource* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean palm_pre_proximity_resource_real_disableResource_co (palm_pre_proximity_resource_disableResourceData* _data_);
static void palm_pre_proximity_resource_disableResource_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void palm_pre_proximity_resource_real_suspendResource_data_free (gpointer _data);
static void palm_pre_proximity_resource_real_suspendResource (FsoFrameworkAbstractDBusResource* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean palm_pre_proximity_resource_real_suspendResource_co (palm_pre_proximity_resource_suspendResourceData* _data_);
static void palm_pre_proximity_resource_real_resumeResource_data_free (gpointer _data);
static void palm_pre_proximity_resource_real_resumeResource (FsoFrameworkAbstractDBusResource* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean palm_pre_proximity_resource_real_resumeResource_co (palm_pre_proximity_resource_resumeResourceData* _data_);
static void palm_pre_proximity_resource_finalize (GObject* obj);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void _palm_pre_proximity_onInputEvent_fso_framework_async_reactor_channel_action_func (void* data, gssize length, gpointer self) {
	palm_pre_proximity_onInputEvent (self, data, length);
}


PalmPreProximity* palm_pre_proximity_construct (GType object_type, FsoFrameworkSubsystem* subsystem, const gchar* sysfsnode) {
	PalmPreProximity * self = NULL;
	FsoFrameworkSubsystem* _tmp0_;
	FsoFrameworkSubsystem* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	gint _tmp16_ = 0;
	gint _tmp17_;
	gint fd;
	gint _tmp18_;
	gint _tmp28_;
	FsoFrameworkAsyncReactorChannel* _tmp29_;
	FsoFrameworkSubsystem* _tmp30_;
	FsoFrameworkSubsystem* _tmp31_;
	GTimeVal tv = {0};
	GTimeVal _tmp32_;
	glong _tmp33_;
	FsoFrameworkLogger* _tmp34_;
	g_return_val_if_fail (subsystem != NULL, NULL);
	g_return_val_if_fail (sysfsnode != NULL, NULL);
	self = (PalmPreProximity*) fso_framework_abstract_object_construct (object_type);
	self->priv->minvalue = PALM_PRE_FAR;
	self->priv->maxvalue = PALM_PRE_NEAR;
	_tmp0_ = subsystem;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->subsystem);
	self->priv->subsystem = _tmp1_;
	_tmp2_ = sysfsnode;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->sysfsnode);
	self->priv->sysfsnode = _tmp3_;
	_tmp4_ = sysfsnode;
	_tmp5_ = g_strconcat (_tmp4_, "/enable_detection", NULL);
	_g_free0 (self->priv->powernode);
	self->priv->powernode = _tmp5_;
	_tmp6_ = self->priv->powernode;
	_tmp7_ = fso_framework_file_handling_isPresent (_tmp6_);
	if (!_tmp7_) {
		FsoFrameworkLogger* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		_tmp8_ = ((FsoFrameworkAbstractObject*) self)->logger;
		_tmp9_ = self->priv->powernode;
		_tmp10_ = string_to_string (_tmp9_);
		_tmp11_ = g_strconcat ("Sysfs class is damaged, missing ", _tmp10_, "; skipping.", NULL);
		_tmp12_ = _tmp11_;
		fso_framework_logger_error (_tmp8_, _tmp12_);
		_g_free0 (_tmp12_);
		return self;
	}
	_tmp13_ = palm_pre_devfs_root;
	_tmp14_ = g_build_filename (_tmp13_, PALM_PRE_DEFAULT_INPUT_NODE, NULL);
	_tmp15_ = _tmp14_;
	_tmp16_ = open (_tmp15_, O_RDONLY, (mode_t) 0);
	_tmp17_ = _tmp16_;
	_g_free0 (_tmp15_);
	fd = _tmp17_;
	_tmp18_ = fd;
	if (_tmp18_ == (-1)) {
		FsoFrameworkLogger* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		gint _tmp23_;
		const gchar* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_;
		_tmp19_ = ((FsoFrameworkAbstractObject*) self)->logger;
		_tmp20_ = palm_pre_devfs_root;
		_tmp21_ = string_to_string (_tmp20_);
		_tmp22_ = string_to_string (PALM_PRE_DEFAULT_INPUT_NODE);
		_tmp23_ = errno;
		_tmp24_ = strerror (_tmp23_);
		_tmp25_ = string_to_string (_tmp24_);
		_tmp26_ = g_strconcat ("Can't open ", _tmp21_, "/", _tmp22_, ": ", _tmp25_, NULL);
		_tmp27_ = _tmp26_;
		fso_framework_logger_error (_tmp19_, _tmp27_);
		_g_free0 (_tmp27_);
		return self;
	}
	_tmp28_ = fd;
	_tmp29_ = fso_framework_async_reactor_channel_new (_tmp28_, _palm_pre_proximity_onInputEvent_fso_framework_async_reactor_channel_action_func, g_object_ref (self), g_object_unref, (gsize) sizeof (struct input_event));
	_g_object_unref0 (self->priv->input);
	self->priv->input = _tmp29_;
	_tmp30_ = subsystem;
	fso_framework_subsystem_registerObjectForService (_tmp30_, FREE_SMARTPHONE_DEVICE_TYPE_PROXIMITY, (GBoxedCopyFunc) g_object_ref, g_object_unref, FSO_FRAMEWORK_DEVICE_ServiceDBusName, FSO_FRAMEWORK_DEVICE_ProximityServicePath, (FreeSmartphoneDeviceProximity*) self);
	_tmp31_ = subsystem;
	fso_framework_subsystem_registerObjectForService (_tmp31_, FREE_SMARTPHONE_DEVICE_TYPE_POWER_CONTROL, (GBoxedCopyFunc) g_object_ref, g_object_unref, FSO_FRAMEWORK_DEVICE_ServiceDBusName, FSO_FRAMEWORK_DEVICE_ProximityServicePath, (FreeSmartphoneDevicePowerControl*) self);
	g_get_current_time (&tv);
	g_get_current_time (&tv);
	_tmp32_ = tv;
	_tmp33_ = _tmp32_.tv_sec;
	self->priv->start_timestamp = _tmp33_;
	free_smartphone_device_power_control_set_power ((FreeSmartphoneDevicePowerControl*) self, FALSE, NULL, NULL);
	_tmp34_ = ((FsoFrameworkAbstractObject*) self)->logger;
	fso_framework_logger_info (_tmp34_, "Created");
	return self;
}


PalmPreProximity* palm_pre_proximity_new (FsoFrameworkSubsystem* subsystem, const gchar* sysfsnode) {
	return palm_pre_proximity_construct (PALM_PRE_TYPE_PROXIMITY, subsystem, sysfsnode);
}


static gchar* palm_pre_proximity_real_repr (FsoFrameworkAbstractObject* base) {
	PalmPreProximity * self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	self = (PalmPreProximity*) base;
	_tmp0_ = self->priv->sysfsnode;
	_tmp1_ = string_to_string (_tmp0_);
	_tmp2_ = g_strconcat ("<", _tmp1_, ">", NULL);
	result = _tmp2_;
	return result;
}


static void palm_pre_proximity_onInputEvent (PalmPreProximity* self, void* data, gssize length) {
	void* _tmp0_;
	struct input_event* event;
	gboolean _tmp1_ = FALSE;
	struct input_event* _tmp2_;
	guint16 _tmp3_;
	gboolean _tmp6_;
	FsoFrameworkLogger* _tmp23_;
	struct input_event* _tmp24_;
	gint32 _tmp25_;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_;
	gboolean _tmp30_ = FALSE;
	struct input_event* _tmp31_;
	gint32 _tmp32_;
	gint _tmp33_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = data;
	event = (struct input_event*) _tmp0_;
	_tmp2_ = event;
	_tmp3_ = (*_tmp2_).type;
	if (((gint) _tmp3_) != 4) {
		_tmp1_ = TRUE;
	} else {
		struct input_event* _tmp4_;
		guint16 _tmp5_;
		_tmp4_ = event;
		_tmp5_ = (*_tmp4_).code;
		_tmp1_ = ((gint) _tmp5_) != 1;
	}
	_tmp6_ = _tmp1_;
	if (_tmp6_) {
		FsoFrameworkLogger* _tmp7_;
		struct input_event* _tmp8_;
		guint16 _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		struct input_event* _tmp12_;
		guint16 _tmp13_;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		struct input_event* _tmp16_;
		gint32 _tmp17_;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_;
		gboolean _tmp22_ = FALSE;
		_tmp7_ = ((FsoFrameworkAbstractObject*) self)->logger;
		_tmp8_ = event;
		_tmp9_ = (*_tmp8_).type;
		_tmp10_ = g_strdup_printf ("%hu", _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = event;
		_tmp13_ = (*_tmp12_).code;
		_tmp14_ = g_strdup_printf ("%hu", _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = event;
		_tmp17_ = (*_tmp16_).value;
		_tmp18_ = g_strdup_printf ("%i", _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strconcat ("Unknown event w/ type ", _tmp11_, ", code ", _tmp15_, " and value ", _tmp19_, "; ignoring", NULL);
		_tmp21_ = _tmp20_;
		_tmp22_ = fso_framework_logger_debug (_tmp7_, _tmp21_);
		g_assert (_tmp22_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp19_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp11_);
		return;
	}
	_tmp23_ = ((FsoFrameworkAbstractObject*) self)->logger;
	_tmp24_ = event;
	_tmp25_ = (*_tmp24_).value;
	_tmp26_ = g_strdup_printf ("%i", _tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = g_strconcat ("Using Proximity event with value ", _tmp27_, NULL);
	_tmp29_ = _tmp28_;
	_tmp30_ = fso_framework_logger_debug (_tmp23_, _tmp29_);
	g_assert (_tmp30_);
	_g_free0 (_tmp29_);
	_g_free0 (_tmp27_);
	_tmp31_ = event;
	_tmp32_ = (*_tmp31_).value;
	_tmp33_ = _palm_pre_proximity_valueToPercent (self, (gint) _tmp32_);
	palm_pre_proximity_set_current_proximity (self, _tmp33_);
}


static gint _palm_pre_proximity_valueToPercent (PalmPreProximity* self, gint value) {
	gint result = 0;
	gint _tmp0_;
	gdouble v;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = value;
	v = (gdouble) _tmp0_;
	_tmp1_ = self->priv->maxvalue;
	_tmp2_ = self->priv->minvalue;
	_tmp3_ = self->priv->minvalue;
	result = (gint) ((100.0 / (_tmp1_ - _tmp2_)) * (v - _tmp3_));
	return result;
}


static void palm_pre_proximity_real_get_proximity_data_free (gpointer _data) {
	PalmPreProximityGetProximityData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (PalmPreProximityGetProximityData, _data_);
}


static void palm_pre_proximity_real_get_proximity (FreeSmartphoneDeviceProximity* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	PalmPreProximity * self;
	PalmPreProximityGetProximityData* _data_;
	PalmPreProximity* _tmp0_;
	self = (PalmPreProximity*) base;
	_data_ = g_slice_new0 (PalmPreProximityGetProximityData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, palm_pre_proximity_real_get_proximity);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, palm_pre_proximity_real_get_proximity_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	palm_pre_proximity_real_get_proximity_co (_data_);
}


static void palm_pre_proximity_real_get_proximity_finish (FreeSmartphoneDeviceProximity* base, GAsyncResult* _res_, gint* proximity, gint* timestamp, GError** error) {
	PalmPreProximityGetProximityData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	if (proximity) {
		*proximity = _data_->proximity;
	}
	if (timestamp) {
		*timestamp = _data_->timestamp;
	}
}


static gboolean palm_pre_proximity_real_get_proximity_co (PalmPreProximityGetProximityData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = palm_pre_proximity_get_current_proximity (_data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->proximity = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->self->priv->_value_timestamp;
	_data_->timestamp = _data_->_tmp2_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void palm_pre_proximity_real_get_power_data_free (gpointer _data) {
	PalmPreProximityGetPowerData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (PalmPreProximityGetPowerData, _data_);
}


static void palm_pre_proximity_real_get_power (FreeSmartphoneDevicePowerControl* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	PalmPreProximity * self;
	PalmPreProximityGetPowerData* _data_;
	PalmPreProximity* _tmp0_;
	self = (PalmPreProximity*) base;
	_data_ = g_slice_new0 (PalmPreProximityGetPowerData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, palm_pre_proximity_real_get_power);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, palm_pre_proximity_real_get_power_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	palm_pre_proximity_real_get_power_co (_data_);
}


static gboolean palm_pre_proximity_real_get_power_finish (FreeSmartphoneDevicePowerControl* base, GAsyncResult* _res_, GError** error) {
	gboolean result;
	PalmPreProximityGetPowerData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return FALSE;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gboolean palm_pre_proximity_real_get_power_co (PalmPreProximityGetPowerData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->powernode;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = fso_framework_file_handling_read (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = _data_->_tmp2_;
	if (_data_->_tmp3_ == NULL) {
		_data_->_tmp4_ = g_strdup ("");
		_g_free0 (_data_->_tmp2_);
		_data_->_tmp2_ = _data_->_tmp4_;
	}
	_data_->_tmp5_ = _data_->_tmp2_;
	_data_->_tmp6_ = g_strdup (_data_->_tmp5_);
	_data_->contents = _data_->_tmp6_;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = string_strip (_data_->contents);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = g_strcmp0 (_data_->_tmp8_, "1") == 0;
	_g_free0 (_data_->_tmp8_);
	_data_->result = _data_->_tmp9_;
	_g_free0 (_data_->contents);
	_g_free0 (_data_->_tmp2_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_free0 (_data_->contents);
	_g_free0 (_data_->_tmp2_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void palm_pre_proximity_real_set_power_data_free (gpointer _data) {
	PalmPreProximitySetPowerData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (PalmPreProximitySetPowerData, _data_);
}


static void palm_pre_proximity_real_set_power (FreeSmartphoneDevicePowerControl* base, gboolean on, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	PalmPreProximity * self;
	PalmPreProximitySetPowerData* _data_;
	PalmPreProximity* _tmp0_;
	gboolean _tmp1_;
	self = (PalmPreProximity*) base;
	_data_ = g_slice_new0 (PalmPreProximitySetPowerData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, palm_pre_proximity_real_set_power);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, palm_pre_proximity_real_set_power_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = on;
	_data_->on = _tmp1_;
	palm_pre_proximity_real_set_power_co (_data_);
}


static void palm_pre_proximity_real_set_power_finish (FreeSmartphoneDevicePowerControl* base, GAsyncResult* _res_, GError** error) {
	PalmPreProximitySetPowerData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean palm_pre_proximity_real_set_power_co (PalmPreProximitySetPowerData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = _data_->on;
	if (_data_->_tmp1_) {
		_data_->_tmp0_ = "1";
	} else {
		_data_->_tmp0_ = "0";
	}
	_data_->_tmp2_ = _data_->_tmp0_;
	_data_->_tmp3_ = g_strdup (_data_->_tmp2_);
	_data_->contents = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->self->priv->powernode;
	fso_framework_file_handling_write (_data_->contents, _data_->_tmp4_, FALSE);
	_g_free0 (_data_->contents);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gint palm_pre_proximity_get_current_proximity (PalmPreProximity* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_current_proximity;
	result = _tmp0_;
	return result;
}


static void palm_pre_proximity_set_current_proximity (PalmPreProximity* self, gint value) {
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = self->priv->_current_proximity;
	if (_tmp0_ != _tmp1_) {
		gint _tmp2_;
		gint _tmp3_;
		GTimeVal tv = {0};
		GTimeVal _tmp4_;
		glong _tmp5_;
		glong _tmp6_;
		_tmp2_ = value;
		self->priv->_current_proximity = _tmp2_;
		_tmp3_ = value;
		g_signal_emit_by_name ((FreeSmartphoneDeviceProximity*) self, "proximity", _tmp3_);
		g_get_current_time (&tv);
		g_get_current_time (&tv);
		_tmp4_ = tv;
		_tmp5_ = _tmp4_.tv_sec;
		_tmp6_ = self->priv->start_timestamp;
		self->priv->_value_timestamp = (gint) (_tmp5_ - _tmp6_);
	}
}


static void palm_pre_proximity_class_init (PalmPreProximityClass * klass) {
	palm_pre_proximity_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PalmPreProximityPrivate));
	FSO_FRAMEWORK_ABSTRACT_OBJECT_CLASS (klass)->repr = palm_pre_proximity_real_repr;
	G_OBJECT_CLASS (klass)->get_property = _vala_palm_pre_proximity_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_palm_pre_proximity_set_property;
	G_OBJECT_CLASS (klass)->finalize = palm_pre_proximity_finalize;
}


static void palm_pre_proximity_free_smartphone_device_proximity_interface_init (FreeSmartphoneDeviceProximityIface * iface) {
	palm_pre_proximity_free_smartphone_device_proximity_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_proximity = (void (*)(FreeSmartphoneDeviceProximity*, gint*, gint*, GError**)) palm_pre_proximity_real_get_proximity;
	iface->get_proximity_finish = palm_pre_proximity_real_get_proximity_finish;
}


static void palm_pre_proximity_free_smartphone_device_power_control_interface_init (FreeSmartphoneDevicePowerControlIface * iface) {
	palm_pre_proximity_free_smartphone_device_power_control_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_power = (gboolean (*)(FreeSmartphoneDevicePowerControl*, GError**)) palm_pre_proximity_real_get_power;
	iface->get_power_finish = palm_pre_proximity_real_get_power_finish;
	iface->set_power = (void (*)(FreeSmartphoneDevicePowerControl*, gboolean, GError**)) palm_pre_proximity_real_set_power;
	iface->set_power_finish = palm_pre_proximity_real_set_power_finish;
}


static void palm_pre_proximity_instance_init (PalmPreProximity * self) {
	self->priv = PALM_PRE_PROXIMITY_GET_PRIVATE (self);
	self->priv->_current_proximity = -1;
	self->priv->_value_timestamp = -1;
}


static void palm_pre_proximity_finalize (GObject* obj) {
	PalmPreProximity * self;
	self = PALM_PRE_PROXIMITY (obj);
	_g_object_unref0 (self->priv->subsystem);
	_g_free0 (self->priv->sysfsnode);
	_g_free0 (self->priv->powernode);
	_g_object_unref0 (self->priv->input);
	G_OBJECT_CLASS (palm_pre_proximity_parent_class)->finalize (obj);
}


GType palm_pre_proximity_get_type (void) {
	return palm_pre_proximity_type_id;
}


GType palm_pre_proximity_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (PalmPreProximityClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) palm_pre_proximity_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PalmPreProximity), 0, (GInstanceInitFunc) palm_pre_proximity_instance_init, NULL };
	static const GInterfaceInfo free_smartphone_device_proximity_info = { (GInterfaceInitFunc) palm_pre_proximity_free_smartphone_device_proximity_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo free_smartphone_device_power_control_info = { (GInterfaceInitFunc) palm_pre_proximity_free_smartphone_device_power_control_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	palm_pre_proximity_type_id = g_type_module_register_type (module, FSO_FRAMEWORK_TYPE_ABSTRACT_OBJECT, "PalmPreProximity", &g_define_type_info, 0);
	g_type_module_add_interface (module, palm_pre_proximity_type_id, FREE_SMARTPHONE_DEVICE_TYPE_PROXIMITY, &free_smartphone_device_proximity_info);
	g_type_module_add_interface (module, palm_pre_proximity_type_id, FREE_SMARTPHONE_DEVICE_TYPE_POWER_CONTROL, &free_smartphone_device_power_control_info);
	return palm_pre_proximity_type_id;
}


static void _vala_palm_pre_proximity_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	PalmPreProximity * self;
	self = PALM_PRE_PROXIMITY (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_palm_pre_proximity_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	PalmPreProximity * self;
	self = PALM_PRE_PROXIMITY (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


PalmPreProximityResource* palm_pre_proximity_resource_construct (GType object_type, FsoFrameworkSubsystem* subsystem, PalmPreProximity* instance) {
	PalmPreProximityResource * self = NULL;
	FsoFrameworkSubsystem* _tmp0_;
	PalmPreProximity* _tmp1_;
	PalmPreProximity* _tmp2_;
	g_return_val_if_fail (subsystem != NULL, NULL);
	g_return_val_if_fail (instance != NULL, NULL);
	_tmp0_ = subsystem;
	self = (PalmPreProximityResource*) fso_framework_abstract_dbus_resource_construct (object_type, "Proximity", _tmp0_);
	_tmp1_ = instance;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->_instance);
	self->priv->_instance = _tmp2_;
	return self;
}


PalmPreProximityResource* palm_pre_proximity_resource_new (FsoFrameworkSubsystem* subsystem, PalmPreProximity* instance) {
	return palm_pre_proximity_resource_construct (PALM_PRE_TYPE_PROXIMITY_RESOURCE, subsystem, instance);
}


static void palm_pre_proximity_resource_real_enableResource_data_free (gpointer _data) {
	palm_pre_proximity_resource_enableResourceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (palm_pre_proximity_resource_enableResourceData, _data_);
}


static void palm_pre_proximity_resource_real_enableResource (FsoFrameworkAbstractDBusResource* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	PalmPreProximityResource * self;
	palm_pre_proximity_resource_enableResourceData* _data_;
	PalmPreProximityResource* _tmp0_;
	self = (PalmPreProximityResource*) base;
	_data_ = g_slice_new0 (palm_pre_proximity_resource_enableResourceData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, palm_pre_proximity_resource_real_enableResource);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, palm_pre_proximity_resource_real_enableResource_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	palm_pre_proximity_resource_real_enableResource_co (_data_);
}


static void palm_pre_proximity_resource_real_enableResource_finish (FsoFrameworkAbstractDBusResource* base, GAsyncResult* _res_, GError** error) {
	palm_pre_proximity_resource_enableResourceData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void palm_pre_proximity_resource_enableResource_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	palm_pre_proximity_resource_enableResourceData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	palm_pre_proximity_resource_real_enableResource_co (_data_);
}


static gboolean palm_pre_proximity_resource_real_enableResource_co (palm_pre_proximity_resource_enableResourceData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->on;
	if (_data_->_tmp0_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->self->priv->_instance;
	_data_->_state_ = 1;
	free_smartphone_device_power_control_set_power ((FreeSmartphoneDevicePowerControl*) _data_->_tmp1_, TRUE, palm_pre_proximity_resource_enableResource_ready, _data_);
	return FALSE;
	_state_1:
	free_smartphone_device_power_control_set_power_finish ((FreeSmartphoneDevicePowerControl*) _data_->_tmp1_, _data_->_res_, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->self->priv->on = TRUE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void palm_pre_proximity_resource_real_disableResource_data_free (gpointer _data) {
	palm_pre_proximity_resource_disableResourceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (palm_pre_proximity_resource_disableResourceData, _data_);
}


static void palm_pre_proximity_resource_real_disableResource (FsoFrameworkAbstractDBusResource* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	PalmPreProximityResource * self;
	palm_pre_proximity_resource_disableResourceData* _data_;
	PalmPreProximityResource* _tmp0_;
	self = (PalmPreProximityResource*) base;
	_data_ = g_slice_new0 (palm_pre_proximity_resource_disableResourceData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, palm_pre_proximity_resource_real_disableResource);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, palm_pre_proximity_resource_real_disableResource_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	palm_pre_proximity_resource_real_disableResource_co (_data_);
}


static void palm_pre_proximity_resource_real_disableResource_finish (FsoFrameworkAbstractDBusResource* base, GAsyncResult* _res_) {
	palm_pre_proximity_resource_disableResourceData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void palm_pre_proximity_resource_disableResource_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	palm_pre_proximity_resource_disableResourceData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	palm_pre_proximity_resource_real_disableResource_co (_data_);
}


static gboolean palm_pre_proximity_resource_real_disableResource_co (palm_pre_proximity_resource_disableResourceData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->on;
	if (!_data_->_tmp0_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->self->priv->_instance;
	_data_->_state_ = 1;
	free_smartphone_device_power_control_set_power ((FreeSmartphoneDevicePowerControl*) _data_->_tmp1_, FALSE, palm_pre_proximity_resource_disableResource_ready, _data_);
	return FALSE;
	_state_1:
	free_smartphone_device_power_control_set_power_finish ((FreeSmartphoneDevicePowerControl*) _data_->_tmp1_, _data_->_res_, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->self->priv->on = FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void palm_pre_proximity_resource_real_suspendResource_data_free (gpointer _data) {
	palm_pre_proximity_resource_suspendResourceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (palm_pre_proximity_resource_suspendResourceData, _data_);
}


static void palm_pre_proximity_resource_real_suspendResource (FsoFrameworkAbstractDBusResource* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	PalmPreProximityResource * self;
	palm_pre_proximity_resource_suspendResourceData* _data_;
	PalmPreProximityResource* _tmp0_;
	self = (PalmPreProximityResource*) base;
	_data_ = g_slice_new0 (palm_pre_proximity_resource_suspendResourceData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, palm_pre_proximity_resource_real_suspendResource);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, palm_pre_proximity_resource_real_suspendResource_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	palm_pre_proximity_resource_real_suspendResource_co (_data_);
}


static void palm_pre_proximity_resource_real_suspendResource_finish (FsoFrameworkAbstractDBusResource* base, GAsyncResult* _res_) {
	palm_pre_proximity_resource_suspendResourceData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean palm_pre_proximity_resource_real_suspendResource_co (palm_pre_proximity_resource_suspendResourceData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void palm_pre_proximity_resource_real_resumeResource_data_free (gpointer _data) {
	palm_pre_proximity_resource_resumeResourceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (palm_pre_proximity_resource_resumeResourceData, _data_);
}


static void palm_pre_proximity_resource_real_resumeResource (FsoFrameworkAbstractDBusResource* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	PalmPreProximityResource * self;
	palm_pre_proximity_resource_resumeResourceData* _data_;
	PalmPreProximityResource* _tmp0_;
	self = (PalmPreProximityResource*) base;
	_data_ = g_slice_new0 (palm_pre_proximity_resource_resumeResourceData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, palm_pre_proximity_resource_real_resumeResource);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, palm_pre_proximity_resource_real_resumeResource_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	palm_pre_proximity_resource_real_resumeResource_co (_data_);
}


static void palm_pre_proximity_resource_real_resumeResource_finish (FsoFrameworkAbstractDBusResource* base, GAsyncResult* _res_) {
	palm_pre_proximity_resource_resumeResourceData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean palm_pre_proximity_resource_real_resumeResource_co (palm_pre_proximity_resource_resumeResourceData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void palm_pre_proximity_resource_class_init (PalmPreProximityResourceClass * klass) {
	palm_pre_proximity_resource_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PalmPreProximityResourcePrivate));
	FSO_FRAMEWORK_ABSTRACT_DBUS_RESOURCE_CLASS (klass)->enableResource = palm_pre_proximity_resource_real_enableResource;
	FSO_FRAMEWORK_ABSTRACT_DBUS_RESOURCE_CLASS (klass)->enableResource_finish = palm_pre_proximity_resource_real_enableResource_finish;
	FSO_FRAMEWORK_ABSTRACT_DBUS_RESOURCE_CLASS (klass)->disableResource = palm_pre_proximity_resource_real_disableResource;
	FSO_FRAMEWORK_ABSTRACT_DBUS_RESOURCE_CLASS (klass)->disableResource_finish = palm_pre_proximity_resource_real_disableResource_finish;
	FSO_FRAMEWORK_ABSTRACT_DBUS_RESOURCE_CLASS (klass)->suspendResource = palm_pre_proximity_resource_real_suspendResource;
	FSO_FRAMEWORK_ABSTRACT_DBUS_RESOURCE_CLASS (klass)->suspendResource_finish = palm_pre_proximity_resource_real_suspendResource_finish;
	FSO_FRAMEWORK_ABSTRACT_DBUS_RESOURCE_CLASS (klass)->resumeResource = palm_pre_proximity_resource_real_resumeResource;
	FSO_FRAMEWORK_ABSTRACT_DBUS_RESOURCE_CLASS (klass)->resumeResource_finish = palm_pre_proximity_resource_real_resumeResource_finish;
	G_OBJECT_CLASS (klass)->finalize = palm_pre_proximity_resource_finalize;
}


static void palm_pre_proximity_resource_instance_init (PalmPreProximityResource * self) {
	self->priv = PALM_PRE_PROXIMITY_RESOURCE_GET_PRIVATE (self);
	self->priv->on = FALSE;
}


static void palm_pre_proximity_resource_finalize (GObject* obj) {
	PalmPreProximityResource * self;
	self = PALM_PRE_PROXIMITY_RESOURCE (obj);
	_g_object_unref0 (self->priv->_instance);
	G_OBJECT_CLASS (palm_pre_proximity_resource_parent_class)->finalize (obj);
}


/**
     * Implementation of org.freesmartphone.Resource for the Palmpre Proximity Resource
     **/
GType palm_pre_proximity_resource_get_type (void) {
	return palm_pre_proximity_resource_type_id;
}


GType palm_pre_proximity_resource_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (PalmPreProximityResourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) palm_pre_proximity_resource_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PalmPreProximityResource), 0, (GInstanceInitFunc) palm_pre_proximity_resource_instance_init, NULL };
	palm_pre_proximity_resource_type_id = g_type_module_register_type (module, FSO_FRAMEWORK_TYPE_ABSTRACT_DBUS_RESOURCE, "PalmPreProximityResource", &g_define_type_info, 0);
	return palm_pre_proximity_resource_type_id;
}



