/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: CommentDialog.cc,v 1.4 2001/10/29 07:46:21 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "CommentDialog.hh"
#include "PixmapButton.hh"

#include <gtk--.h>


CommentDialog::CommentDialog(const string& text)
{
    comment->set_point(0);
    comment->forward_delete( comment->get_length() );
    comment->insert(text);
    orig_text=text;
    choice=false;

    PixmapButton::addPixmapAndText( *button14 , "Ok"     , "OK"     );
    PixmapButton::addPixmapAndText( *button15 , "Cancel" , "Cancel" );

    button14->set_flags(GTK_CAN_FOCUS|GTK_CAN_DEFAULT);
    button15->set_flags(GTK_CAN_FOCUS|GTK_CAN_DEFAULT);
    button14->grab_default();
    button14->grab_focus();
}

string CommentDialog::run()
{
    Gtk::Main::grab_add(*this);
    Gtk::Main::run();
    Gtk::Main::grab_remove(*this);
    hide();

    if(choice) {
	return(  comment->get_chars(0,comment->get_length()) );
    } else {
	return( orig_text );
    }
}

void CommentDialog::on_ok_clicked()
{   
    choice=true;
    Gtk::Main::quit();
}

void CommentDialog::on_cancel_clicked()
{   
    choice=false;
    Gtk::Main::quit();
}
