/* 

                          Firewall Builder

                 Copyright (C) 2001 Vadim Zaliva, Vadim Kurland

  Author:  Vadim Zaliva lord@crocodile.org

  $Id: DialogFactory.cc,v 1.4 2001/12/18 22:48:29 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "DialogFactory.hh"

#include "fwbuilder/FWObject.hh"
#include "fwbuilder/CustomService.hh"
#include "fwbuilder/Firewall.hh"
#include "fwbuilder/Group.hh"
#include "fwbuilder/ObjectGroup.hh"
#include "fwbuilder/ServiceGroup.hh"
#include "fwbuilder/IntervalGroup.hh"
#include "fwbuilder/Host.hh"
#include "fwbuilder/ICMPService.hh"
#include "fwbuilder/InterfacePolicy.hh"
#include "fwbuilder/Interval.hh"
#include "fwbuilder/IPService.hh"
#include "fwbuilder/NAT.hh"
#include "fwbuilder/Network.hh"
#include "fwbuilder/Policy.hh"
#include "fwbuilder/RuleSet.hh"
#include "fwbuilder/TCPService.hh"
#include "fwbuilder/UDPService.hh"

#include "CustomServiceDialog.hh"
#include "FirewallDialog.hh"
#include "GroupDialog.hh"
#include "HostDialog.hh"
#include "ICMPServiceDialog.hh"
#include "PolicyDialog.hh"
#include "TimeDialog.hh"
#include "IPServiceDialog.hh"
#include "NATDialog.hh"
#include "NetworkDialog.hh"
#include "PolicyDialog.hh"
#include "TCPServiceDialog.hh"
#include "UDPServiceDialog.hh"
#include "FWObjectDialog.hh"

using namespace libfwbuilder;

class DefaultDialogFactory: public DialogFactory
{
    public:

    virtual DialogPlugin* create(FWObject *o)
    {
        if(CustomService::isA(o))
        {
            return( new CustomServiceDialog(o) );
        } else if(Firewall::isA(o))
        {
            return( new FirewallDialog(o) );
        } else if(Group::isA(o) || ObjectGroup::isA(o) || ServiceGroup::isA(o) || IntervalGroup::isA(o))
        {
            return( new GroupDialog(o) );
        } else if(Host::isA(o))
        {
            return( new HostDialog(o) );
        } else if(ICMPService::isA(o))
        {
            return( new ICMPServiceDialog(o) );
        } else if(InterfacePolicy::isA(o))
        {
            return( new PolicyDialog(o) );
        } else if(Interval::isA(o))
        {
            return( new TimeDialog(o) );
        } else if(IPService::isA(o))
        {
            return( new IPServiceDialog(o) );
        } else if(NAT::isA(o))
        {
            return( new NATDialog(o) );
        } else if(Network::isA(o))
        {
            return(new NetworkDialog(Network::cast(o)));
        } else if(Policy::isA(o))
        {
            return( new PolicyDialog(o) );
        } else if(RuleSet::isA(o))
        {
            return( new PolicyDialog(o) );
        } else if(TCPService::isA(o))
        {
            return( new TCPServiceDialog(o) );
        } else if(UDPService::isA(o))
        {
            return( new UDPServiceDialog(o) );
        } else if(FWObject::isA(o))
        {
            return ( new FWObjectDialog(o) );
        } else 
            return NULL;
    }
    
};


DialogFactory *DialogFactory::instance=new DefaultDialogFactory();


