/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: DialogPlugin.cc,v 1.20 2001/12/22 22:40:05 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "config.h"

#include "glademm_support.hh"

#include "DialogPlugin.hh"
#include "BuiltinDialog.hh"
#include "OptionMenuWidget.hh"
#include "IPAddressWidget.hh"

#include "helpers.hh"

#include "fwbuilder/FWObjectDatabase.hh"

#include "MessageDialog.hh"

#include "main_window.hh"

#include <ctype.h>

using namespace libfwbuilder;


DialogPlugin::DialogPlugin() : Gtk::EventBox()
{
    dialog_buttons=true;
    magic_empty_option="_MAGIC_EMPTY_OPTION_";
    /* Pass resize request to the parent */
    set_resize_mode(GTK_RESIZE_PARENT);
}

DialogPlugin::~DialogPlugin()
{
  //  cerr << "### DialogPlugin::~DialogPlugin()  \n";
}

/*
 *  The follwowing two functions are substitutions for 
 *  the corresponding methods from Gtk::Windows class
 *  So we could use glade to generate these dialogs
 */
void DialogPlugin::set_policy(gint allow_shrink, 
			      gint allow_grow, 
			      gint auto_shrink) {}

void DialogPlugin::set_title(const string& title) {}


void DialogPlugin::data_changed_flag(bool val)
{
    /*
     *   find parent - object of the BuiltinDialog class and call
     *   its data_changed_flag function
     */
    BuiltinDialog *b = (BuiltinDialog*)find_widget("BuiltinDialog",this);
    if (b!=NULL)
	b->data_changed_flag(val);
}

void DialogPlugin::saveCheckButton(FWObject *o,Gtk::CheckButton *cb, 
				   const string& name)
{
    o->setBool(name, cb->get_active());
}

void DialogPlugin::saveOptionMenu(FWObject *o,OptionMenuWidget *om, 
				  const string& name)
{
    string *str=(string*)(om->get_menu()->get_active()->get_user_data());
    assert(str!=NULL);

    if (*str==magic_empty_option)  o->remStr(name);
    else                           o->setStr(name,*str);
}

void DialogPlugin::saveEntry(FWObject *o,Gtk::Entry *en, const string& name)
{
    o->setStr(name, en->get_text());
}

void DialogPlugin::saveSpinButton(FWObject *o,Gtk::SpinButton *sb, 
				  const string& name)
{
    o->setInt(name, sb->get_value_as_int() );
}

void DialogPlugin::saveText(FWObject *o,Gtk::Text *t  , const string& name)
{
    o->setStr(name, t->get_chars(0,t->get_length()) );
}

void DialogPlugin::saveIPAddress(FWObject *o,IPAddressWidget *a  , const string& name)
{
    o->setStr(name, a->getAsString() );
}


void DialogPlugin::loadCheckButton(FWObject *o,Gtk::CheckButton *cb, 
				   const string& name)
{
    if (o->exists(name))
	cb->set_active( o->getBool(name) );
}


void DialogPlugin::loadOptionMenu (FWObject *o,OptionMenuWidget *om , 
				   const string& name)
{
    string str;
    if (o->exists(name))	str=o->getStr(name);
    else                        str=magic_empty_option;

    om->set_active_item_by_value( str );
}


void DialogPlugin::loadEntry(FWObject *o,Gtk::Entry *en, const string& name)
{
    if (o->exists(name))
	en->set_text( o->getStr(name) );
}

void DialogPlugin::loadSpinButton(FWObject *o,Gtk::SpinButton *sb, 
				  const string& name)
{
    if (o->exists(name))
	sb->set_value( o->getInt(name) );
}

void DialogPlugin::loadText(FWObject *o,Gtk::Text *t  , const string& name)
{
    t->set_point(0);
    t->forward_delete( t->get_length() );
    t->insert(o->getStr(name));
}

void DialogPlugin::loadIPAddress(FWObject *o,IPAddressWidget *a  , const string& name)
{
    a->setAddress( o->getStr(name) );
}


void DialogPlugin::loadPageOptions(FWObject *o,vector<struct DialogOption> &page_options)
{
    vector<struct DialogOption>::iterator i;
    for (i=page_options.begin(); i!=page_options.end();  ++i) {

	if (Gtk::SpinButton::isA( (*i).widget ))
	    loadSpinButton( o , dynamic_cast<Gtk::SpinButton*>( (*i).widget) , (*i).option_name );

	if (Gtk::CheckButton::isA( (*i).widget ))
	    loadCheckButton( o , dynamic_cast<Gtk::CheckButton*>( (*i).widget) , (*i).option_name );

	if (Gtk::Entry::isA( (*i).widget ))
	    loadEntry( o , dynamic_cast<Gtk::Entry*>( (*i).widget) , (*i).option_name );

	if (Gtk::Text::isA( (*i).widget ))
	    loadText( o , dynamic_cast<Gtk::Text*>( (*i).widget) , (*i).option_name );

	if (dynamic_cast<IPAddressWidget*>( (*i).widget )!=NULL)
	    loadIPAddress( o , dynamic_cast<IPAddressWidget*>( (*i).widget) , (*i).option_name );

	if (dynamic_cast<OptionMenuWidget*>( (*i).widget )!=NULL)
	    loadOptionMenu( o , dynamic_cast<OptionMenuWidget*>( (*i).widget) , (*i).option_name );
    }
}

void DialogPlugin::savePageOptions(FWObject *o,vector<struct DialogOption> &page_options)
{
    vector<struct DialogOption>::iterator i;
    for (i=page_options.begin(); i!=page_options.end();  ++i) {

	if (Gtk::SpinButton::isA( (*i).widget ))
	    saveSpinButton( o , dynamic_cast<Gtk::SpinButton*>( (*i).widget) , (*i).option_name );

	if (Gtk::CheckButton::isA( (*i).widget ))
	    saveCheckButton( o , dynamic_cast<Gtk::CheckButton*>( (*i).widget) , (*i).option_name );

	if (Gtk::Entry::isA( (*i).widget ))
	    saveEntry( o , dynamic_cast<Gtk::Entry*>( (*i).widget) , (*i).option_name );

	if (Gtk::Text::isA( (*i).widget ))
	    saveText( o , dynamic_cast<Gtk::Text*>( (*i).widget) , (*i).option_name );

	if (dynamic_cast<IPAddressWidget*>( (*i).widget )!=NULL)
	    saveIPAddress( o , dynamic_cast<IPAddressWidget*>( (*i).widget) , (*i).option_name );

	if (dynamic_cast<OptionMenuWidget*>( (*i).widget )!=NULL)
	    saveOptionMenu( o , dynamic_cast<OptionMenuWidget*>( (*i).widget) , (*i).option_name );
    }
}


/*
 * Disable menu items which make sence only for specific objects
 */
void DialogPlugin::updateMainMenu()
{
    Gtk::MenuBar *main_menubar=main_w->getMainMenuBar();
    Gtk::Widget *itm;

    itm=find_widget("duplicate",main_menubar);
    if (itm) itm->set_sensitive( ! Resources::isSystem(object) );

    itm=find_widget("copy",main_menubar);
    if (itm) itm->set_sensitive( ! Resources::isSystem(object) );

    itm=find_widget("cut",main_menubar);
    if (itm) itm->set_sensitive( ! Resources::isSystem(object) );

    itm=find_widget("paste",main_menubar);
    if (itm) itm->set_sensitive( false );

    itm=find_widget("delete",main_menubar);
    if (itm) itm->set_sensitive( ! Resources::isSystem(object) );

    itm=find_widget("where_used",main_menubar);
    if (itm) itm->set_sensitive( true );

    itm=find_widget("sort",main_menubar);
    if (itm) itm->set_sensitive( Resources::isSystem(object) );


    itm=find_widget("policy",main_menubar);
    if (itm) itm->set_sensitive(false);

    itm=find_widget("insert_top",main_menubar);
    if (itm) itm->set_sensitive(false);

    itm=find_widget("append_bottom",main_menubar);
    if (itm) itm->set_sensitive(false);

    itm=find_widget("add_after",main_menubar);
    if (itm) itm->set_sensitive(false);

    itm=find_widget("remove_current",main_menubar);
    if (itm) itm->set_sensitive(false);

    itm=find_widget("move_up",main_menubar);
    if (itm) itm->set_sensitive(false);

    itm=find_widget("move_down",main_menubar);
    if (itm) itm->set_sensitive(false);

    itm=find_widget("rules_druid",main_menubar);
    if (itm) itm->set_sensitive(true);

    itm=find_widget("compile_policy",main_menubar);
    if (itm) itm->set_sensitive(false);

    itm=find_widget("install_policy",main_menubar);
    if (itm) itm->set_sensitive( false );
}
