/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: DialogPlugin.hh,v 1.12 2001/12/22 22:40:05 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef _DialogPlugin_HH
#  define _DialogPlugin_HH

#include <vector>
#include <map>
#include <gtk--.h>

#include "config.h"

#include "fwbuilder/FWObject.hh"

class OptionMenuWidget;
class BuiltinDialog;
class IPAddressWidget;

class DialogPlugin : public Gtk::EventBox
{

    friend class BuiltinDialog;


protected:

    libfwbuilder::FWObject  *object;
    bool                     dialog_buttons;

    string     magic_empty_option;

    void data_changed_flag(bool val);

    class DialogOption {
	friend class DialogPlugin;

	Gtk::Widget           *widget;
	string                 option_name;

	public:
	DialogOption(Gtk::Widget *w, const string &opt)
	{ widget=w; option_name=opt; }
    };

    void loadPageOptions(libfwbuilder::FWObject *o,vector<struct DialogOption> &page_options);
    void savePageOptions(libfwbuilder::FWObject *o,vector<struct DialogOption> &page_options);


    void saveCheckButton(libfwbuilder::FWObject *o,Gtk::CheckButton *cb, const string& name);
    void saveEntry      (libfwbuilder::FWObject *o,Gtk::Entry *en      , const string& name);
    void saveSpinButton (libfwbuilder::FWObject *o,Gtk::SpinButton *sb , const string& name);
    void saveText       (libfwbuilder::FWObject *o,Gtk::Text       *t  , const string& name);
    void saveIPAddress  (libfwbuilder::FWObject *o,IPAddressWidget *a  , const string& name);
    void saveOptionMenu (libfwbuilder::FWObject *o,OptionMenuWidget *om, const string& name);


    void loadCheckButton(libfwbuilder::FWObject *o,Gtk::CheckButton *cb, const string& name);
    void loadEntry      (libfwbuilder::FWObject *o,Gtk::Entry *en      , const string& name);
    void loadSpinButton (libfwbuilder::FWObject *o,Gtk::SpinButton *sb , const string& name);
    void loadText       (libfwbuilder::FWObject *o,Gtk::Text       *t  , const string& name);
    void loadIPAddress  (libfwbuilder::FWObject *o,IPAddressWidget *a  , const string& name);
    void loadOptionMenu (libfwbuilder::FWObject *o,OptionMenuWidget *om, const string& name);


public:

    void set_policy(gint allow_shrink, gint allow_grow, gint auto_shrink);
    void set_title(const string& title);

    DialogPlugin();
    virtual ~DialogPlugin();

    /*
     *  Implementations: virtual functions to be reimplemented in child classes
     */
    virtual void wrk2dlg() {}
    virtual bool dlg2wrk() { return false; }
    virtual void updateMainMenu();

    libfwbuilder::FWObject* getObject() { return object; }

    bool needDialogButtons() { return dialog_buttons; }
};


#endif

