/* 

                          Firewall Builder

                 Copyright (C) 2001 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: IPAddressWidget.hh,v 1.8 2001/12/23 07:15:34 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef _IPADDRESS_WIDGET_HH
#define _IPADDRESS_WIDGET_HH

#include "config.h"

#include <gtk--.h>

#include "fwbuilder/IPAddress.hh"

#include <vector>
#include <sigc++/signal_system.h>


class IPAddressWidget : public Gtk::HBox {

    protected:

    class AddressComponentWidget : public Gtk::Entry {

	virtual gint key_press_event_impl(GdkEventKey* p0);

	public:

	AddressComponentWidget() : Gtk::Entry()           { }
	AddressComponentWidget(int max) : Gtk::Entry(max) { }

/*
 * this signal is sent when user hits '.' so IPAddressWidget can shift focus
 * to the next address component
 */
	SigC::Signal0<void>jump_to_next;
    };


    private:

    vector<AddressComponentWidget*>  a;


    IPAddressWidget  *associated_netmask;

    void construct();
    void on_changed();
    void on_next();
    gint on_set_netmask(GdkEventFocus *ev);

    bool              show_all_zeroes;
    bool              ignore_changed;

    public:

    IPAddressWidget();
    IPAddressWidget( const libfwbuilder::IPAddress& addr );
    IPAddressWidget( const string& addr );

    void showAllZeroes(bool flag) { show_all_zeroes=flag; }

    void setAddress(const libfwbuilder::IPAddress& addr);
    void setAddress(const string& addr);

    string    getAsString();
    libfwbuilder::IPAddress getAsIPAddress() throw(libfwbuilder::FWException);

    void clear();

    bool empty();

    void setAssociatedNetmaskWidget( IPAddressWidget* nm );

/*
 * this signal is sent every time any address filed is changed
 */
    SigC::Signal0<void>changed;

};


#endif
