/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: ObjectQuickView.cc,v 1.19 2001/12/18 22:48:29 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "ObjectQuickView.hh"
#include "fwbuilder/FWObject.hh"

#include "fwbuilder/Host.hh"
#include "fwbuilder/Network.hh"
#include "fwbuilder/Firewall.hh"
#include "fwbuilder/Group.hh"

#include "fwbuilder/TCPService.hh"
#include "fwbuilder/UDPService.hh"
#include "fwbuilder/ICMPService.hh"
#include "fwbuilder/IPService.hh"

#include "FWObjectDatabaseGUI.hh"

#include "Preferences.hh"
#include "main_window.hh"

using namespace libfwbuilder;


string ObjectQuickView::getTextAsString()
{
    return onestring;
}

void ObjectQuickView::fillObjectQuickViewText( FWObject *o)
{
    string line;
    singleLine sl;

    onestring="";
    strings.clear();

    sl.name="Object:";
    sl.val=o->getTypeName();
    strings.push_back(sl);

    sl.name="Name:";
    sl.val=o->getName();
    strings.push_back(sl);

    onestring.append(o->getName());
    onestring.append(": ");

    if (Host::cast(o)!=NULL) {
	sl.name="Address:";
	sl.val=o->getStr("address");
	strings.push_back(sl);
	onestring.append(sl.val);

	FWObject *co=o->getFirstByType("Interface");
	if (co!=NULL) {
	    string pa=(Interface::cast(co))->getPhysicalAddress();
	    if (!pa.empty()) {
		sl.name="PhysAddress:";
		sl.val =pa;
		strings.push_back(sl);
		onestring.append("    ");
		onestring.append(sl.val);
	    }
	}

    }
    if (Firewall::cast(o)!=NULL) {
	sl.name="Platform:";
	sl.val=o->getStr("platform");
	strings.push_back(sl);

	onestring.append("  ");
//	onestring.append(sl.val);
//	onestring.append("  ");

	vector<FWObject*>::iterator m;
	Interface       *intf;

	for (m=o->begin(); m!=o->end(); ++m) {
	    if(Interface::isA((*m))) {
		intf=Interface::cast(*m);
		sl.name=" "+intf->getName();
		if (intf->isDyn()) sl.val="Dynamic address";
		else		   sl.val =intf->getIPAddress().toString();
		if (intf->isExt()) sl.val=sl.val+" (ext)";
		strings.push_back(sl);
		onestring.append(sl.name);
		onestring.append(":");
		onestring.append(sl.val);
		onestring.append("  ");
            }
	}


    }
    if (Network::cast(o)!=NULL) {
	Network *n=Network::cast(o);

	sl.name="Address:";
	sl.val=n->getAddress().toString();
	strings.push_back(sl);
	onestring.append(sl.val);
	onestring.append("/");

	sl.name="Netmask:";
	sl.val=n->getNetmask().toString();
	strings.push_back(sl);
	onestring.append(sl.val);
    }
    if (Group::cast(o)!=NULL) {
	sl.name="Members:";

	string    val="";
	FWObject* m;
	vector<FWObject*>::iterator j;
	bool  first=true;
	for(j=o->begin(); j!=o->end(); ++j) {
	    if ( (m=(*j))!=NULL )  {
		if ( FWReference::cast(m)!=NULL ) 
		    m=(FWReference::cast(m))->getPointer();
		if (!first) val += ", ";
		val += m->getName();
		first=false;
	    }
	}
	sl.val=val;
	strings.push_back(sl);
	onestring.append(sl.val);
    }

    if (TCPService::cast(o)!=NULL || UDPService::cast(o)!=NULL) {
	string sps,spe,dps,dpe;

	sps=o->getStr("src_range_start");
	spe=o->getStr("src_range_end");
	dps=o->getStr("dst_range_start");
	dpe=o->getStr("dst_range_end");

	if (sps==spe && dps==dpe) {
	    sl.name = "Source port:";
	    sl.val  = sps;
	    strings.push_back(sl);
	    onestring.append("src.port:");
	    onestring.append(sl.val);
	    onestring.append(", ");

	    sl.name = "Destination port:";
	    sl.val  = dps;
	    strings.push_back(sl);
	    onestring.append("dst.port:");
	    onestring.append(sl.val);
	} else {

	    onestring.append("src.ports:");
	    sl.name = "Source port range start:";
	    sl.val  = sps;
	    strings.push_back(sl);
	    onestring.append(sl.val);
	    onestring.append("-");

	    sl.name = "Source port range end:";
	    sl.val  = spe;
	    strings.push_back(sl);
	    onestring.append(sl.val);
	    onestring.append(", ");

	    onestring.append("dst.ports:");
	    sl.name = "Destination port range start:";
	    sl.val  = dps;
	    strings.push_back(sl);
	    onestring.append(sl.val);
	    onestring.append("-");

	    sl.name = "Destination port range end:";
	    sl.val  = dpe;
	    strings.push_back(sl);
	    onestring.append(sl.val);
	}
    }

    if (ICMPService::cast(o)!=NULL) {
	sl.name="Code:";
	sl.val=o->getStr("code");
	strings.push_back(sl);
	onestring.append("code:");
	onestring.append(sl.val);
	onestring.append("  ");

	sl.name="Type:";
	sl.val=o->getStr("type");
	strings.push_back(sl);
	onestring.append("type:");
	onestring.append(sl.val);
    }

    if (IPService::cast(o)!=NULL) {
	sl.name="Protocol:";
	sl.val=o->getStr("protocol_num");
	strings.push_back(sl);
	onestring.append("prot.:");
	onestring.append(sl.val);
    }

    if (o->getComment()!="") {
	sl.name="Comment:";
	sl.val=o->getComment();
	strings.push_back(sl);
    }

    if (onestring.length()>120) {
	string s=onestring.substr(0,117);
	onestring=s+"...";
    } 

}

ObjectQuickView* ObjectQuickView::instance=NULL;

ObjectQuickView* ObjectQuickView::getInstance()
{
    if (instance==NULL) 
	instance=new ObjectQuickView();

    return instance;
}

ObjectQuickView::ObjectQuickView() :  Gtk::Window(GTK_WINDOW_POPUP)
{
    border=8;
    spacing=6;
    active=false;
    widget=NULL;

    quick_view_timer_connected=false;
    quick_view_shown_in_status_bar=false;

    set_policy(true, true, true);

    set_name("ObjectQuickView");

    size_request.connect(SigC::slot(this,&ObjectQuickView::on_size_request));
    size_allocate.connect(SigC::slot(this,&ObjectQuickView::on_size_allocate));
}


ObjectQuickView::~ObjectQuickView()
{
    strings.clear();
}

void ObjectQuickView::setObject(FWObject *obj)
{
    fillObjectQuickViewText(obj);
}

void ObjectQuickView::setObjectById(const string &id)
{
    FWObject *object=FWObjectDatabaseGUI::db->getById(id,true);
    fillObjectQuickViewText(object);
}

void   ObjectQuickView::setText(const string &txt)
{
    onestring="";
    strings.clear();


    string line;
    singleLine sl;

    string::size_type b,n;
    b=0;
    while ( (n=txt.find('\n',b))!=string::npos ) {
	line= txt.substr(b,n-b);
	sl.name=line;
	sl.val ="";
	strings.push_back(sl);
	b+=n+1;
	
	onestring.append("   ");
	onestring.append(sl.name);
    }
    line= txt.substr(b);
    sl.name=line;
    sl.val ="";
    strings.push_back(sl);

    onestring.append("   ");
    onestring.append(sl.name);
}

void   ObjectQuickView::attachTo(Gtk::Widget *w)
{
    widget=w;
}


void   ObjectQuickView::activate()
{
    if (active) deactivate();

    if ( Preferences::global_prefs->getOptStr(
	     "/FWBuilderPreferences/UI/ObjectQuickView")=="window") {
/* 
 *  show on the status bar
 */
	string str=getTextAsString();

	main_w->clearStatusbar();
	main_w->showStatusbarMsg(str);
	quick_view_shown_in_status_bar=true;
    }

    if ( Preferences::global_prefs->getOptStr(
	     "/FWBuilderPreferences/UI/ObjectQuickView")=="popup") {

	int timeout= Preferences::global_prefs->getOptInt(
	    "/FWBuilderPreferences/UI/ObjectQuickViewTimeout");
	
	quick_view_timer_conn=Gtk::Main::timeout.connect(
	    SigC::slot(this,&ObjectQuickView::timer_callback),
	    timeout*1000 );
	    quick_view_timer_connected=true;	    
    }
    
    active=true;
}

void   ObjectQuickView::deactivate()
{
    if (quick_view_timer_connected) {
	quick_view_timer_conn.disconnect();
	quick_view_timer_connected=false;	    
    }

    hide();

    if (quick_view_shown_in_status_bar) {
	main_w->showStatusbarMsg("");
	quick_view_shown_in_status_bar=false;
    }

    active=false;
}

gint ObjectQuickView::timer_callback()
{
    int x,y,w,h,d;

    if (widget) {
	Gdk_Window   wnd=widget->get_window();

	wnd.get_geometry(x,y,w,h,d);
	wnd.get_origin(x,y);

	x-=10;
	y+=(h+10);

	set_uposition(x,y);
    }

    show();

    return false;
}



void ObjectQuickView::draw_impl (GdkRectangle* p0) { paint(p0); }

gint ObjectQuickView::expose_event_impl(GdkEventExpose* ex)
{
    paint( &ex->area );
    return true;
}

void ObjectQuickView::paint(GdkRectangle* p0)
{
    GtkWidget*   widget=GTK_WIDGET(gtkobj());
    Gdk_Window   wnd=get_window();

    Gtk::Style  *st=get_style();

    Gdk_Font     fn=st->get_font();

    Gdk_GC       gc=Gdk_GC(wnd);
    Gdk_GC       wgc;

    int          strx,stry;

    gdk_window_clear_area( wnd, p0->x,p0->y,p0->width,p0->height);

    gdk_gc_set_clip_rectangle( widget->style->white_gc , p0 );
    gdk_draw_rectangle( widget->window,
			widget->style->white_gc,
			true,
			p0->x,p0->y,p0->width,p0->height);

    gdk_gc_set_clip_rectangle( widget->style->black_gc , p0 );
    gdk_draw_rectangle( widget->window,
			widget->style->black_gc,
			false,
			p0->x,p0->y,p0->width-1,p0->height-1);

    strx=border;
    stry=border+sh;

    list<singleLine>::iterator m;
    singleLine                 sl;

    gdk_gc_set_clip_rectangle( widget->style->fg_gc[get_state()] , p0 );

    for (m=strings.begin(); m!=strings.end(); ++m) {
	sl=(*m);

	gdk_draw_text(  widget->window, 
			widget->style->font ,
			widget->style->fg_gc[get_state()],
			strx, stry,
			sl.name.c_str(),
			sl.name.length() );

	gdk_draw_text(  widget->window, 
			widget->style->font ,
			widget->style->fg_gc[get_state()],
			strx+sw1+spacing, stry,
			sl.val.c_str(),
			sl.val.length() );

	stry += (sh+spacing);
    }

}

void ObjectQuickView::on_size_request(GtkRequisition* req)
{
    Gtk::Style *st=get_style();
    Gdk_Font    fn=st->get_font();
    gint        resx, resy;

    list<singleLine>::iterator m;
    singleLine                 sl;
    int  i, n;

    n=sw1=sw2=sh=0;

    for (m=strings.begin(); m!=strings.end(); ++m) {
	sl=(*m);
	n++;
	i= fn.string_width(sl.name); if (sw1<i) sw1=i;
	i= fn.string_width(sl.val);  if (sw2<i) sw2=i;
	sh= fn.string_height(sl.name);
    }

    resx=sw1+sw2+spacing;
    resy=(sh+spacing)*n;

    resx+=(border*2);
    resy+=(border*2);

    req->width   = resx;
    req->height  = resy;
}

void ObjectQuickView::on_size_allocate(GtkAllocation* ga)
{
/*
 *  Remember position, width and height allocated for this widget. 
 *  This info is needed in paint
 */
    x=ga->x;
    y=ga->y;
    width=ga->width;
    height=ga->height;
}




