/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: Preferences.cc,v 1.33 2001/12/18 22:48:29 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

/* $Id: Preferences.cc,v 1.33 2001/12/18 22:48:29 vkurland Exp $ */

#include <sys/types.h>
#include <sys/stat.h>
#include <pwd.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>

#include <fstream>
#include <cstdlib>

#include <parser.h>
#include <tree.h>

#include <config.h>

#include "Preferences.hh"
#include "fwbuilder/FWObject.hh"
#include "FWObjectDatabaseGUI.hh"
#include "fwbuilder/Tools.hh"
#include "helpers.hh"

using namespace libfwbuilder;

const string Preferences::PREFS_TEMPLATE_FILE_NAME    = "fwbuilder_prefs.xml"       ;
const string Preferences::PREFS_FILE_NAME             = ".fwbuilder.xml"            ;
const string Preferences::DTD_FILE_NAME               = "fwbuilder_preferences.dtd" ;
const string Preferences::TYPENAME                    = "FWBuilderPreferences"      ;

Preferences*  Preferences::global_prefs = NULL;

Preferences::Preferences() throw(FWException)
{
    g_assert(global_prefs==NULL);

    global_prefs=this;

    struct passwd *pwd=getpwuid(getuid());
    g_assert(pwd!=NULL);

    prefsFile = string(pwd->pw_dir)+"/"+PREFS_FILE_NAME;
    
    doc=NULL;

    if(access(prefsFile.c_str() , R_OK )!=0) 
    {
        string prefsTemplateFile = TEMPLATE_DIR  "/" + PREFS_TEMPLATE_FILE_NAME;

        std::ifstream in(prefsTemplateFile.c_str());
        if(in.fail())
            throw FWException("Could not open user preferences template file: "+prefsTemplateFile);

        std::ofstream out(prefsFile.c_str());
        if(out.fail())
            throw FWException("Could not create user preferences file: "+prefsFile);

        int c;
        while((c=in.get()) && c!=EOF)
            out.put(c);	    
    }
    loadPrefs();
}


xmlNodePtr Preferences::getXmlNode(const string& path)
{
    return XMLTools::getXmlNodeByPath(root,path);
}

void  Preferences::setOpt(const string &path, const string &val)
{
    setOpt(path, val.c_str());
}


void  Preferences::setOpt(const string &path, const char* val)
{
    xmlNodePtr node;

    node=XMLTools::getXmlNodeByPath(root,path);

    if (node)  
	xmlNodeSetContent(node,TOXMLCAST(val));
}

void  Preferences::setOptInt(const string &path, int val)
{
    char str[32];
    sprintf(str,"%d",val);
    setOpt(path,str);
}


void  Preferences::setOptBool(const string &path, bool val)
{
    setOpt(path,(val)?"true":"false");
}

string Preferences::getOptStr(const string &path)
{
    return( string(getOpt(path)));
}

int Preferences::getOptInt(const string &path)
{
    char  *s=getOpt(path);
    return (atoi(s));
}

int Preferences::getOptInt(const string& name, int default_value)
{
    xmlNodePtr node=XMLTools::getXmlNodeByPath(root, name);
    char *res=NULL;
    
    if (node) 
	res= (char*)( xmlNodeGetContent(node) );

    if (res) 
        return atoi(res);
    else     
        return default_value;
}

bool Preferences::getOptBool(const string &path)
{
    char  *s=getOpt(path);
    return (strcasecmp(s,"true")==SAME || strcmp(s,"1")==SAME );
}

gchar* Preferences::getOpt(const string &path)
{
    xmlNodePtr node=XMLTools::getXmlNodeByPath(root,path);
    char *res=NULL;

    if (node) 
	res= (char*)( xmlNodeGetContent(node) );

    if (res) return(res);
    else     return("");
}

void Preferences::setProp(const string& path,
			  const char* attrname,
			  const char* val)
{
    xmlNodePtr node;
    node=XMLTools::getXmlNodeByPath(root,path);
    if (node) 
	setProp(node,attrname,val);
}

string Preferences::getPropStr(const string& path,const char* attrname)
{
    return string(getProp(path,attrname));
}

gchar* Preferences::getProp(const string& path,const char* attrname)
{
    xmlNodePtr node=XMLTools::getXmlNodeByPath(root,path);
    return(getProp(node,attrname));
}

void Preferences::setProp(xmlNodePtr node,
			  const char* attrname,
			  const char* val)
{
    if (node) 
	FROMXMLCAST( xmlSetProp(node,
				TOXMLCAST(attrname),
				TOXMLCAST(val)
	));




}

string Preferences::getPropStr(xmlNodePtr node,
			       const char* attrname)
{
    return string(getProp(node,attrname));
}

gchar* Preferences::getProp(xmlNodePtr node,
			    const char* attrname)
{
    char *res=NULL;
    if (node)
	res=(char*)( xmlGetProp(node,TOXMLCAST(attrname)));
    if (res)	return( res );
    else        return( "" );
}

void Preferences::loadPrefs() throw(FWException)
{
    MessageBoxUpgradePredicate upgrade_predicate;
    doc = XMLTools::loadFile(prefsFile, TYPENAME, DTD_FILE_NAME, &upgrade_predicate, TEMPLATE_DIR, VERSION);
    root= xmlDocGetRootElement(doc);
}

void Preferences::savePrefs() throw(FWException)
{
    if(!doc)
        throw FWException("Preferences file not saved - it's empty");
    
    XMLTools::saveFile(doc, prefsFile, TYPENAME, DTD_FILE_NAME);
}

/**
 *   this method is just an algorithm to chose work directory from
 *   preferences parameter "working directory" or directory where 
 *   last object data file has been loaded from
 *
 *   We use directory set in preferences if there was no object file
 *   loaded yet, and directory where it was loaded from otherwise
 */
string Preferences::getWdir()
{

    if (FWObjectDatabase::db->getFileName()=="")
	return
	    Preferences::global_prefs->getOpt("/FWBuilderPreferences/Paths/Wdir");
	
    else 
	return FWObjectDatabase::db->getFileDir();

}









