/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: Preferences.hh,v 1.18 2001/12/23 07:15:34 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef _PREFERENCES_HH
#define _PREFERENCES_HH

#include "config.h"

#include <map>
#include <string>

#include <gtk--.h>

#include <parser.h>
#include <tree.h>

#include "fwbuilder/FWObject.hh"
#include "fwbuilder/XMLTools.hh"
#include "fwbuilder/FWException.hh"

class Preferences 
{
    xmlDocPtr  doc;
    xmlNodePtr root;

    string prefsFile;

    static const string PREFS_FILE_NAME          ;
    static const string PREFS_TEMPLATE_FILE_NAME ;
    static const string DTD_FILE_NAME            ;
    static const string TYPENAME                 ;

public:

    Preferences() throw(libfwbuilder::FWException);

    void loadPrefs() throw(libfwbuilder::FWException);
    void savePrefs() throw(libfwbuilder::FWException);

    xmlNodePtr getXmlNode(const string& path);

    void   setOpt(const string& name,const string &val);
    void   setOpt(const string& name,const char* val);
    void   setOptInt(const string& name,int val);
    void   setOptBool(const string& name,bool val);

    gchar* getOpt(const string& name);
    string getOptStr(const string& name);
    int    getOptInt(const string& name);
    int    getOptInt(const string& name, int default_value);
    bool   getOptBool(const string& name);

    void   setProp(const string& path,const char* attrname,const char* val);
    gchar* getProp(const string& path,const char* attrname);
    string getPropStr(const string& path,const char* attrname);

    void   setProp(xmlNodePtr node,const char* attrname,const char* val);
    gchar* getProp(xmlNodePtr node,const char* attrname);
    string getPropStr(xmlNodePtr node,const char* attrname);

    string getWdir();

    static Preferences   *global_prefs;
};


#endif



