#!/usr/bin/perl
#
#
#                          Firewall Builder
#
#                 Copyright (C) 2001 Vadim Kurland
#
#  Author:  Vadim Kurland     vadim@vk.crocodile.org
#
#####
#
#  This is simple script to watch iptables log  and make it
#  more readable. This script drops some fields recorded by iptables
#  in the log for the sake of readability; some possibly important
#  information can be missed because of this.  In case of doubdt
#  always look in the original log!
#
#  This script expects log to be sent by syslog daemon to the file
#  /var/log/messages  which is the default setting on RedHat Linux
#  systems, however it is trivial to change this script to read any
#  other file. User running the script should have rights to read this
#  file. Script sends parsed log lines to the standard output as they
#  appear in /var/log/messages
#


open F, "tail -f /var/log/messages |" || die "Could not open log file";
while (<F>) {

  $datetime="";
  $rule    ="";
  $action  ="";
  $iface   ="";
  $src     ="";
  $dst     ="";
  $proto   ="";
  $spt     ="";
  $dpt     ="";
  $type    ="";
  $code    ="";

  if ( $_=~/(\S+)\s+(\S+)\s+(\S+).*(RULE \S+).+-\s+(\S+).*IN=(\S+).*SRC=(\S+)\s+DST=(\S+).*PROTO=(\S+)/ ) {

    $datetime="$1 $2 $3";
    $rule    = $4;
    $action  = $5;
    $iface   = $6;
    $src     = $7;
    $dst     = $8;
    $proto   = $9;


    if ( $_=~/SPT=(\S+)\s+DPT=(\S+)/ ) {
      $spt     = $1;
      $dpt     = $2;
    }

    if ( $_=~/(TYPE=\S+)\s+(CODE=\S+)/ ) {
      $type    = $1;
      $code    = $2;
    }

    printf "%s %s %s %s %s ",$datetime,$rule,$action,$iface,$proto;
    if ($proto eq "ICMP") {
      printf "%s %s %s %s\n", $src,$dst,$type,$code;
    } else {
      printf "%s:%s %s:%s\n",$src,$spt,$dst,$dpt;
    }
  }
}


