/* 

                          Firewall Builder

                 Copyright (C) 2003 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: RCSFileDialog.cpp,v 1.16 2006/10/22 00:09:08 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"
#include "global.h"

#include "FWBSettings.h"
#include "RCSFileDialog.h"
#include "RCSFilePreview.h"
#include "RCS.h"

#include <qsplitter.h>

#include <iostream>

using namespace std;

RCSFileDialog::RCSFileDialog( const QString& dirName, const QString& filter,
                              QWidget* parent, const char* name, bool modal )
    : QFileDialog( dirName, filter, parent, name, modal)
{
    if (fwbdebug) qDebug("RCSFileDialog: constructor 1");

    addFilter( "Old Firewall Builder files (*.xml)" );
    addFilter( "Firewall Builder 2 library files (*.fwl)");
    addFilter( "Firewall Builder 2 files (*.fwb)");
    resize( QSize(700, 350) );

    RO = false;

    QString dir;
    dir=st->getWDir();
    if (dir.isEmpty())  dir=st->getOpenFileDir();
    if (!dir.isEmpty()) setDir( dir );

    if (fwbdebug) qDebug("RCSFileDialog: checkpoint 1");

/* TODO: do this only if we need RCS */
    setPreviewMode(QFileDialog::Contents);
    preview = new RCSFilePreview( this );
    setContentsPreviewEnabled( true );
    setContentsPreview( preview , preview );
    setPreviewMode( QFileDialog::Contents );

    QWidget *p0 = preview;
    QWidget *p  = preview;
    while (p!=this && dynamic_cast<QSplitter*>(p)==NULL)
    {
        p0 = p;
        p = p->parentWidget();
    }
    if (p!=this)
    {
        QSplitter *sp = dynamic_cast<QSplitter*>(p);
        assert(sp);
        QValueList<int> sizes;
        sizes.append(320);
        sizes.append(320);
        sp->setSizes(sizes);
    }
/*************************************/
    if (fwbdebug) qDebug("RCSFileDialog: constructor done");
}

RCSFileDialog::RCSFileDialog( QWidget* parent, const char* name, bool modal )
    : QFileDialog(parent, name, modal)
{
    if (fwbdebug) qDebug("RCSFileDialog: constructor 2");

    addFilter( "Old Firewall Builder files (*.xml)" );
    addFilter( "Firewall Builder 2 library files (*.fwl)");
    addFilter( "Firewall Builder 2 files (*.fwb)");
    resize( QSize(700, 350) );

    RO = false;

    QString dir;
    dir=st->getWDir();
    if (dir.isEmpty())  dir=st->getOpenFileDir();
    if (dir.isEmpty())  dir=userDataDir.c_str();
    if (!dir.isEmpty()) setDir( dir );

/* RCS is a kind of a universal wrapper, we use it even if file is not
 * in RCS and we do not use revision control */

    setPreviewMode(QFileDialog::Contents);
    preview = new RCSFilePreview( this );
    setContentsPreviewEnabled( true );
    setContentsPreview( preview , preview );
    setPreviewMode( QFileDialog::Contents );

    QWidget *p  = preview;
    while (p!=this && dynamic_cast<QSplitter*>(p)==NULL)
    {
        p = p->parentWidget();
    }

    if (p!=NULL && p!=this)
    {
        QSplitter *sp = dynamic_cast<QSplitter*>(p);

        if (sp)
        {
            if (fwbdebug) qDebug("RCSFileDialog: resizing splitter");
            QValueList<int> sizes;
            sizes.append(320);
            sizes.append(320);
            sp->setSizes(sizes);
        }
    }
    if (fwbdebug) qDebug("RCSFileDialog: constructor done");
}

void RCSFileDialog::openFileRO()
{
    RO = true;
    accept();
}

void RCSFileDialog::accept()
{
    st->setOpenFileDir( dirPath() );

    QFileDialog::accept();
}

RCS*  RCSFileDialog::getSelectedRev()
{
    RCS *preview_rcs = preview->getSelectedRev();
    if (preview_rcs!=NULL && preview_rcs->getFileName()==selectedFile())
        return preview_rcs;

    RCS *rcs = new RCS(selectedFile());
    if (RO) rcs->setRO(true);
    return rcs;
}
