<?php
// File           tb_watch.php / ibWebAdmin
// Purpose        html sequence for the table-watch-panel in sql.php and data.php
// Author         Lutz Brueckner <irie@gmx.de>
// Copyright      (c) 2000, 2001, 2002, 2003 by Lutz Brueckner,
//                published under the terms of the GNU General Public Licence v.2,
//                see file LICENCE for details
// Created        <00/11/29 16:12:21 lb>
//
// $Id: tb_watch.php,v 1.12 2003/12/14 13:54:25 lbrueckner Exp $


if (!isset($tb_watch_cfg_flag)  &&  $s_connected) {

?>
<table>
<form method="post" action="<?php echo $HTTP_SERVER_VARS['PHP_SELF']; ?>" name="tb_watch_form">
<?php hidden_session_field(); ?>
  <tr>
    <td colspan="1">
      <b><?php echo $sql_strings['SelTable']; ?></b><br>
      <select name="tb_watch_table">
        <?php build_table_options($s_watch_table, array('select')); ?>
      </select>
      <input type="submit" name="tb_watch_select" value="<?php echo $button_strings['Select']; ?>">
    </td>
<?php

    if (isset($s_watch_table) and $s_watch_table != '') {
        echo "<td width=\"100\">&nbsp;</td>\n";
        $url = url_session($HTTP_SERVER_VARS['PHP_SELF'].'?wcfg=true');
        echo '<td><a href="'.$url.'"><b>['.$sql_strings['Config']."]</b></a></td>\n";
    }
?>
  </tr>
</table> 
<table>
  <tr>
    <td>
      <?php
           display_table($s_watch_table, $s_watch_columns, $s_watch_start, $s_watch_rows, $s_watch_direction);
      ?>
    </td>
  </tr>
</table>
<div id="fk" class="fk"></div>
<?php

}

//
// Configuration panel
//
elseif ($s_connected) {

?>
<form method="post" action="<?php echo $HTTP_SERVER_VARS['PHP_SELF']; ?>" name="tb_watch_form">
<?php hidden_session_field(); ?>
<table>
  <tr>
    <td colspan="5">
      <?php watchtable_column_options($s_watch_table,
                                      $s_watch_columns,
                                      $s_watch_sort,
                                      $s_watch_blinks,
                                      $s_watch_blobas
                                      );
       ?>
    </td>
  <tr>
</table>
<table>
  <tr>
    <th><?php echo $sql_strings['Rows']; ?></th>
    <th><?php echo $sql_strings['Start']; ?></th>
    <th><?php echo $sql_strings['Dir']; ?></th>
    <th><?php echo $sql_strings['ELinks']; ?></th>
    <th><?php echo $sql_strings['DLinks']; ?></th>
  </tr>
  <tr>
    <td align="center">
      <input type="text" size="4" maxlength="4" name="tb_watch_rows" value="<?php echo $s_watch_rows; ?>">
    </td>
    <td align="center">
      <input type="text" size="8" maxlength="8" name="tb_watch_start" value="<?php echo $s_watch_start; ?>">
    </td>
    <td align="center">
       <?php echo get_selectlist('tb_watch_direction', array($sql_strings['Asc'], $sql_strings['Desc']), ucfirst(strtolower($s_watch_direction))); ?>
    </td>
    <td align="center">
       <?php echo get_selectlist('tb_watch_edit', array($sql_strings['Yes'], $sql_strings['No']), ucfirst(strtolower($s_watch_edit))); ?>
    </td>
    <td align="center">
       <?php echo get_selectlist('tb_watch_del', array($sql_strings['Yes'], $sql_strings['No']), ucfirst(strtolower($s_watch_del))); ?>
    </td>
  </tr>
</table>
<table>
  <tr>
    <th><?php echo $sql_strings['TBInline']; ?></th>
    <th><?php echo $sql_strings['TBChars']; ?></th>
  <tr>
    <td align="center">
       <?php echo get_selectlist('tb_watch_tblob_inline', array($sql_strings['Yes'], $sql_strings['No']), ucfirst(strtolower($s_watch_tblob_inline))); ?>
    </td>
    <td align="center">
      <input type="text" size="4" maxlength="4" name="tb_watch_tblob_chars" value="<?php echo $s_watch_tblob_chars; ?>">
    </td>
  </tr>
</table>
<table>
  <tr>
    <th colspan="5" align="left"><?php echo $sql_strings['Restrict']; ?></th>
  </tr>
  <tr>
    <td colspan="5">
      <input type="text" size="60" maxlength="256" name="tb_watch_condition" value="<?php echo $s_watch_condition; ?>">
    <td>
  </tr>
</table>
<input type="submit" name="tb_watch_cfg_cancel" value="<?php echo $button_strings['Cancel']; ?>">
<input type="submit" name="tb_watch_cfg_doit" value="<?php echo $button_strings['Ready']; ?>">
</form>
<?php
}
?>
