import sys
import os
import string

# the location of the script itself:
SCRIPT_DIR = sys.path[0]

# the user home dir:
HOME = os.environ["HOME"]

# the icewm dir in the users home:
HOME_ICEWM = os.path.join(HOME, ".icewm")

# the list of paths in the environment variable $PATH:
PATH = string.split(os.environ["PATH"], os.pathsep)

# the command to run IcePref:
ICEPREF = "icepref"

# constants for entries in the tree menu, used by IceMenuTree and MenuParser:
MENUTREE_PROG = 1
MENUTREE_RESTART = 2
MENUTREE_SUBMENU = 3
MENUTREE_SUBMENU_END = 4
MENUTREE_SEPARATOR = 5
MENUTREE_UNKNOWN = 6

# what a seperator should look like:
SEP_STRING = "--------------------"

# constants from unistd.h for the second argument to os.access(...).
# these may be OR'd together.
R_OK = 4    # test for read permission
W_OK = 2    # test for write permission
X_OK = 1    # test for execute permission
F_OK = 0    # test for existence

