/* icoutils - A set of programs dealing with MS Windows icons and cursors.
 * Copyright (C) 1998-1999 Oskar Liljeblad
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "messages.h"

void
verbose_printf (const char *format, ...)
{
	va_list args;

	va_start(args, format);
	if (arg_verbosity >= 1)
		vfprintf(verbose_file, format, args);
	va_end(args);
}

void
debug_printf (const char *format, ...)
{
	va_list args;

	va_start(args, format);
	if (arg_verbosity >= 2)
		vfprintf(verbose_file, format, args);
	va_end(args);
}

void
error_printf (const char *format, ...)
{
	va_list args;

	va_start(args, format);
	fprintf(stderr, "%s: ", prgname);
	vfprintf(stderr, format, args);
	va_end(args);
}

void
warn_printf (const char *format, ...)
{
	va_list args;

	va_start(args, format);
	vfprintf(stderr, format, args);
	va_end(args);
}

void
malloc_failure ()
{
	errno = ENOMEM;
	P_GEN_SYS_ERROR();
	exit(1);
}
