/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef IDATAFORMATTER_H
#define IDATAFORMATTER_H


#include "iviewmodulecomponent.h"


#include "iarray.h"
#include "istring.h"

class iDataLimits;


class iDataFormatter : public iViewModuleComponent
{

public:

	inline int GetNumReportLines() const { return mVarNameLines.Size(); }
	void GetReport(int i, iString& varName, iString &varData, iString &varUnit) const;

	void AddOneLine(const iString &name, const iString &data, const iString &unit);

protected:

	iDataFormatter(iViewModule *vm);
	virtual ~iDataFormatter();

	void ClearReport();

	void FormatScalarData(iDataLimits *lim, int n, float *v, bool useClass = false);
	void FormatVectorData(iDataLimits *lim, int ivar, float *v, float *div = 0, float *vort = 0);
	void FormatTensorData(iDataLimits *lim, int ivar, float *v, bool compressed = false);

private:

	iArray<iString> mVarNameLines, mVarDataLines, mVarUnitLines;
	iString mFormatHelper;
};

#endif  // IDATAFORMATTER_H
