/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iggdialoghelp.h"


#include "ihelpfactory.h"
#include "iimagefactory.h"

#include "iggframe.h"
#include "iggmainwindow.h"
#include "iggwidgetarea.h"
#include "iggwidgetotherbutton.h"
#include "iggwidgettext.h"

#include "ibgwidgetbuttonsubject.h"

#include "iggparameter.h"
using namespace iggParameter;


namespace iggDialogHelp_Private
{
	class HelpBrowser : public iggWidgetHelpBrowser
	{

		friend class TopicList;

	public:

		HelpBrowser(const iggDialog *dialog, iggFrame *parent) : iggWidgetHelpBrowser(parent), mDialog(dialog)
		{
		}

	protected:

		virtual void OnNullHelpBuffer()
		{
			this->GetMainWindow()->PopupWindow(mDialog->GetFrame(),"The data for this link are missing.");
		}

		const iggDialog *mDialog;
	};


	class TopicList : public iggWidgetHelpBrowser
	{

	public:

		TopicList(HelpBrowser *browser, iggFrame *parent) : iggWidgetHelpBrowser(parent)
		{
			mBrowser = browser;

			iString text;
			iHelpFactory::CreateTopicList(text);
			this->SetContentsText(text);
		}

	protected:

		virtual void OnMousePress(int para, int index)
		{
			mBrowser->OnMousePress(-1-para,-1-index);
		}

		virtual void OnMouseRelease(int para, int index)
		{
			mBrowser->OnMouseRelease(-1-para,-1-index);
		}

		virtual void OnLinkFollowed(const char *tag)
		{
			mBrowser->OnLinkFollowed(tag);
		}

		HelpBrowser *mBrowser;
	};


	class NavigationButton : public iggWidgetSimpleButton
	{

	public:

		NavigationButton(int mode, iggWidgetHelpBrowser *browser, iggFrame *parent) : iggWidgetSimpleButton("",parent,true)
		{
			mMode = mode;
			mBrowser = browser;

			mBrowser->AddDependent(this);

			switch(mMode)
			{
			case -1:
				{
					mSubject->SetIcon(*iImageFactory::FindIcon("moveleft.png"));
					this->SetBaloonHelp("Go back one page","Go back to the previous visited page.");
					break;
				}
			case 0:
				{
					mSubject->SetIcon(*iImageFactory::FindIcon("movetop.png"));
					this->SetBaloonHelp("Go home","Go to the first visited page.");
					break;
				}
			case 1:
				{
					mSubject->SetIcon(*iImageFactory::FindIcon("moveright.png"));
					this->SetBaloonHelp("Go forward one page","Go forward to the next visited page.");
					break;
				}
			}
		}

	protected:

		virtual void UpdateWidgetBody()
		{
			switch(mMode)
			{
			case -1:
				{
					this->Enable(mBrowser->CanGoBackward());
					break;
				}
			case 1:
				{
					this->Enable(mBrowser->CanGoForward());
					break;
				}
			}
		}

		virtual void Execute()
		{
			switch(mMode)
			{
			case -1:
				{
					mBrowser->Backward();
					break;
				}
			case 0:
				{
					mBrowser->Home();
					break;
				}
			case 1:
				{
					mBrowser->Forward();
					break;
				}
			}
			this->UpdateWidget();
		}

		int mMode;
		iggWidgetHelpBrowser *mBrowser;
	};
};


using namespace iggDialogHelp_Private;


//
//  Main class
//
iggDialogHelp::iggDialogHelp(iggMainWindow *parent) : iggDialog(parent,0U,0,"Help","sr.gg.dh",2,false)
{
	HelpBrowser *hb = new HelpBrowser(this,mFrame);
	TopicList *tc = new TopicList(hb,mFrame);
	mBrowser = hb;

	iggFrame *tmp = new iggFrame(mFrame,5);
	mFrame->AddLine(tmp,2);
	tmp->AddLine(new NavigationButton(-1,mBrowser,tmp),new NavigationButton(1,mBrowser,tmp),new NavigationButton(0,mBrowser,tmp),(iggWidget *)0,new iggWidgetDialogCloseButton(this,tmp));
	tmp->AddLine(new iggWidgetTextArea("Back",tmp),new iggWidgetTextArea("Forward",tmp),new iggWidgetTextArea("Home",tmp),(iggWidget *)0,(iggWidget *)0);
	tmp->SetColStretch(3,10);

	mFrame->AddLine(tc->Self(),mBrowser->Self());

	mBrowser->SetContents("ug.pf");

	mFrame->SetRowStretch(1,10);
	mFrame->SetColStretch(0,5);
	mFrame->SetColStretch(1,10);

	this->ResizeContents(800,600);
}


void iggDialogHelp::Open(const char *tag)
{
	mBrowser->SetContents(tag);
	this->Show(true);
}

