/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef IVIEWFAMILY_H
#define IVIEWFAMILY_H


#include "ifamily.h"


class iDataSyncRequest;
class iDataType;
class iObjectType;


//
//  Main class
//
template<class Object, class ObjectParent>
class iViewFamily : public iFamily<Object,ObjectParent>
{
	
public:
		
	virtual bool DeleteMember(int i);
	bool Copy(const iViewFamily *p);

	void Show(bool s); 
	inline bool IsVisible() const { return this->mVis; } 

	void Reset();
	float GetMemorySize() const;
	void ShowClipPlane(bool s);

	const iObjectType& GetType() const { return this->mParent->RealType(); }
	void SyncWithData(const iDataSyncRequest &r);

protected:

	iViewFamily(ObjectParent *parent);

private:

	bool mVis;
};

#endif // IVIEWFAMILY_H
