/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2011 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "idatahelper.h"


#include "ierror.h"

#include <vtkDataArray.h>
#include <vtkDataSet.h>
#include <vtkPointData.h>


namespace iDataHelper_Private
{
	template<class T>
	void CICTemplate(bool periodic[3], int dims[3], double org[3], double spa[3], T pos[3], int ijk1[3], int ijk2[3], double d1[3], double d2[3]);
};


using namespace iDataHelper_Private;


iDataHelper::iDataHelper(vtkDataSet *ds)
{
	mData = ds;
}


iDataHelper::~iDataHelper()
{
}


unsigned int iDataHelper::GetDataRank() const
{
	if(this->IsThereTensorData()) return 2U; else if(this->IsThereVectorData()) return 1U; else return 0U;
}


bool iDataHelper::IsThereData() const
{
	return (mData!=0 && mData->GetNumberOfPoints()>0);
}


bool iDataHelper::IsThereScalarData() const
{
	return (mData!=0 && mData->GetPointData()!=0 && mData->GetPointData()->GetScalars()!=0 && 
		mData->GetPointData()->GetScalars()->GetSize()>0 && 
		mData->GetPointData()->GetScalars()->GetDataType()==VTK_FLOAT);
}


bool iDataHelper::IsThereVectorData() const
{
	return (mData!=0 && mData->GetPointData()!=0 && mData->GetPointData()->GetVectors()!=0 && 
		mData->GetPointData()->GetVectors()->GetSize()>0 && 
		mData->GetPointData()->GetVectors()->GetDataType()==VTK_FLOAT &&
		mData->GetPointData()->GetVectors()->GetNumberOfComponents()==3);
}


bool iDataHelper::IsThereTensorData() const
{
	return (mData!=0 && mData->GetPointData()!=0 && mData->GetPointData()->GetTensors()!=0 && 
		mData->GetPointData()->GetTensors()->GetSize()>0 && 
		mData->GetPointData()->GetTensors()->GetDataType()==VTK_FLOAT &&
		mData->GetPointData()->GetTensors()->GetNumberOfComponents()==9);
}


//
//  Two helper functions
//
void iDataHelper::CIC(bool periodic[3], int dims[3], double org[3], double spa[3], float pos[3], int ijk1[3], int ijk2[3], double d1[3], double d2[3])
{
	CICTemplate(periodic,dims,org,spa,pos,ijk1,ijk2,d1,d2);
}


void iDataHelper::CIC(bool periodic[3], int dims[3], double org[3], double spa[3], double pos[3], int ijk1[3], int ijk2[3], double d1[3], double d2[3])
{
	CICTemplate(periodic,dims,org,spa,pos,ijk1,ijk2,d1,d2);
}


namespace iDataHelper_Private
{
	template<class T>
	void CICTemplate(bool periodic[3], int dims[3], double org[3], double spa[3], T pos[3], int ijk1[3], int ijk2[3], double d1[3], double d2[3])
	{
		int i;
		for(i=0; i<3; i++)
		{
			d1[i] = (pos[i]-org[i])/spa[i];
			ijk1[i] = (int)floor(d1[i]);
			d2[i] = d1[i] - ijk1[i];
			d1[i] = 1.0 - d2[i];

			if(periodic[i])
			{
				while(ijk1[i] < 0) ijk1[i] += dims[i];  // in case it is extended 
				while(ijk1[i] >= dims[i]) ijk1[i] -= dims[i];
			}
			else
			{
				if(ijk1[i] < 0) ijk1[i] = 0;  
				if(ijk1[i] >= dims[i]) ijk1[i] = dims[i] - 1;
			}

			ijk2[i] = ijk1[i] + 1;

			if(periodic[i])
			{
				while(ijk2[i] >= dims[i]) ijk2[i] -= dims[i]; 
			}
			else
			{
				if(ijk2[i] >= dims[i]) ijk2[i] = dims[i] - 1;
			}
		}
	}
};

