/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2011 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iconfigure.h"
#if ISHELL_INCLUDED(ISHELL_CL)


#include "iclcommandinterpreter.h"


#include "icontrolmodule.h"
#include "ierror.h"
#include "istring.h"

#include "iclinputchannel.h"
#include "iclshell.h"

#include <vtkIOStream.h>


using namespace iParameter;


iclCommandInterpreter::iclCommandInterpreter(iShell *s) : iCommandInterpreter(s)
{
	mInputChannel = iRequiredCast<iclShell>(INFO,this->GetShell())->GetInputChannel();
	mCache.Clear();
}


iclCommandInterpreter::~iclCommandInterpreter()
{
}


void iclCommandInterpreter::InternalCache::Clear()
{
	Text.Clear();
	Reset = Ready = false;
}


void iclCommandInterpreter::Initialize()
{
	this->DislayLineOfText("To execute entered commands, put a semi-colon at the end of the last one.",CommandInterpreterType::Result);
}


void iclCommandInterpreter::Finalize()
{
}


void iclCommandInterpreter::RunScript(const iString &text, bool reset)
{
	mCache.Text = text;
	mCache.Reset = reset;
	mCache.Ready = true;
}


void iclCommandInterpreter::CommitExec()
{
	if(mCache.Ready)
	{
		this->iCommandInterpreter::RunScript(mCache.Text,mCache.Reset);
		mCache.Clear();
	}
}


bool iclCommandInterpreter::IsReady()
{
	char c[2] = { 0, 0 };

	if(mCache.Ready) return true; // Do nothing until we are executed

	if(mLine.IsEmpty())
	{
			//
			//  Display prompt
			//
			cout << endl;
			cerr << ": ";
			mLine += " ";
	}

	while((c[0]=mInputChannel->NextChar()) != 0)
	{
		mLine += c;
		if(c[0] == '\n')
		{
			this->Append(mLine);
			mLine.Clear();
		}
	}

	return mCache.Ready;
}


void iclCommandInterpreter::DislayLineOfText(const iString &text, int) const
{
	cout << text.ToCharPointer() << endl;
}


void iclCommandInterpreter::AnalyseSpecialCommands(const iString &line)
{
	if(line.IsEmpty())
	{
		//
		//  If the line is empty, render the visualization windows
		//
		this->GetShell()->GetControlModule()->Render(RenderOption::All);
		return;
	}

	//
	//  Are we done?
	//
	if(line=="exit" || line=="quit")
	{
		this->GetShell()->Exit();
	}
}

#endif
