/* GNOME INPUT METHOD SWITCHER
 * Copyright 2003 Sun Microsystems Inc.
 *
 * This is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GNOME_IM_SWITCHER_H
#define __GNOME_IM_SWITCHER_H

#include <gnome.h>
#include <panel-applet.h>
#include "constraint-scaling.h"

typedef struct _QuickAccessMenu QuickAccessMenu;

struct _QuickAccessMenu 
{
  GtkWidget *widget;
  GtkWidget *vbox;
  GSList *active_languages;
};

typedef struct _GimletWindow GimletWindow;

typedef enum
{
  FOLLOW_APPLICATION,
#ifdef MEANINGLESS_OPTION_PERHAPS
  FOLLOW_CURRENT_LOCALE,
  FOLLOW_OPTION_MENU,
#endif
  FOLLOW_QUICK_ACCESS_MENU
} InputLanguagePolicy;

#define GIMLET_PALETTE_SIZE 10

typedef enum {
  ON_DESKTOP_PANEL,
  ATTACH_TO_APP_FRAME
} IMStatusPlacement;

struct _GimletWindow
{
  PanelApplet	*applet;
  GtkWidget	*about_dialog;
  GtkTooltips	*tooltips;

  gchar *base_iconname;
  PanelAppletOrient  orientation;
  ConstrainedPixbuf *c_pixbuf;
  GdkPixbuf *pixbuf;
  GtkWidget *applet_icon_area;	/* gtk image created from pixbuf */
  GdkRectangle prev_allocation;

  GtkWidget *push_button;
  GtkWidget *status_label;

  int fixed_width;
  int fixed_height;

  QuickAccessMenu *quick_access_menu;

  /* language selection dialog */
  GtkWidget *edit_languages_dialog;

  /* preference*/
  GtkWidget *edit_preferences_dialog;
#ifdef MEANINGLESS_OPTION_PERHAPS
  GtkWidget *input_language_option_menu;
  gchar *iiim_lang_in_option_menu;
#endif

  PangoFontDescription *menu_font;
  PangoFontDescription *status_font;
  GdkColor	foreground;
  GdkColor	background;

  guint textwidth;

  guint showtext : 1;
  guint showicon : 1;
  guint use_theme_font : 1;
  guint use_theme_colors : 1;
  guint conversion_on_start : 1;
  InputLanguagePolicy input_lang_policy;

  /* communitcations with IIIM clients */
  GtkWidget *invisible;
  GdkAtom  selection;
  GdkAtom  set_current_input_language_atom;
  GdkAtom  set_current_client_atom;
  GdkAtom  set_status_text_atom;
  GdkAtom  set_input_language_list_atom;
  GdkAtom  set_language_engine_list_atom;
  GdkAtom  set_conversion_mode_atom;

  /* input method settings */
  gboolean im_enabled;
  gboolean status_enabled;
  gboolean lookup_enabled;
  IMStatusPlacement status_placement;

  /* fix me, the next three should be per client */
  GdkWindow *last_client;
  gchar *current_iiim_lang;
  gchar **client_lang_list;

  gchar *le_list;
};

#endif /* __GNOME_IM_SWITCHER_H */
