/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/


package sun.awt.im.iiimp;

import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import java.util.Locale;
import java.util.StringTokenizer;
import java.awt.AWTEvent;
import java.awt.event.KeyEvent;
import java.awt.im.InputContext;
import com.sun.iiim.*;

/**
 * Primary Composition Editor -
 * configurable Light Weight Engine which accept
 * LWESyntax as it's composition rule.
 */

public class PCE extends LWE {

    private Stack syntaxStack;
    private Hashtable icTable;
    private LWESyntax syntax;
    
    public void dispatchEvent(IIIMEvent e) {

	SyntaxOnOff syntaxOnOff = null;

	InputContext ic = getInputContext();
	if (ic == null) {
	    return;
	}
	
	if (icTable.size() == 0) {
	    syntax = (LWESyntax)syntaxStack.peek();
	    if (syntax == null) {
		return;
	    }
	    syntaxOnOff = new SyntaxOnOff(syntax);
	    icTable.put(ic, syntaxOnOff);
	} else {
	    if (icTable.containsKey(ic)) {
		syntaxOnOff = (SyntaxOnOff)icTable.get(ic);
	    } else {
		syntax = syntax.getCopy();
		syntaxOnOff = new SyntaxOnOff(syntax);
		icTable.put(ic, syntaxOnOff);
	    }
	}

	if (!syntaxOnOff.willProcess(e)) {
	    // Conversion Off Mode
	    return;
	}
	if (e.isConsumed()) {
	    // This e is trigger key
	    return;
	}

	IIIMEvent[] events = null;
	try {
	    events = syntax.getEventList(e);
	} catch(InvalidSyntaxException ex) {
	    if (Manager.DEBUG) {
		ex.printStackTrace();
	    }
	}

	e.consume();
	
	if (events != null) {
	    for (int i = 0; i < events.length; i++) {
		markProcessedUpperListener(events[i], this);
		int id = events[i].getID();
		switch(id) {
		  case IIIMEvent.ACTION:
		    debug(" action = " + ((IIIMActionEvent)events[i]).getAction());
		    dispatchActionEvent((IIIMActionEvent)events[i]);
		    break;
		  case IIIMEvent.COMMITTED:
		    dispatchCommittedEvent((IIIMCommittedEvent)events[i]);
		    break;
		  case IIIMEvent.PREEDIT:
		    dispatchPreeditEvent((IIIMPreeditEvent)events[i]);
		    break;
		  default:
		    debug(" LWESyntax procudes unknown event...");
		}
	    }
	}
    }

    public String getName() {
	return "PCE";
    }

    public IIIMEvent[] getTriggerEvent() {
	return triggerOns;
    }

    public IIIMEvent[] getTriggerOffEvent() {
	return triggerOffs;
    }

    public String[] getEngineSctipt() {
	return new String[] {"Japanese", "Chinese"};
    }

    /**
     * Manager will create the instance of this class
     * with default LWESyntax.
     */
    public PCE() {
	syntaxStack = new Stack();
	icTable = new Hashtable();
	if (!initTrigger) {
	    setupTriggerEvents();
	}
    }

    public void pushSyntax(LWESyntax syntax) {
	syntaxStack.push(syntax);
	icTable.clear();
    }

    public LWESyntax popSyntax() {
	LWESyntax syntax = (LWESyntax)syntaxStack.pop();

	return syntax;
    }

    private static final String defaultTrigger = "key<Control+P>";
    private static IIIMEvent[] triggerOns, triggerOffs;
    private static boolean initTrigger = false;

    /*
     * Trigger string representation is
     * key<modifier+..+keyname> or action<actioname>.
     * More than one trigger can be represented with delimiter ',' or ':'.
     * For example in ~/.iiimp propery file
     *     iiimf.pce.trigger.on = key<Control+Space>,action<PCETriggerOn>
     */
    private static void setupTriggerEvents() {
	initTrigger = true;

	String trigger =
	    Manager.getProperty("iiimf.pce.trigger", defaultTrigger);
	String triggerOn =
	    Manager.getProperty("iiimf.pce.trigger.on", defaultTrigger);
	String triggerOff
	    = Manager.getProperty("iiimf.pce.trigger.off", defaultTrigger);
	
	String onString = trigger.equals(triggerOn) ?
	    trigger : trigger + "," + triggerOn;
	triggerOns = makeIIIMEvents(onString);

	if (triggerOn.equals(triggerOff)) {
	    triggerOffs = triggerOns;
	} else {
	    String offString = trigger.equals(triggerOff) ?
		trigger : trigger + "," + triggerOff;
	    triggerOffs = makeIIIMEvents(offString);
	}
    }

    private static IIIMEvent[] makeIIIMEvents(String triggers) {
	StringTokenizer ston = new StringTokenizer(triggers, ",:");
	Vector vector = new Vector();
	while(ston.hasMoreTokens()) {
	    String trigger = ston.nextToken();
	    int lastIndex = trigger.lastIndexOf('>');
	    if (lastIndex < 4)
		// ignore wrong representation
		continue;
	    if (trigger.startsWith("key<")) {
		String key = trigger.substring(4, lastIndex);
		vector.add(new IIIMKeyEvent(key));
	    } else if (trigger.startsWith("action<")) {
		if (lastIndex <= 7)
		    continue;
		String action = trigger.substring(7, lastIndex);
		vector.add(new IIIMActionEvent(action));
	    }
	}
	IIIMEvent[] iea = new IIIMEvent[vector.size()];
	for (int i = 0; i < iea.length; i++) {
	    iea[i] = (IIIMEvent)vector.elementAt(i);
	}
	return iea;
    }

    class SyntaxOnOff {

	private LWESyntax syntax;
	private boolean on = false;


	// KEY_TYPED event does not hold modifier information
	// so this variable is needed...
	private boolean controlDown = false;

	SyntaxOnOff(LWESyntax syntax) {
	    this.syntax = syntax;
	    on = false;
	}

	LWESyntax getSyntax() {
	    return syntax;
	}

	boolean willProcess(IIIMEvent e) {
	    if (on) {
		return checkTrigger(e, triggerOffs);
	    } else {
		return checkTrigger(e, triggerOns);
	    }
	}

	boolean checkTrigger(IIIMEvent e, IIIMEvent[] triggers) {
	    AWTEvent ae = e.getAWTEvent();
	    if (ae != null && ae instanceof KeyEvent) {
		KeyEvent ke = (KeyEvent)ae;
		int id = ke.getID();
		for (int i = 0; i < triggers.length; i++) {
		    if (triggers[i] instanceof IIIMKeyEvent) {
			if (((IIIMKeyEvent)triggers[i]).match(ke)) {
			    e.consume();
			    if (id == KeyEvent.KEY_RELEASED) {
				on = !on;
			    }
			    break;
			}
		    }
		}
	    }
	    return on;
	}
    }

    public Locale[] getSupportLocales() {
	return null;
    }
    
    private void debug(String str) {
	if (Manager.DEBUG) {
	    System.err.println(str);
	}
    }
}
