#ifndef IMSVRCFGFILE_HH_
#define IMSVRCFGFILE_HH_
#include <string>
#include <map>
#include <list>
#include "basictype.hh"
#include "IMSvrCfg.hh"

class IMSvrCfgFile : public IMSvrCfg
{
  public:
    typedef list<string> DirArgs;
    typedef bool (IMSvrCfgFile::*DirHandler)(DirArgs &args);

  private:
    IMSvr* ptarget;
    string filename;

    struct Directive {
	int argsnum;
	DirHandler h;
    };
    typedef map<const char*, Directive, Functor_strcmp> DirectiveMap;
    DirectiveMap dirmap;

    IMSocketAddressVec listenaddrvec;
    bool add_listen_file(
	DirArgs &args
    );
    bool add_listen_address(
	DirArgs &args
    );
    bool set_access_control(
	DirArgs &args
    );
    bool set_default_permission(
	DirArgs &args
    );
    bool set_allow_system_user(
	DirArgs &args
    );
    bool set_user_permission(
	DirArgs &args
    );
    bool add_ssl_listen_address(
        DirArgs &args
    );
    bool add_ssl_listen_file(
        DirArgs &args
    );
    bool add_certificate_file(
        DirArgs &args
    );
    bool add_certificate_keyfile(
        DirArgs &args
    );
    bool add_cacertificate_file(
        DirArgs &args
    );
    bool add_cacertificate_path(
        DirArgs &args
    );
    bool set_verify_client(
        DirArgs &args
    );
    bool set_verify_depth(
        DirArgs &args
    );

    void adddir(
	const char *dir,
	DirHandler h,
	int argsnum
    );
    IMAuth::access_type get_access_type(string &key);
    bool readconfig();
    void initialize();

  public:
    virtual bool configure(
	IMSvr *pimsvr
    );
    IMSvrCfgFile(
	IMSvrCfg *pbase,
	const char *x_filename
    );
    virtual ~IMSvrCfgFile() {};
};

#endif /* not IMSVRCFGFILE_HH_ */

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
