/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include "xiiimp.h"
#include "guiIMSts.h"
#include "XimpIm.h"

/* ChangeStatus Methods */
static void
create(XicCommon ic, XPointer call_data) {
  StatusWin status = (StatusWin)(ic->gui_icpart->status);
  XWindowAttributes attr;

  if (!(ic->ximp_icpart->value_mask & XIMP_CLIENT_WIN)) return;

  if (!status) {
    SetupStatusExt(ic);
    status = (StatusWin)(ic->gui_icpart->status);
  }

  if (status->parent != 0) {
    /* status window is already created  */
    return;
  }
  if (XGetWindowAttributes(ic->core.im->core.display, 
			   ic->core.client_window,
			   &attr) > 0) {
    if (attr.map_state == IsUnmapped) {
      /* not yet ready to create status window */
      return;
    }
    SetupStatusWindow(ic, ic->core.client_window);
  }
  return;
}

static void
set_window(XicCommon ic, XPointer call_data) {
  StatusWin status = (StatusWin)(ic->gui_icpart->status);
  CacheRec *status_cache;

  if (!XIMP_CHK_STSAREAMASK(ic) ||
      ic->core.status_attr.area.width == 0 ||
      ic->core.status_attr.area.height == 0)
    return;

  if (!status) {
    create(ic, NULL);
    status = (StatusWin)(ic->gui_icpart->status);
    if (!status) return;
  }

  status_cache = (CacheRec*)&(status->status_cache);

  if (status_cache->win_x == ic->core.status_attr.area.x &&
      status_cache->win_y == ic->core.status_attr.area.y &&
      status_cache->win_width == ic->core.status_attr.area.width &&
      status_cache->win_height == ic->core.status_attr.area.height &&
      status_cache->font_set == status->fontset) {
    return;
  }
      
  status->x = 0;

  if (!status->fontset) {
    SetStatusFont(ic, NULL);
  }
  if (status->fontset) {
    XFontSetExtents *fse;
    int height_diff;
    fse = XExtentsOfFontSet(status->fontset);
    height_diff =
	    (ic->core.status_attr.area.height - fse->max_ink_extent.height);
    height_diff += (height_diff & 1);
    status->y = ((-fse->max_ink_extent.y) + (height_diff / 2));
  } else {
    status->y = ic->core.status_attr.area.height;
  }

  if (!status->window)
    SetupStatusWindow(ic, ic->core.client_window);
  if (status->window)
    XMoveResizeWindow(ic->core.im->core.display,
		      status->window,
		      ic->core.status_attr.area.x,
		      ic->core.status_attr.area.y,
		      ic->core.status_attr.area.width,
		      ic->core.status_attr.area.height);
  /* data cache */
  status_cache->win_x = ic->core.status_attr.area.x;
  status_cache->win_y = ic->core.status_attr.area.y;
  status_cache->win_width = ic->core.status_attr.area.width;
  status_cache->win_height = ic->core.status_attr.area.height;
  status_cache->font_set = status->fontset;

  return;
}

static void
HideStatus(XicCommon ic, XPointer call_data) {
  /* nothing to do in StatusArea input style */
  return;
}

static StatusCB status_area_methods[] = {
  create,			/* STATUS_CREATE */
  set_window,			/* STATUS_WIN */
  SetStatusForeground,		/* STATUS_FG */
  SetStatusBackground,		/* STATUS_BG */
  SetStatusFont,		/* STATUS_FONT */
  StatusStart,			/* STATUS_START */
  StatusDrawText,		/* STATUS_DRAW */
  StatusDone,			/* STATUS_DONE */
  DestroyStatus,		/* STATUS_DESTROY */
  HideStatus			/* STATUS_HIDE */
};

/* Public function */
void
ChangeStatusArea(XIC xic, StatusAttr reason, XPointer call_data) {
  XicCommon ic = (XicCommon)xic;
  if (reason > STATUS_HIDE) return;
  status_area_methods[reason](ic, call_data);
  return;
}

