/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#ifndef _CIKU_OPER_H
#define _CIKU_OPER_H

#include "GeneType.h"
#include "PyBasic.h"

#define MAX_CIZU_ITEMS     64000
#define CIZU_ITEM_LEN        126
#define MAX_CIZU_HZ_NUM        9

#define ENUM_FULL              4
#define ENUM_SIMP              0
#define ENUM_SIMP_W            1

#define F_PRINT                1
#define F_NOPRINT              0

#define READ_RAW_CIZU          1
#define READ_SORTED_CIZU       2

#define SINGLEHZ_DSP_NONE      0
#define SINGLEHZ_DSP_SIMP      1
#define SINGLEHZ_DSP_FULL      2


typedef struct _CizuItem {
	UCHAR     szLine[CIZU_ITEM_LEN];           /* Org Line read from file */
	UCHAR     szHz[2 * MAX_CIZU_HZ_NUM];
	UCHAR     szHz2244[2 * MAX_CIZU_HZ_NUM];   /* Notice: may also contain 0x2001 ~ 0x2244, means DuoYinZi */
	JINT      nHzNum;
	JINT      nYj[MAX_CIZU_HZ_NUM];            /* nHzNum may be diff from nYjNum */
	JINT      nYjNum;
	JINT      nFreq;
	JINT      nbIsXianForm;
	JINT      nbIsFanganForm;
	JINT      nbIsEnaoForm;
	JINT      nXianFormYj[MAX_CIZU_HZ_NUM];
	JINT      nFanganFormYj[MAX_CIZU_HZ_NUM];
} CizuItem;		/* Max Array Size is MAX_CIZU_ITEMS(64000) */


typedef struct _SingleHanziByYj {
	UCHAR     szHanzi[256];
	JINT      nHzNum;                          /* don't include nXianFormNum */
	JINT      nXianFormNum;
	UCHAR     szXianFormList[64];              /* Seperated by 0x0909 */
} SingleHanziByYj;  /* Max Array Size is NUM_YINJIE(415) */


/* 1300: beacause "yi" have max nNumFirstYjIs = 1019 */
typedef struct _CizuGroupByYj {
	JINT      nNumFirstYjIs;                /* Number of Cizu which start by this Yinjie Code */
	JINT      nNum2ndYjIs[NUM_YINJIE];      /* Number of Cizu whose second Yinjie is 0~414. Sum of this array is nNumFirstYjIs */
	JINT      nIdxItem[1300];               /* Index to CizuItem, sorted by nNum2ndYjIs, include also nFanganForm */
	JINT      nIdxFanganItem[60];           /* Index to CizuItem which is a Fangan Form, sorted by nIdxItem[1300] */
	JINT      nSizePureCizu;                /* Pure Hanzi Number by this Yinjie. Space is 2 * nSizePureCizu */
} CizuGroupByYj;      /* Max Array Size is NUM_YINJIE(415) */

typedef struct _CikuHeader {
	JINT      nMagicDescHi;     /* "PY" ==> 0x5059 ==> 0x35303539 */
	JINT      nMagicDescLow;    /* "CK" ==> 0x434B ==> 0x34333442 */
	JINT      nSize;            /* Size of this structure: 128 */
	JINT      nFileSize;        /* Size of this file */
	CHAR      szName[32];       /* Name of this ciku file */
	CHAR      szCopyright[48];  /* Copyright info of this file */
	JINT      nVersion;         /* Hi(nVersion) is main version, Low() is reversion */
	JINT      nLatestTime;      /* Last Create time by seconds from 1970.1.1.0.0.0 */
	JINT      nIdxShPos;        /* Index Position from file header of Single Hanzi */
	JINT      nIdxDhPos;        /* Index Position from file header of Double Hanzi */
	JINT      nIdxMhPos;        /* Index Position from file header of Multi Hanzi  */
	JINT      nIdxGbkPos;       /* Index Position from file header of GBK Single Hanzi. MXL 97.12.21 */
	JINT      nReserve2;        /* Reserves(2.3) for future development */
	JINT      nReserve3;
} CikuHeader;
			
typedef struct _ShIndex {       /* SINGLE HANZI */
	JINT      nSize;            /* Size of this structure */
	JINT      nStartPos;        /* First position of Single Hanzi Data Area */
	JINT      nEndPos;          /* End position of Single Hanzi Data Area */
	JINT      nYjOff[NUM_YINJIE + 1];  /* Offset of each Yj relative to this nStartPos  */
} ShIndex;

typedef struct _DhIndex {       /* DOUBLE HANZI CIZU */
	JINT     nSize;
	JINT     nStartPos;
	JINT     nEndPos;
	JINT     nYjOff[NUM_YINJIE + 1];   /* Offset of each Yj relative to this nStartPos */
} DhIndex;

typedef struct _MhIndex {       /* MULTIPLE HANZI CIZU ( > 3 ) */
	JINT     nSize;
	JINT     nStartPos;
	JINT     nEndPos;
	JINT     nYjOff[NUM_YINJIE + 1];  /* Offset of each Yj relative to this nStartPos */
} MhIndex;

typedef struct _GbkIndex {      /* Single Hanzi of Only GBKKKK!! */
	JINT     nSize;
	JINT     nStartPos;
	JINT     nEndPos;
	JINT     nYjOff[NUM_YINJIE + 1];   /* Offset of each Yj relative to this nStartPos */
} GbkIndex;

typedef struct _SysCandi {      /* Candidates come from System Ciku */
	                            /* SINGLE HANZI WAS SORTED BY FREQUENCE */
	JINT    nOrgYj[9];          /* Original YinjieCode Array of 0~414 & 450~475 */
	JINT    nLenYj;
	JINT    nNumShCandi;        /* Number of Single Hanzi Candidates, High 8 bits indicates XianNum */
	JINT    nSizShCandi;        /* In JWORD */
	JWORD*  pwShCandi;          /* Pointer of Single Hanzi Area : Encoded in GB2244 */

	JINT    nNumDhCandi;        /* Number of Double Hanzi Candidates */
	JINT    nSizDhCandi;        /* In JWORD */
	JWORD*  pwDhCandi;          /* Pointer of Double Hanzi Area:  Encoded in GB2244, sorted by Freq, with
	                               a Word (Not Byte!!!) in front of each Candi to indicates Frequence */

	JINT    nNumMhCandi;        /* Number of Multiple Hanzi Candidates */
	JINT    nSizMhCandi;        /* In JWORD */
	JWORD*  pwMhCandi;          /* Pointer of Multiple Hanzi Area: Encoded in GB2244, Sorted by Length and Freq,
	                            ** With a word (Not Byte!!!) in front of each Candi to indicates Length and Freq!
	                            ** Contain a 0x0000 in the end of each candidate. */

	JINT    nNumGbkCandi;       /* Number of GBK Single Hanzi Candidates */
	JINT    nSizGbkCandi;       /* In JWORD */
	JWORD*  pwGbkCandi;         /* Pointer of GBK Single Hanzi Area */
} SysCandi;


/* nMode */
#define LU_CANDI_CALC       1
#define LU_CANDI_WRITE      2

/* nMatchMode */
#define LU_MATCH_STRICT     1
#define LU_MATCH_WIDELY     2

/* Not Existing in either System or User Defined Ciku */
#define NON_EXIST_CIZU      0
/* Existing in System Ciku */
#define SYS_EXIST_CIZU      1
/* Existing in User Defined Ciku */
#define UDC_EXIST_CIZU      2

#ifndef _DRAW_IM_WIN_H
static  CHAR   szSysCiku_Gb[]  = "/../locale/zh_CN/newpy/data/PyCiku.dat";
static  CHAR   szSysCiku_Gbk[] = "/../locale/zh_CN/newpy/data/PyCiku.dat";
static  CHAR   szSysCiku_Gbk_WIN32[] = "\\..\\locale\\zh_CN\\newpy\\data\\PyCiku.dat";
#else
static  CHAR   szSysCiku_Gb[]  = "PyCiku.dat";
static  CHAR   szSysCiku_Gbk[] = "PyCiku.dat";
#endif

static  CHAR   szSysCikuBak[]  = "/PyCiku.dat";


/*****************************************************************************************
********************                                          ****************************
******************** Following is Definition for UdCikuOper.c ****************************
********************                                          ****************************
*****************************************************************************************/

/* Minimum Unit for Udc Data */
#define    UDCMEM_ALIGN      128

typedef struct _UdCikuHeader {
	JINT      nMagicDescHi;     /* "PY" ==> 0x5059 ==> 0x35303539 */
	JINT      nMagicDescLow;    /* "CK" ==> 0x434B ==> 0x34333442 */
	JINT      nSize;            /* Size of this structure: 128 */
	JINT      nFileSize;        /* Size of this file */
	CHAR      szName[32];       /* Name of this ciku file */
	CHAR      szCopyright[48];  /* Copyright info of this file */
	JINT      nVersion;         /* Hi(nVersion) is main version, Low() is reversion */
	JINT      nLatestTime;      /* Last Create time by seconds from 1970.1.1.0.0.0 */
	                            /* Spec Hanzi include UDSINGLEHZ which defined in <PyBasic.h> */
	JINT      nSpecHzStartPos;  /* Offset of SpecHz Data Area */
	JINT      nSizeSpecHz;      /* 2048 is ENOUGH!! */
	JINT      nIdxUdcPos;       /* Index Position from file header of Multi Hanzi */
	JINT      nReserve1;        /* Reserves(1.2.3) for future development */
	JINT      nReserve2;
	JINT      nReserve3;
} UdCikuHeader;
			

typedef struct _UdcIndex {      /* Index of User Defined Cizu */
	JINT     nSize;          
	JINT     nStartPos;
	JINT     nEndPos;
	JINT     nYjOff[NUM_YINJIE + 1];  /* Offset of each Yj relative to this nStartPos */
} UdcIndex;


typedef struct _UdcMemAll {     /* Structure of All Udc Data in Memory */
	UdCikuHeader    udcfh;
	UdcIndex        udci;
	JWORD          *pwUdcSh;
	JWORD          *pwUdc28[NUM_YINJIE];
} UdcMemAll;


typedef struct _UdcCandi {      /* Candidates come from User Defined Ciku */
	JINT    nNumSpecCandi;      /* Number of SpecHz Candi. */
	JWORD   pwSpecCandi[6];     /* 6 is enough!! */

	JINT    nNumUdc28Candi;     /* Number of UdCandi which length in 2 ~ 8 */
	JINT    nSizUdc28Candi;     /* In JWORD */
	JWORD*  pwUdc28Candi;       /* Pointer of Udc28 Area: Encoded in GB2244, Sorted by Length and Freq,
	                            ** With a word (Not Byte!!!) in front of each Candi to indicates Length and Freq!
	                            ** Contain a 0x0000 in the end of each candidate.
	                            */
} UdcCandi;

#ifndef _DRAW_IM_WIN_H
static  CHAR   szUdcCiku_Gb[]  = "/../locale/zh_CN/newpy/data/UdCiku.dat";
static  CHAR   szUdcCiku_Gbk[] = "/../locale/zh_CN/newpy/data/UdCiku.dat";
static  CHAR   szUdcCiku_Gbk_WIN32[] = "\\..\\locale\\zh_CN\\newpy\\data\\UdCiku.dat";
#else
static  CHAR   szUdcCiku_Gb[]  = "UdCiku.dat";
static  CHAR   szUdcCiku_Gbk[] = "UdCiku.dat";
#endif

static  CHAR   szUdcCikuBak[]  = "/UdCiku.dat";

#endif   /* End of _CIKU_OPER_H */


