/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include "XSunExt.h"

#ifndef _XAuxMethod_h
#define _XAuxMethod_h

typedef struct _XAuxAttribute {
	int      nAttrID;
	int      nLenName;
	char    *pszName;
	int      nLenValue;
	void    *pvValue;
	int      nType;
} XAuxAttribute;


typedef struct _XAuxCallbackStruct{
	char    *pszEngName;                /* Point to Engine Name     */
	int      nEngClsIdx;                /* Engine Class Index       */
	int      nNumIntVal;                /* Count Integer Values     */
	int     *pnIntVal;                  /* Point to Integer Values  */
	int      nNumStrVal;                /* count String Values      */
	char    *pszStrVal;                 /* Point to String Values   */
} XAuxCallbackStruct;                   /* Acbs */


typedef struct _xaux_methods {
	Bool    (*xaux_Create)(int, XAuxAttribute *, int);
	Bool    (*xaux_Start)(int, XIMAuxStartCallbackStruct *);    /* Added by Scott Ma, 05/26, 98 */
	Bool    (*xaux_Draw)(int, XIMAuxDrawCallbackStruct *);
	Bool    (*xaux_Done)(int, XIMAuxDoneCallbackStruct *);     /* Added by Scott Ma, 05/26, 98 */
	Bool    (*xaux_SetFocus)(int);
	Bool    (*xaux_UnsetFocus)(int);
	Bool    (*xaux_SetValues)(int, XAuxAttribute *, int);
	Bool    (*xaux_GetValues)(int, XAuxAttribute *, int);
	Bool    (*xaux_Destroy)(int);
} xaux_methods_t ;


/* Functions to be exported */
Bool XAux_Create   (int, XAuxAttribute *, int);
Bool XAux_SetValues(int, XAuxAttribute *, int);
Bool XAux_GetValues(int, XAuxAttribute *, int);

Bool XAux_Start(int, XIMAuxStartCallbackStruct *);     /* Added by Scott Ma, 05/26, 98 */
Bool XAux_Draw (int, XIMAuxDrawCallbackStruct *);
Bool XAux_Done (int, XIMAuxDoneCallbackStruct *);     /* Added by Scott Ma, 05/26, 98 */

Bool XAux_SetFocus  (int);
Bool XAux_UnsetFocus(int);
Bool XAux_Destroy   (int);

#define XAUX_DISPLAY            1
#define XAUX_SCREENNUM          2
#define XAUX_HTTWINDOW          3
#define XAUX_FONTSET            4
#define XAUX_AREA               5
#define XAUX_AREANEEDED         6
#define XAUX_COLORMAP           7
#define XAUX_STDCOLORMAP        8
#define XAUX_FOREGROUND         9
#define XAUX_BACKGROUND         10
#define XAUX_BACKGROUNDPIXMAP   11
#define XAUX_LOCATION           12
#define XAUX_FONTNAME           13
#define XAUX_CURSOR             14
#define XAUX_REPLYCALLBACK      15
#define XAUX_REPLYCLIENTDATA    16
#define XAUX_GC                 17
#define XAUX_TOPLEVEL                 18


/*
** _XAux_SesDspParaNode structure
**        Session_Display Parameters Node (sdpn)
*/
typedef struct _XAux_SesDspParaNode {
	int         nIcID;
	Display    *pDsp;
	int         nScreenNum;
	Window      wndHttWin;
	XFontSet    xfsFontSet;
	XRectangle  rectArea;
	XRectangle  rectNeeded;
	Colormap    cmap;
	Colormap    cmapStd;
	unsigned long  fgPix;      /* foreground pixel */
	unsigned long  bgPix;      /* background pixel */
	                           /* bgPixmap is omitted!! - Scott Ma */
	xPoint      xyPointLoc;    /* defined in Xprotostr.h: INT16 x, y; */
	char       *pszFontName;
	                           /* Cursor is omitted!! - Scott Ma */
	void      (*fpReplyCb)();  /* Reply Callback */
	void       *pbReplyData;   /* Reply Client Data */
	GC          gc;
	
	/* Following 4 elements are not set by SetAuxNodeValues()!! */
	int         nWndStatus;    /* Is this window mapped or unmapped? */
	Window      wndIM;
	Window      wndBmp1;
	Window      wndBmp2;
	                           /* Direct Child of RootWindow */
	Window      wndParent;     /* Parent Window of wndBmp1 and wndBmp2 */
	
	int         nPuncState;    /* 0, 1, ChinesePunc / EnglishPunc  */
	int         nSkbState;     /* 0~14, SoftKB State, Default 13, HalfWid */
	
	struct     _XAux_SesDspParaNode  *next;
} XAux_SesDspParaNode;


#endif   /* XAuxMethod_h */
