/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#ifndef	XAUX_EXT_COMMON_PRIV_H
#define	XAUX_EXT_COMMON_PRIV_H

#pragma ident	"$Id$"

#define	XAUX_EXT_NATOMS_READLIST	XAUX_MAXNPROPS_INIT

/* conversion utilities */
extern size_t utf16_mb(const char **, size_t *, char **, size_t *);
extern size_t mb_utf16(const char **, size_t *, char **, size_t *);

/* 1MB */
#define	XAUX_EXT_MAXPROPQDATASZ		0x100000U

#define	XAUX_EXT_MAXNPROPS		XAUX_MAXNPROPS_INIT

#define	XAUX_EXT_MAXDEPTH		4

typedef struct xaux_ext_class_struct {
	const char	*classname;	/* aux_name */
	char		*shortname;	/* short version of class name */
	int		index;		/* aux_index */
	Window		sowin;		/* aux.so's window */
	Window		extwin;		/* aux_ext's window */
	Atom		atom_classname;	/* "${CLASSNAME}" */
	Atom		atom_sowin;	/* "${CLASSNAME}_sowin" */
	Atom		atom_extwin;	/* "${CLASSNAME}_extwin" */
	Atom		atom_sx;	/* "${CLASSNAME}_sx" */
	Atom		atom_xs;	/* "${CLASSNAME}_xs" */
	xaux_atommng_data_t	*atommng_data;	/* atommng data */
	int		depth;		/* current depth of nested call */
	int		maxnprops;	/* max # of props in *props array */
	Atom		*props;		/* props to read */
	xaux_propq_t	*propq;		/* outgoing property queue */
} xaux_ext_class_t;

typedef struct xaux_ext_priv_struct {
	xaux_ext_class_t		class;
	xaux_ext_cb_start_t		cb_start;
	void *				cb_start_data;
	xaux_ext_cb_draw_t		cb_draw;
	void *				cb_draw_data;
	xaux_ext_cb_done_t		cb_done;
	void *				cb_done_data;
	xaux_ext_cb_addevhandler_t	cb_addevhandler;
	void *				cb_addevhandler_data;
	xaux_ext_cb_rmevhandler_t	cb_rmevhandler;
	void *				cb_rmevhandler_data;
	Display				*dpy;
	Bool				do_mbconv;
} xaux_ext_priv_t;

#endif	/* !XAUX_EXT_COMMON_PRIV_H */
