/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xmd.h>
#include <Xm/Xm.h>

#include "xaux_locale.h"
#include "xaux_common.h"
#include "xaux_ext_common.h"
#include "hzinput.h"
#include "OptionConfig.h"

/* Define Aux class */
xaux_class_t *xc_ = 0;
int im_ = 0;
int ic_ = 0;

/* Define Aux class */
xaux_class_t xaux_class = {
	XAUX_OPTION_CLASS_NAME, 1,
	NULL,
	(Window)0, (Window)0,
	(Atom)0, (Atom)0, (Atom)0,
	{ (Atom)0 }, ATOM_NUM_OPTIONAUX, 0,
	{ (Atom)0 }, ATOM_NUM_OPTIONAUX, 0,
	NULL,
};

extern Display          *gDisplay;
extern char             gLocaleID;

extern int 		gIMEOptionsNum;
extern IMEOption_Item	*gIMEOptions[MAX_ENGINE_NUM];
 		
void xaux_ext_event_handler(Widget, XtPointer, XEvent *, Boolean *);
void OptionAux_Connect_To_LE_Request();
void OptionAux_Proc_LE_Notify();
void OptionAux_Proc_LE_Show_Notify();
void OptionAux_Proc_LE_Update_Args_New_Notify(aux_ext_data_t *aux_ext_data);
void OptionAux_Proc_LE_Update_Args_Info_Notify(aux_ext_data_t *aux_ext_data);
void OptionAux_Proc_LE_Change_Focus_Notify(aux_ext_data_t *aux_ext_data);

/*   
	Event Handler 
*/
void xaux_ext_event_handler(Widget w, XtPointer client_data, XEvent * event, Boolean * b)
{
	switch (event->type) {
		case ClientMessage:
			xaux_ext_process_client_message(XtDisplay(w),
				(XClientMessageEvent *) event);
			break;
	}
	return;
}

/*
	xaux_ext_init_classes(): Initialize the Atom of Auxiliary Window.
	It is in ../xaux_common/xaux_ext_common.c
*/
int xaux_ext_register_classes(Widget shell)
{
	/* Register aux class */
	if (xaux_ext_init_classes(XtDisplay(shell), &xaux_class, XtWindow(shell)) == False)
		return(-1);

	/* Register event handler */
	XtAddEventHandler(shell, PropertyChangeMask, False,
		xaux_ext_event_handler, NULL);
	XtAddEventHandler(shell, NoEventMask, True,
		xaux_ext_event_handler, NULL);

	return(0);
}

/* 
Note:
     xaux_ext_Start(), xaux_ext_Draw(), xaux_ext_Done() 
     These three functions are all called by xaux_ext_process_client_message()

     xaux_ext_SetValue() will send auxiliary window information to language engine;
*/

/* Method - Start */
Bool xaux_ext_Start(xaux_class_t *xc, aux_ext_data_t *aux_ext_data)
{
	DEBUG_printf("ext_Start: im:%d, ic:%d\n", aux_ext_data->im, aux_ext_data->ic);
	im_ = aux_ext_data->im;
	ic_ = aux_ext_data->ic;
	xc_ = xc;

/*
	OptionAux_Connect_To_LE_Request(gLocaleID);
*/
	return True;
}

/* Method - Draw */
Bool xaux_ext_Draw(xaux_class_t *xc, aux_ext_data_t *aux_ext_data)
{
	DEBUG_printf("ext_Draw == im:0x%x, ic:0x%x\n",aux_ext_data->im, aux_ext_data->ic);
	im_ = aux_ext_data->im;
	ic_ = aux_ext_data->ic;
	xc_ = xc;

        OptionAux_Proc_LE_Notify(aux_ext_data);
	return True;
}

/* Method - Done */
Bool xaux_ext_Done(xaux_class_t *xc, aux_ext_data_t *aux_ext_data)
{
	DEBUG_printf("ext_Done im:0x%x, ic_id:0x%x\n", aux_ext_data->im, aux_ext_data->ic);
	return True;
}


/* ================================================================= */
/*       Process Notify information From Language Engine             */
/* ================================================================= */
void OptionAux_Proc_LE_Notify(aux_ext_data_t *aux_ext_data)
{
	int nIntegerCount, notifyType;

	nIntegerCount = aux_ext_data->integer_count;
	if (nIntegerCount <= 0) return;

	notifyType = aux_ext_data->integer_list[0];

	switch (notifyType)
	{
		case OPTIONAUX_UPDATE_ARGS_NEW_NOTIFY:
			DEBUG_printf("OPTIONAUX_UPDATE_ARGS_NEW_NOTIFY Notify Received\n");
			OptionAux_Proc_LE_Update_Args_New_Notify(aux_ext_data);
			break;
		case OPTIONAUX_UPDATE_ARGS_INFO_NOTIFY:
			DEBUG_printf("OPTIONAUX_UPDATE_ARGS_INFO_NOTIFY Notify Received\n");
			OptionAux_Proc_LE_Update_Args_Info_Notify(aux_ext_data);
			break;
		case OPTIONAUX_SHOW_NOTIFY:
			DEBUG_printf("OPTIONAUX_SHOW_NOTIFY Notify Received\n");
			OptionAux_Proc_LE_Show_Notify(aux_ext_data);
			break;
		case COMMONAUX_CHANGE_FOCUS_NOTIFY:
			DEBUG_printf("COMMONAUX_CHANGE_FOCUS_NOTIFY Notify Received\n");
			OptionAux_Proc_LE_Change_Focus_Notify(aux_ext_data);
			break;
	}
}

void OptionAux_Proc_LE_Update_Args_New_Notify(aux_ext_data_t *aux_ext_data)
{
	OptionsList_Free();
}

void OptionAux_Proc_LE_Update_Args_Info_Notify(aux_ext_data_t *aux_ext_data)
{
	int i, nIntegerCount, nStringCount;
	IMEOption_Item pOptionItem;
	int opt_value = 0;
	int arg_value;
	char *arg_name;

	nIntegerCount = aux_ext_data->integer_count;
	if (nIntegerCount <= 0) return;

	nStringCount = aux_ext_data->string_count;
	
	pOptionItem.ime_ename = (char *)(aux_ext_data->string_list[0].ptr);
	pOptionItem.ime_cname = (char *)(aux_ext_data->string_list[1].ptr);

	pOptionItem.args_list = (IMEArgListRec *)calloc(1, sizeof(IMEArgListRec));
	pOptionItem.args_list->args_num = aux_ext_data->integer_list[1];
	DEBUG_printf("Set options for IME: \n");
	DEBUG_printf("ename: %s, cname:%s\n", pOptionItem.ime_ename, pOptionItem.ime_cname);
	for (i=0; i<nStringCount - 2; i++) {
		int tmp_value = aux_ext_data->integer_list[2 * i + 2];
		int tmp_type  = aux_ext_data->integer_list[2 * i + 3];

		pOptionItem.args_list->args[i].name = (char *)(aux_ext_data->string_list[i+2].ptr);
		pOptionItem.args_list->args[i].value = tmp_value;
		pOptionItem.args_list->args[i].type = tmp_type;
		DEBUG_printf("Name:%s, value:%d, type: %d\n", pOptionItem.args_list->args[i].name, tmp_value, tmp_type);
	}

	Add_OptionItem_To_List(&pOptionItem);
	free((char *)pOptionItem.args_list);
}

void OptionAux_Proc_LE_Show_Notify(aux_ext_data_t *aux_ext_data)
{
	OptionAux_Reset_OptionsList();
	OptionAux_Show();
}

void OptionAux_Proc_LE_Change_Focus_Notify(aux_ext_data_t *aux_ext_data)
{
	int paletteaux_on, optionaux_on;

	optionaux_on  = aux_ext_data->integer_list[1];
	paletteaux_on = aux_ext_data->integer_list[2];

	DEBUG_printf("OptionAux_Proc_Change_Focus_Notify: \n");
	DEBUG_printf("optionaux_on:%d, paletteaux_on:%d\n", optionaux_on, paletteaux_on);
	if (paletteaux_on && optionaux_on)
		OptionAux_Show();
	else
		OptionAux_Hide();
}

/* ================================================================= */
/*             Send information to Language Engine                   */
/* ================================================================= */
void OptionAux_Connect_To_LE_Request(int locale_id)
{
	int nIntegerCount, pIntegerList[2];

	nIntegerCount = 2;
	pIntegerList[0] = OPTIONAUX_CONNECT;
	pIntegerList[1] = locale_id;
	NotifyIntegerListDataToLanguageEngine(gDisplay, nIntegerCount, pIntegerList);
}

void OptionAux_Update_OptionInfo_Request()
{
	int nIntegerCount, pIntegerList[MAX_ENGINE_NUM + 1];
	int nStringCount, pStringLen[MAX_ENGINE_NUM];
	char *pStringList[MAX_ENGINE_NUM], *name;
	int i, nNum;

	DEBUG_printf("OptionAux_Update_OptionInfo_Request ====\n");

	if (gIMEOptionsNum <= 0) return;
	nNum = gIMEOptionsNum;
	if (nNum > MAX_ENGINE_NUM) nNum = MAX_ENGINE_NUM;

	nIntegerCount = nNum + 1;
	pIntegerList[0] = COMMONAUX_UPDATE_OPTIONSINFO;

	nStringCount = nNum;
	for (i=0; i<nNum; i++) {
		name = gIMEOptions[i]->ime_ename;
		pStringLen[i] = strlen(name);
		pStringList[i] = name;
		pIntegerList[i + 1] = gIMEOptions[i]->opt_value;
		DEBUG_printf("ime:%s, option:%d\n", name, gIMEOptions[i]->opt_value);
	}

	NotifyStringListDataToLanguageEngine(gDisplay, nIntegerCount, pIntegerList,
			nStringCount, pStringLen,
			pStringList);
}

void OptionAux_Change_Status_Request(int bShowed)
{
	int nIntegerCount, pIntegerList[2];

	nIntegerCount = 2;
	pIntegerList[0] = OPTIONAUX_CHANGE_STATUS;
	pIntegerList[1] = bShowed;
	NotifyIntegerListDataToLanguageEngine(gDisplay, nIntegerCount, pIntegerList);
}

NotifyIntegerListDataToLanguageEngine(Display *display, 
int nIntegerCount, int *pIntegerList)
{
	aux_ext_data_t aux_ext_data;

	DEBUG_printf("im_:%d, ic_:%d\n", im_, ic_);

	if (!im_ || !ic_ || !xc_)
		return;

	aux_ext_data.im = im_;
	aux_ext_data.ic = ic_;
	aux_ext_data.integer_count = nIntegerCount;
	aux_ext_data.integer_list = pIntegerList;
	aux_ext_data.string_count = 0;
	aux_ext_data.string_list = NULL;
	aux_ext_data.string_ptr = NULL;
	aux_ext_data.point.x = 0;
	aux_ext_data.point.y = 0;

	xaux_ext_SetValue(display, xc_, &aux_ext_data);
	XFlush(display);
}

NotifyStringListDataToLanguageEngine(Display *display, 
int nIntegerCount, int *pIntegerList,
int nStringCount,  int *pStringLen,
char **pStringList)
{
	int i;

	aux_ext_data_t aux_ext_data;
	aux_ext_string_t *p;

	DEBUG_printf("im_:%d, ic_:%d\n", im_, ic_);

	if (!im_ || !ic_ || !xc_)
		return;

	aux_ext_data.im = im_;
	aux_ext_data.ic = ic_;
	aux_ext_data.integer_count = nIntegerCount;
	aux_ext_data.integer_list = pIntegerList;
	aux_ext_data.point.x = 0;
	aux_ext_data.point.y = 0;

	aux_ext_data.string_count = nStringCount;
	aux_ext_data.string_ptr = NULL;

	if (nStringCount > 0) {
		aux_ext_data.string_list = (aux_ext_string_t *) calloc(nStringCount, sizeof(aux_ext_string_t));
		for (i = 0; i < nStringCount; i++) {
			aux_ext_string_t *p = &aux_ext_data.string_list[i];
			p->length = pStringLen[i];
			p->ptr = (unsigned char *) (pStringList[i]);
		}
	}

	xaux_ext_SetValue(display, xc_, &aux_ext_data);
	XFlush(display);

	free(aux_ext_data.string_list);
}

