/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include <stdio.h>

#include "le.h"
#include "encode.h"
#include "xaux_locale.h"

int map_keyevent_to_immkey(IMKeyEventStruct *key_event);
void proc_key_switch_conversion_event(iml_session_t *s, int on);
void proc_key_round_switch_ime_event(iml_session_t *s);
void proc_key_select_switch_ime_event(iml_session_t *s, int ime_id);
void proc_key_switch_punct_event(iml_session_t *s, int punct);
void proc_key_switch_qjbj_event(iml_session_t *s, int qjbj);
void proc_key_output(iml_session_t *s, IMKeyEventStruct *key_event);

extern int          gEngine_Num;
extern IMEEngineRec *gEngine_Info[MAX_ENGINE_NUM];

/* process the keyboard event */
void proc_key_event(iml_session_t *s, IMKeyListEvent *keylistevent)
{
	MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
	IMKeyEventStruct *key_event = (IMKeyEventStruct *) keylistevent->keylist;

	int key_ret, ime_id, qjbj, punct;

	DEBUG_printf(" proc_keyevent:   session:%x\n", s);

	/* if no input methods in language engine. */
	if (gEngine_Num <=0) {
            	iml_sendback_key(s, key_event);
		return;
	}

	key_ret = map_keyevent_to_immkey(key_event);

	switch (key_ret) {
		/* English status <----> Chinese status */
		case ENGLISH_CHINESE_SWITCH_KEY:
			proc_key_switch_conversion_event(s, CONVERSION_OFF);
			return;

		/* Bound Switching between Input Methods */
		case ROUND_SWITCH_KEY:
			proc_key_round_switch_ime_event(s);
			return;

		/* Switch to N-th Input method */
		case SWITCH_F2_KEY:
		case SWITCH_F3_KEY:
		case SWITCH_F4_KEY:
		case SWITCH_F5_KEY:
		case SWITCH_F6_KEY:
		case SWITCH_F7_KEY:
		case SWITCH_F8_KEY:
		case SWITCH_F9_KEY:
		case SWITCH_F10_KEY:
		case SWITCH_F11_KEY:
		case SWITCH_F12_KEY:
			ime_id = key_ret - SWITCH_F2_KEY;
			proc_key_select_switch_ime_event(s, ime_id);
			return;

		/* English punctuation <---> Chinese punctuation */
		case EN_CH_PUNCT_SWITCH_KEY:
			punct = session_data->paletteaux_status.punct;
			punct = (punct ? False : True);
			proc_key_switch_punct_event(s, punct);
			return;

		/* Full_Width status <----> Half_Width status */
		case FULL_HALF_WIDTH_SWITCH_KEY:
			qjbj = session_data->paletteaux_status.qjbj;
			qjbj = (qjbj ? False : True);
			proc_key_switch_qjbj_event(s, qjbj);
			return;
	}

	proc_key_output(s, key_event);
}

/* filter keys that used by Input Methods Manager */
int map_keyevent_to_immkey(IMKeyEventStruct *key_event) 
{
	int keycode, keystatus, keychar;

	keycode = key_event->keyCode;
	keychar = key_event->keyChar;
	keystatus = key_event->modifier;

	DEBUG_printf("keycode: %d, keychar: %d, status: %d\n",keycode, keychar, keystatus);

	/*  Shift status */
	if (keystatus == IM_SHIFT_MASK) {
		switch(keycode) {
		 	case IM_VK_SPACE:	return(FULL_HALF_WIDTH_SWITCH_KEY);
		 	case IM_VK_CONTROL:	return(ROUND_SWITCH_KEY);
		}
	}

	/*  Control status */
	if (keystatus == IM_CTRL_MASK) {
		switch(keycode) {
		 	case IM_VK_SPACE:	return(ENGLISH_CHINESE_SWITCH_KEY);
		 	case IM_VK_SHIFT:	return(ROUND_SWITCH_KEY);
		 	case IM_VK_PERIOD:	return(EN_CH_PUNCT_SWITCH_KEY);
		}
	}

	/*  Normal Status */
	if (keystatus == 0 || keystatus & IM_CTRL_MASK) {
		switch(keycode) {
		 	case IM_VK_F2:		return(SWITCH_F2_KEY);
		 	case IM_VK_F3:		return(SWITCH_F3_KEY);
		 	case IM_VK_F4:		return(SWITCH_F4_KEY);
		 	case IM_VK_F5:		return(SWITCH_F5_KEY);
		 	case IM_VK_F6:		return(SWITCH_F6_KEY);
		 	case IM_VK_F7:		return(SWITCH_F7_KEY);
		 	case IM_VK_F8:		return(SWITCH_F8_KEY);
		 	case IM_VK_F9:		return(SWITCH_F9_KEY);
		 	case IM_VK_F10:		return(SWITCH_F10_KEY);
		 	case IM_VK_F11:		return(SWITCH_F11_KEY);
		 	case IM_VK_F12:		return(SWITCH_F12_KEY);
		}
	}

	return (IMM_NOT_USED_KEY);

}

void proc_key_switch_conversion_event(iml_session_t *s, int on)
{
	MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
    	MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);
	int engine_id, i;
	char locale_id, system_locale_id;

	DEBUG_printf("ENGLISH_CHINESE SWITCH IME KEY, on:%d\n", on);

       	le_clear_ime_buffer(s, session_data->ime_buffer);

	session_data->paletteaux_status.on = on;
	engine_id = session_data->paletteaux_status.engine_id;
	if (on == CONVERSION_OFF) {
		le_status_draw(s);
		iml_conversion_off(s);
	} else {
		iml_conversion_on(s);
		le_switch_engine(s, engine_id);
	}

	le_change_focus_notify(s);
}

void proc_key_round_switch_ime_event(iml_session_t *s)
{
	MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
    	MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);
	int engine_id, i;
	char locale_id, system_locale_id;

	DEBUG_printf("ROUND SWITCH IME KEY\n");

	DEBUG_printf("paletteaux_ready:%d\n", desktop_data->paletteaux_ready);

	/* PaletteAux can not be started */
	engine_id = session_data->paletteaux_status.engine_id;
	engine_id = (engine_id + 1) % desktop_data->num_engine;

	DEBUG_printf("engine_id:%d\n", engine_id);
       	le_clear_ime_buffer(s, session_data->ime_buffer);
	le_switch_engine(s, engine_id);
	le_change_focus_notify(s);
}

void proc_key_select_switch_ime_event(iml_session_t *s, int ime_id)
{
	MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
    	MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);
	int engine_id, engine_num, i;

	DEBUG_printf("SELECT SWITCH IME KEY\n");

	/* PaletteAux can not be started */
	DEBUG_printf("selected ime_id:%d\n", ime_id);
	engine_id = 0;
	if (ime_id > 0 && ime_id < desktop_data->num_engine)
		engine_id = ime_id;

	DEBUG_printf("engine_id:%d\n", engine_id);
       	le_clear_ime_buffer(s, session_data->ime_buffer);
	le_switch_engine(s, engine_id);
	le_change_focus_notify(s);
}

void proc_key_switch_punct_event(iml_session_t *s, int punct)
{
	MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;

	DEBUG_printf("EN_CH_PUNCT_SWITCH_KEY:%d\n",punct);

	session_data->paletteaux_status.punct = punct;
       	le_clear_ime_buffer(s, session_data->ime_buffer);
	le_switch_punct_notify(s, punct);
}

void proc_key_switch_qjbj_event(iml_session_t *s, int qjbj)
{
	MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;

	DEBUG_printf("FULL_HALF_WIDTH_SWITCH_KEY: %d\n", qjbj);

	session_data->paletteaux_status.qjbj = qjbj;
       	le_clear_ime_buffer(s, session_data->ime_buffer);
	le_switch_qjbj_notify(s, qjbj);
}

int proc_qjbj(iml_session_t *s, IMKeyEventStruct *key_event)
{
    	MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);
	int lang_id, locale_id;
	char *commit_buf;
	int keycode, keystatus, keychar;

	keycode = key_event->keyCode;
	keychar = key_event->keyChar;
	keystatus = key_event->modifier;

	DEBUG_printf("QJBJ PROCESS\n");
	/* normal ASCII key */
        if ((keychar != 0) && (keystatus == IM_SHIFT_MASK || keystatus == 0)) {
		locale_id = desktop_data->aux_locale_id;
		lang_id = get_langid_from_localeid(locale_id);
		commit_buf = (char *)get_qj_str(lang_id, keychar);
		if (commit_buf != NULL) {
			encode_commit(s, ENCODE_UTF8, commit_buf);
			return (IMM_USED_KEY);
		}
        }

	return (IMM_NOT_USED_KEY);
}

int proc_punct(iml_session_t *s, IMKeyEventStruct *key_event)
{
    	MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);
	int lang_id, locale_id;
	char *commit_buf;
	int keycode, keystatus, keychar;

	keycode = key_event->keyCode;
	keychar = key_event->keyChar;
	keystatus = key_event->modifier;

	DEBUG_printf("QJBJ PROCESS\n");
	/* normal ASCII key */
        if ((keychar != 0) && (keystatus == IM_SHIFT_MASK || keystatus == 0)) {
		locale_id = desktop_data->aux_locale_id;
		lang_id = get_langid_from_localeid(locale_id);
		commit_buf = (char *)get_punct_str(lang_id, keychar);
		if (commit_buf != NULL) {
			encode_commit(s, ENCODE_UTF8, commit_buf);
			return (IMM_USED_KEY);
		}
        }

	return (IMM_NOT_USED_KEY);
}

void proc_key_output(iml_session_t *s, IMKeyEventStruct *key_event)
{
	MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
	MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);
	IMEKeyRec  ime_keyevent;
	IMEArgList ime_args;
	int ret, cur_engine_id, qjbj, punct;

	cur_engine_id = session_data->paletteaux_status.engine_id;
	DEBUG_printf("cur_engine_id:%d\n", cur_engine_id);
	if (cur_engine_id < 0 || cur_engine_id >= desktop_data->num_engine) {
            	iml_sendback_key(s, key_event);
		return;
	}

	qjbj = session_data->paletteaux_status.qjbj;
	DEBUG_printf("qjbj:%d\n", qjbj);
	if (qjbj == True) {
		ret = proc_qjbj(s, key_event);
		if (ret == IME_USED_KEY) 
			return;
	}

	ime_keyevent.keyCode = key_event->keyCode;
	ime_keyevent.keyChar = key_event->keyChar;
	ime_keyevent.modifier = key_event->modifier;

	/* get user defined arguments */
	ime_args = desktop_data->ime_args[cur_engine_id];
	desktop_data->engine_info[cur_engine_id]->core.envinfo.output_encode_id = desktop_data->aux_locale_id;
        ret = desktop_data->engine_info[cur_engine_id]->so_methods->IME_Filter(&desktop_data->engine_info[cur_engine_id]->core,
                                                   &ime_keyevent, ime_args, 
                                                   session_data->ime_buffer);

       	le_output_ime_buffer(s, session_data->ime_buffer);

	if (ret == IME_NOT_USED_KEY) {
		punct = session_data->paletteaux_status.punct;
		DEBUG_printf("punct:%d\n", punct);
		if (punct == True) {
			ret = proc_punct(s, key_event);
		}

		if (ret == IME_NOT_USED_KEY)
			iml_sendback_key(s, key_event);
	}
}
