#ifndef IIIMLOOKUPCHOICE_HH_
#define IIIMLOOKUPCHOICE_HH_

#include <iiimcf.h>
#include <qhbox.h>
#include <qlayout.h>
#include <qvaluelist.h>
#include "IIIMText.hh"

class IIIMLookupChoiceItemWidget : public QFrame
{
    QSize currentsize;

    IIIMText *plabel;
    IIIMText *pchoice;

    void drawContents(
	QPainter *p
    );

    QSize sizeHint() const;
    QSize minimumSizeHint() const;

  public:
    IIIMLookupChoiceItemWidget(
	IIIMCF_text label,
	IIIMCF_text choice,
	QWidget *parent = 0,
	const char *name = 0,
	WFlags f = 0
    );
    ~IIIMLookupChoiceItemWidget();
};

class IIIMLookupChoiceWidget : public QHBox
{
    QBoxLayout *playout;
    IIIMCF_context ctx;
    typedef QValueList<IIIMLookupChoiceItemWidget*> IIIMLookupChoiceItemWidgetList;
    IIIMLookupChoiceItemWidgetList itemlist;

    int choices_per_window;
    int number_of_rows;
    int number_of_columns;
    int direction;

    void erase_all_items();
    void set_layout(
        IIIMCF_lookup_choice ilc
    );
    void update_items(
	IIIMCF_lookup_choice ilc
    );

  public:
    void update_im();

    IIIMLookupChoiceWidget(
	IIIMCF_context ctx,
	QWidget *parent = 0,
	const char *name = 0,
	WFlags f = 0
    );
    ~IIIMLookupChoiceWidget();
};

#endif

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */


