/* $Id: comp-binaryfile-object.c,v 1.1.1.1 2002/08/31 04:18:03 himi Exp $ */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>

#include <iiimp-data.h>

#include "iiimp-dataP.h"


IIIMP_binaryfile_object *
iiimp_binaryfile_object_new(
    IIIMP_data_s *	data_s,
    IIIMP_string *	object)
{
    IIIMP_binaryfile_object *	bin_obj;

    bin_obj = (IIIMP_binaryfile_object *)
	malloc(sizeof (IIIMP_binaryfile_object));
    if (NULL == bin_obj) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }

    bin_obj->object = object;
    if (NULL == object) {
	bin_obj->nbyte = 4;
    } else {
	bin_obj->nbyte = object->nbyte;
    }

	return bin_obj;
}


void
iiimp_binaryfile_object_delete(
    IIIMP_data_s *		data_s,
    IIIMP_binaryfile_object *	bin_obj)
{
    if (NULL == bin_obj) return;
    iiimp_string_delete(data_s, bin_obj->object);
    free(bin_obj);
    return;
}


void
iiimp_binaryfile_object_pack(
    IIIMP_data_s *		data_s,
    IIIMP_binaryfile_object *	m,
    size_t *			nbyte,
    uchar_t **			ptr)
{
    size_t			rest;
    uchar_t *			p;

    rest = *nbyte;
    p = *ptr;

    iiimp_string_pack(data_s, m->object, &rest, &p);

    *nbyte = rest;
    *ptr = p;

    return;
}


IIIMP_binaryfile_object *
iiimp_binaryfile_object_unpack(
    IIIMP_data_s *	data_s,
    size_t *		nbyte,
    const uchar_t **	ptr,
    size_t		nbyte_max)
{
    IIIMP_binaryfile_object *	bin_obj;
    size_t			rest;
    const uchar_t *		p;

    rest = nbyte_max;
    p = *ptr;

    if ((*nbyte < rest) || (rest < 4)) {
	data_s->status = IIIMP_DATA_INVALID;
	return NULL;
    }

    bin_obj = (IIIMP_binaryfile_object *)
	malloc(sizeof (IIIMP_binaryfile_object));
    if (NULL == bin_obj) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }

    bin_obj->object = iiimp_string_unpack(data_s, &rest, &p, rest);
    if (NULL == bin_obj->object) {
	free(bin_obj);
	return NULL;
    }

    *nbyte = rest;
    *ptr = p;

    return bin_obj;
}


void
iiimp_binaryfile_object_print(
    IIIMP_data_s *		data_s,
    IIIMP_binaryfile_object *	m)
{
    if (NULL == m) return;

    iiimp_string_print(data_s, m->object);
}


/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
